/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import de.teamlapen.vampirism.api.VReference;
import net.grid.vampiresdelight.common.VDConfiguration;
import net.grid.vampiresdelight.common.block.BloodySoilFarmlandBlock;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class BloodySoilBlock
extends Block {
    public BloodySoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_) {
            BloodySoilBlock.boostCrop(state, level, pos);
        }
    }

    public static void boostCrop(BlockState state, ServerLevel level, BlockPos pos) {
        Block block;
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        if (BloodySoilBlock.canBoostCrop(state, level, pos) && (block = aboveState.m_60734_()) instanceof BonemealableBlock) {
            BonemealableBlock growable = (BonemealableBlock)block;
            if ((double)MathUtils.RAND.nextFloat() <= (Double)VDConfiguration.BLOODY_SOIL_BOOST_CHANCE.get() && growable.m_7370_((LevelReader)level, abovePos, aboveState, false) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)abovePos, (BlockState)aboveState, (boolean)true)) {
                growable.m_214148_(level, level.f_46441_, abovePos, aboveState);
                if (!level.f_46443_) {
                    level.m_46796_(2005, pos.m_7494_(), 0);
                }
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)abovePos, (BlockState)aboveState);
            }
        }
    }

    public static boolean canBoostCrop(BlockState state, ServerLevel level, BlockPos pos) {
        IPlantable iPlantable;
        PlantType plantType;
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        Block aboveBlock = aboveState.m_60734_();
        Block block = state.m_60734_();
        if (block instanceof IPlantable && (plantType = (iPlantable = (IPlantable)block).getPlantType((BlockGetter)level, pos)) != VReference.VAMPIRE_PLANT_TYPE) {
            return false;
        }
        return (Double)VDConfiguration.BLOODY_SOIL_BOOST_CHANCE.get() != 0.0 && !aboveState.m_204336_(ModTags.UNAFFECTED_BY_RICH_SOIL) && !(aboveBlock instanceof TallFlowerBlock);
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction.equals(ToolActions.HOE_TILL) && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
            return ((BloodySoilFarmlandBlock)((Object)VDBlocks.BLOODY_SOIL_FARMLAND.get())).m_49966_();
        }
        return null;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable iPlantable) {
        PlantType plantType = iPlantable.getPlantType(world, pos);
        return plantType != PlantType.CROP && plantType != PlantType.NETHER && plantType != PlantType.WATER;
    }
}

