/*
 * Decompiled with CFR 0.152.
 */
package com.nekotune.battlemusic;

import com.mojang.brigadier.CommandDispatcher;
import com.nekotune.battlemusic.EntityMusic;
import com.nekotune.battlemusic.ModCommands;
import com.nekotune.battlemusic.ModConfigs;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModEvents {

    @Mod.EventBusSubscriber(modid="battlemusic")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onCommandRegister(RegisterCommandsEvent event) {
            ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            EntityMusic.SoundData soundData;
            LivingEntity entity = event.getEntity();
            Level level = entity.f_19853_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (level.m_5776_() && player != null && entity instanceof Mob && EntityMusic.isValidEntity((Mob)entity) && (soundData = EntityMusic.getEntitySoundData().get(entity.m_6095_())) != null && !EntityMusic.isPlaying(soundData.soundEvent())) {
                boolean fail = false;
                ArrayList<EntityMusic.EntityMusicInstance> lowerPriorityInstances = new ArrayList<EntityMusic.EntityMusicInstance>();
                for (EntityMusic.EntityMusicInstance entityMusicInstance : EntityMusic.getInstances().values()) {
                    if (!EntityMusic.isValidEntity(entityMusicInstance.ENTITY)) {
                        entityMusicInstance.destroy();
                        continue;
                    }
                    if (entityMusicInstance.SOUND_DATA.priority() >= soundData.priority()) {
                        fail = true;
                        break;
                    }
                    lowerPriorityInstances.add(entityMusicInstance);
                }
                if (!fail) {
                    lowerPriorityInstances.forEach(instance -> instance.fadeOut(((Double)ModConfigs.FADE_TIME.get()).floatValue()));
                    EntityMusic.spawnInstance(soundData, player, (Mob)entity, Float.valueOf(((Double)ModConfigs.FADE_TIME.get()).floatValue()));
                }
            }
        }
    }
}

