/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.events;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;

public class TEventManager {
    protected final Class<?> owner;

    public TEventManager(Class<?> owner) {
        Objects.requireNonNull(owner, "owner must not be null.");
        this.owner = owner;
    }

    public Class<?> getOwner() {
        return this.owner;
    }

    public class TEvent<E> {
        protected final ArrayList<WeakReference<E>> eventHandlers = Lists.newArrayList();

        public final void garbageDump() {
            this.eventHandlers.removeIf(i -> i.get() == null);
        }

        public E addWeakEventHandler(E handler) {
            Objects.requireNonNull(handler, "handler must not be null.");
            this.eventHandlers.add(new WeakReference<E>(handler));
            return handler;
        }

        public boolean removeEventHandler(E handler) {
            Objects.requireNonNull(handler, "handler must not be null.");
            this.garbageDump();
            return this.eventHandlers.removeIf(i -> i.get() == handler);
        }

        public void p_invoke(Consumer<E> handlerInvoker) {
            Objects.requireNonNull(handlerInvoker, "handlerInvoker must not be null.");
            this.garbageDump();
            for (WeakReference<E> handlerRef : this.eventHandlers) {
                Object handler = handlerRef.get();
                if (handler == null) continue;
                handlerInvoker.accept(handler);
            }
        }
    }
}

