/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.Direction2D;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.AbstractTSliderWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.util.TriConsumer;

public class TScrollBarWidget
extends AbstractTSliderWidget {
    protected final TPanelElement target;
    protected final Consumer<Integer> target_ehScrollH;
    protected final Consumer<Integer> target_ehScrollV;
    protected final TriConsumer<TElement, Boolean, Boolean> target_ehChildAR;

    public TScrollBarWidget(int x, int y, int width, int height, TPanelElement target) {
        super(x, y, width, height, 0.0);
        this.target = Objects.requireNonNull(target, "target must not be null.");
        this.setDrawMessage(false);
        if (height >= width) {
            this.setSliderDirection(Direction2D.DOWN);
            this.target.setScrollFlags(this.target.getScrollFlags() | 4);
        } else {
            this.setSliderDirection(Direction2D.RIGHT);
            this.target.setScrollFlags(this.target.getScrollFlags() | 2);
        }
        this.refreshValue();
        this.refreshKnobSize();
        this.target_ehScrollH = target.getEvents().SCROLL_H.addWeakEventHandler(dX -> {
            if (this.getSliderDirection().isHorizontal()) {
                this.refreshValue();
            }
        });
        this.target_ehScrollV = target.getEvents().SCROLL_V.addWeakEventHandler(dY -> {
            if (this.getSliderDirection().isVertical()) {
                this.refreshValue();
            }
        });
        this.target_ehChildAR = target.getEvents().CHILD_AR.addWeakEventHandler((child, added, repositioned) -> this.refreshKnobSize());
    }

    public final TPanelElement getTarget() {
        return this.target;
    }

    public void refreshValue() {
        if (this.isBeingDragged()) {
            return;
        }
        switch (this.getSliderDirection()) {
            case RIGHT: {
                this.setValue(this.getTarget().getHorizontalScroll(), false);
                break;
            }
            case DOWN: {
                this.setValue(this.getTarget().getVerticalScroll(), false);
                break;
            }
            case UP: {
                this.setValue(1.0 - this.getTarget().getVerticalScroll(), false);
                break;
            }
            case LEFT: {
                this.setValue(1.0 - this.getTarget().getHorizontalScroll(), false);
                break;
            }
        }
    }

    public void refreshKnobSize() {
        if (this.getSliderDirection().isHorizontal()) {
            this.setKnobSize((int)(this.getTarget().getHorizontalScrollKnobSize01() * (double)(this.getTpeWidth() / 2)));
        } else {
            this.setKnobSize((int)(this.getTarget().getVerticalScrollKnobSize01() * (double)(this.getTpeHeight() / 2)));
        }
    }

    @Override
    protected void applyValue() {
        double val = this.getValue();
        switch (this.getSliderDirection()) {
            case RIGHT: {
                this.getTarget().setHorizontalScroll(val);
                break;
            }
            case DOWN: {
                this.getTarget().setVerticalScroll(val);
                break;
            }
            case UP: {
                this.getTarget().setVerticalScroll(1.0 - val);
            }
            case LEFT: {
                this.getTarget().setHorizontalScroll(1.0 - val);
                break;
            }
        }
    }

    @Override
    protected void updateMessage() {
        String str = Mth.m_14045_((int)((int)(this.getValue() * 100.0)), (int)0, (int)100) + "%";
        this.setMessage((Component)TextUtils.literal(str));
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, int amount) {
        TPanelElement target = this.getTarget();
        if (this.getSliderDirection().isHorizontal()) {
            return target.inputHorizontalScroll(target.getScrollSensitivity() * amount);
        }
        return target.inputVerticalScroll(target.getScrollSensitivity() * amount);
    }
}

