/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.widget.AbstractTSliderWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TDynamicSliderWidget
extends AbstractTSliderWidget {
    protected Component label;
    protected Consumer<TDynamicSliderWidget> onValueChange;
    protected ChatFormatting valueFormatting;

    public TDynamicSliderWidget(int x, int y, int width, int height, double value, @Nullable Consumer<TDynamicSliderWidget> onValueChange) {
        this(x, y, width, height, value, null, onValueChange);
    }

    public TDynamicSliderWidget(int x, int y, int width, int height, double value, @Nullable Component label, @Nullable Consumer<TDynamicSliderWidget> onValueChange) {
        super(x, y, width, height, 0.0);
        this.setLabel(label);
        this.setOnValueChange(onValueChange);
        this.setValueFormatting(ChatFormatting.WHITE);
        this.setValue(value);
    }

    public Component getLabel() {
        return this.label;
    }

    public TDynamicSliderWidget setLabel(@Nullable Component label) {
        this.label = label;
        return this;
    }

    @Nullable
    public Consumer<TDynamicSliderWidget> getOnValueChange() {
        return this.onValueChange;
    }

    public TDynamicSliderWidget setOnValueChange(@Nullable Consumer<TDynamicSliderWidget> onValueChange) {
        this.onValueChange = onValueChange;
        return this;
    }

    public ChatFormatting getValueFormatting() {
        return this.valueFormatting;
    }

    public TDynamicSliderWidget setValueFormatting(ChatFormatting formatting) {
        this.valueFormatting = formatting;
        return this;
    }

    @Override
    protected void applyValue() {
        if (this.onValueChange != null) {
            this.onValueChange.accept(this);
        }
    }

    @Override
    protected void updateMessage() {
        if (this.valueFormatting == null) {
            this.valueFormatting = ChatFormatting.WHITE;
        }
        int val = Mth.m_14045_((int)((int)(this.value * 100.0)), (int)0, (int)100);
        if (this.label != null) {
            this.setMessage((Component)TextUtils.fLiteral(this.label.getString() + ": " + this.valueFormatting.toString() + val + "%"));
        } else {
            this.setMessage((Component)TextUtils.fLiteral(this.valueFormatting.toString() + val + "%"));
        }
    }
}

