/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TClickableElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TCheckboxWidget
extends TClickableElement {
    public static final ResourceLocation TEXTURE_CHECKBOX = new ResourceLocation("textures/gui/checkbox.png");
    protected boolean checked;
    protected boolean showMessage;
    protected HorizontalAlignment textAlignment;
    protected HorizontalAlignment checkboxAlignment;
    protected int cX;
    protected int cY;
    protected int tX;
    protected int tY;

    public TCheckboxWidget(int x, int y, int width, int height, MutableComponent message, boolean checked) {
        this(x, y, width, height, message, checked, true);
    }

    public TCheckboxWidget(int x, int y, int width, int height, MutableComponent message, boolean checked, boolean showMessage) {
        super(x, y, width, height, (Component)message);
        this.checked = checked;
        this.showMessage = showMessage;
        this.setHorizontalAlignment(HorizontalAlignment.LEFT, HorizontalAlignment.LEFT);
    }

    @Override
    public void setMessage(Component message) {
        super.setMessage(message);
        this.setHorizontalAlignment(this.textAlignment, this.checkboxAlignment);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean getChecked() {
        return this.isChecked();
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void setHorizontalAlignment(HorizontalAlignment forText, HorizontalAlignment forCheckbox) {
        if (forCheckbox == HorizontalAlignment.CENTER) {
            forCheckbox = HorizontalAlignment.LEFT;
        }
        Minecraft minecraftClient = Minecraft.m_91087_();
        Font tr = minecraftClient.f_91062_;
        this.textAlignment = forText;
        this.checkboxAlignment = forCheckbox;
        int x1 = this.x;
        int x2 = this.x + this.width;
        int msgW = tr.m_92852_((FormattedText)this.getMessage());
        this.cX = forCheckbox == HorizontalAlignment.RIGHT ? x2 - 20 : x1;
        this.cY = this.y;
        if (forCheckbox == HorizontalAlignment.LEFT) {
            x1 += 25;
        } else {
            x2 -= 25;
        }
        switch (forText) {
            case LEFT: {
                this.tX = x1;
                break;
            }
            case RIGHT: {
                this.tX = x2 - msgW;
                break;
            }
            case CENTER: {
                this.tX = (x1 + x2) / 2 - msgW / 2;
                break;
            }
            default: {
                this.tX = x1;
            }
        }
        int n = this.y + this.height / 2;
        Objects.requireNonNull(tr);
        this.tY = n - 9 / 2;
        this.tX -= this.x;
        this.tY -= this.y;
        this.cX -= this.x;
        this.cY -= this.y;
    }

    @Override
    protected void onClick() {
        this.checked = !this.checked;
    }

    @Override
    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        float alpha = this.getAlpha();
        Minecraft minecraftClient = Minecraft.m_91087_();
        Font textRenderer = minecraftClient.f_91062_;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_CHECKBOX);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        TCheckboxWidget.drawTexture(matrices, this.x + this.cX, this.y + this.cY, this.isFocused() ? 20.0f : 0.0f, this.checked ? 20.0f : 0.0f, 20, this.height, 64, 64);
        this.renderBackground(matrices, mouseX, mouseY, deltaTime);
        if (this.showMessage) {
            if (this.textAlignment != HorizontalAlignment.CENTER) {
                TCheckboxWidget.drawTextWithShadow(matrices, textRenderer, this.getMessage(), this.x + this.tX, this.y + this.tY, GuiUtils.applyAlpha(0xE0E0E0, alpha));
            } else {
                TCheckboxWidget.drawCenteredText(matrices, textRenderer, this.getMessage(), this.x + this.tX, this.y + this.tY, GuiUtils.applyAlpha(0xE0E0E0, alpha));
            }
        }
    }
}

