/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.Direction2D;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class TScreenPlus
extends TScreen {
    protected TScreenPlus(Component title) {
        super(title);
    }

    @Nullable
    public TElement findClosestSideElement(TElement target, Direction2D direction) {
        if (target == null || target.getTParent() == null || direction == null) {
            return null;
        }
        int x = target.getTpeX() + target.getTpeWidth() / 2;
        int y = target.getTpeY() + target.getTpeHeight() / 2;
        AtomicReference<Object> closest = new AtomicReference<Object>(null);
        AtomicInteger dX = new AtomicInteger(0);
        AtomicInteger dY = new AtomicInteger(0);
        Function<TElement, Boolean> func = child -> {
            if (child == target || child.isClickThrough() || !child.isEnabledAndVisible() || !child.canChangeFocus(FocusOrigin.TAB, true)) {
                return false;
            }
            int cX = child.getTpeX() + child.getTpeWidth() / 2;
            int cY = child.getTpeY() + child.getTpeHeight() / 2;
            switch (direction) {
                case UP: {
                    if (cY <= y - 1) break;
                    return false;
                }
                case DOWN: {
                    if (cY >= y + 1) break;
                    return false;
                }
                case LEFT: {
                    if (cX <= x - 1) break;
                    return false;
                }
                case RIGHT: {
                    if (cX >= x + 1) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (closest.get() == null) {
                closest.set(child);
                dX.set(Math.abs(cX - x));
                dY.set(Math.abs(cY - y));
                return false;
            }
            if (Math.abs(cX - x) < dX.get() || Math.abs(cY - y) < dY.get()) {
                closest.set(child);
                dX.set(Math.abs(cX - x));
                dY.set(Math.abs(cY - y));
                return false;
            }
            return false;
        };
        target.getTParent().forEachChild(func, true);
        if (closest.get() == null) {
            this.forEachChild(func, true);
        }
        return closest.get();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Direction2D direction;
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        TElement focused = this.getFocusedTChild();
        if (focused == null) {
            return false;
        }
        switch (keyCode) {
            case 265: {
                direction = Direction2D.UP;
                break;
            }
            case 264: {
                direction = Direction2D.DOWN;
                break;
            }
            case 263: {
                direction = Direction2D.LEFT;
                break;
            }
            case 262: {
                direction = Direction2D.RIGHT;
                break;
            }
            default: {
                return false;
            }
        }
        TElement closest = this.findClosestSideElement(focused, direction);
        if (closest == null) {
            return false;
        }
        this.setFocusedTChild(closest);
        this.__triggerScrollTo(closest);
        return true;
    }
}

