/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.events.TPanelEvents;
import io.github.thecsdev.tcdcommons.api.client.gui.util.FocusOrigin;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple2;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple4;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TPanelElement
extends TElement {
    public static final int COLOR_OUTLINE = 0x50FFFFFF;
    public static final int COLOR_OUTLINE_FOCUSED = -5570561;
    public static final int SCROLL_HORIZONTAL = 2;
    public static final int SCROLL_VERTICAL = 4;
    public static final int SCROLL_BOTH = 6;
    protected int scrollFlags;
    protected int scrollSensitivity;
    protected int scrollPadding;
    protected boolean smoothScroll;
    protected float smoothScrollSpeed;
    protected final Tuple4<TElement, TElement, TElement, TElement> topmosts;
    protected double scrollDragX;
    protected double scrollDragY;
    protected double scrollVelocityX;
    protected double scrollVelocityY;
    private final TPanelEvents __events = new TPanelEvents(this);

    public TPanelElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.topmosts = this.getTChildren().getTopmostElements();
        this.setScrollFlags(0);
        this.setScrollSensitivity(20);
        this.setScrollPadding(10);
        this.setSmoothScroll(false);
        this.smoothScrollSpeed = 1.0f;
    }

    @Override
    public TPanelEvents getEvents() {
        return this.__events;
    }

    @Override
    public boolean canChangeFocus(FocusOrigin focusOrigin, boolean gainingFocus) {
        return !gainingFocus;
    }

    @Override
    public void setPosition(int x, int y, int flags) {
        int dx = x - this.x;
        int dy = y - this.y;
        super.setPosition(x, y, flags);
        if (this.isBeingDragged()) {
            this.mouseDragged(this.screen.getMouseX(), this.screen.getMouseY(), -dx, -dy, 0);
        }
    }

    public void setScrollFlags(int flags) {
        this.scrollFlags = flags;
    }

    public int getScrollFlags() {
        return this.scrollFlags;
    }

    public void setScrollPadding(int padding) {
        this.scrollPadding = padding;
    }

    public int getScrollPadding() {
        return this.scrollPadding;
    }

    public int getScrollSensitivity() {
        return this.scrollSensitivity;
    }

    public void setScrollSensitivity(int value) {
        this.scrollSensitivity = value;
    }

    public boolean getSmoothScroll() {
        return Minecraft.m_91405_() && this.smoothScroll;
    }

    public void setSmoothScroll(boolean smoothScroll) {
        this.smoothScroll = smoothScroll;
    }

    protected boolean sFlag(int flagToCheck) {
        return (this.scrollFlags & flagToCheck) == flagToCheck;
    }

    public final boolean isScrollable() {
        return this.sFlag(4) || this.sFlag(2);
    }

    public boolean inputScroll(int scrollAmount) {
        if (this.sFlag(4) || this.sFlag(6)) {
            return this.inputVerticalScroll(scrollAmount);
        }
        if (this.sFlag(2)) {
            return this.inputHorizontalScroll(scrollAmount);
        }
        return false;
    }

    public boolean inputScroll(int xScrollAmount, int yScrollAmount) {
        if (this.sFlag(6)) {
            return this.inputHorizontalScroll(xScrollAmount) | this.inputVerticalScroll(yScrollAmount);
        }
        if (this.sFlag(4)) {
            return this.inputVerticalScroll(yScrollAmount);
        }
        if (this.sFlag(2)) {
            return this.inputHorizontalScroll(xScrollAmount);
        }
        return false;
    }

    public boolean inputHorizontalScroll(int scrollAmount) {
        if (!this.sFlag(2) || !this.topmosts.isFull() || scrollAmount == 0) {
            return false;
        }
        if (scrollAmount > 0) {
            int b;
            a = ((TElement)this.topmosts.Item3).getTpeX();
            int c = -(a - (b = this.getTpeX() + this.getScrollPadding()));
            if (scrollAmount > c) {
                scrollAmount = Math.max(c, 0);
            }
        } else {
            a = ((TElement)this.topmosts.Item4).getTpeEndX();
            int b = this.getTpeX() + this.getTpeWidth() - this.getScrollPadding();
            int c = b - a;
            if (scrollAmount < c) {
                scrollAmount = Math.min(c, 0);
            }
        }
        if (scrollAmount == 0) {
            return false;
        }
        this.moveChildren(scrollAmount, 0);
        int delta = scrollAmount;
        this.getEvents().SCROLL_H.p_invoke(handler -> handler.accept(delta));
        return true;
    }

    public boolean inputVerticalScroll(int scrollAmount) {
        if (!this.sFlag(4) || !this.topmosts.isFull() || scrollAmount == 0) {
            return false;
        }
        if (scrollAmount > 0) {
            int b;
            a = ((TElement)this.topmosts.Item1).getTpeY();
            int c = -(a - (b = this.getTpeY() + this.getScrollPadding()));
            if (scrollAmount > c) {
                scrollAmount = Math.max(c, 0);
            }
        } else {
            a = ((TElement)this.topmosts.Item2).getTpeEndY();
            int b = this.getTpeY() + this.getTpeHeight() - this.getScrollPadding();
            int c = b - a;
            if (scrollAmount < c) {
                scrollAmount = Math.min(c, 0);
            }
        }
        if (scrollAmount == 0) {
            return false;
        }
        int delta = scrollAmount;
        this.moveChildren(0, delta);
        this.getEvents().SCROLL_V.p_invoke(handler -> handler.accept(delta));
        return true;
    }

    @Nullable
    private Tuple2<Point, Point> __getHorizontalSeCnvElm() {
        if (!this.topmosts.isFull()) {
            return null;
        }
        Point seCnv = new Point(this.getTpeX() + this.getScrollPadding(), this.getTpeEndX() - this.getScrollPadding());
        Point seElm = new Point(((TElement)this.topmosts.Item3).getTpeX(), ((TElement)this.topmosts.Item4).getTpeEndX());
        return new Tuple2<Point, Point>(seCnv, seElm);
    }

    @Nullable
    private Tuple2<Point, Point> __getVerticalSeCnvElm() {
        if (!this.topmosts.isFull()) {
            return null;
        }
        Point seCnv = new Point(this.getTpeY() + this.getScrollPadding(), this.getTpeEndY() - this.getScrollPadding());
        Point seElm = new Point(((TElement)this.topmosts.Item1).getTpeY(), ((TElement)this.topmosts.Item2).getTpeEndY());
        return new Tuple2<Point, Point>(seCnv, seElm);
    }

    public double getHorizontalScroll() {
        if (!this.topmosts.isFull()) {
            return 0.0;
        }
        double distFrom0 = this.getTpeX() + this.getScrollPadding() - ((TElement)this.topmosts.Item3).getTpeX();
        double distFrom1 = this.getTpeEndX() - this.getScrollPadding() - ((TElement)this.topmosts.Item4).getTpeEndX();
        if (distFrom0 <= 0.0) {
            return 0.0;
        }
        if (distFrom1 >= 0.0) {
            return 1.0;
        }
        distFrom0 = Math.abs(distFrom0);
        distFrom1 = Math.abs(distFrom1);
        return distFrom0 / (distFrom0 + distFrom1);
    }

    public double getVerticalScroll() {
        if (!this.topmosts.isFull()) {
            return 0.0;
        }
        double distFrom0 = this.getTpeY() + this.getScrollPadding() - ((TElement)this.topmosts.Item1).getTpeY();
        double distFrom1 = this.getTpeEndY() - this.getScrollPadding() - ((TElement)this.topmosts.Item2).getTpeEndY();
        if (distFrom0 <= 0.0) {
            return 0.0;
        }
        if (distFrom1 >= 0.0) {
            return 1.0;
        }
        distFrom0 = Math.abs(distFrom0);
        distFrom1 = Math.abs(distFrom1);
        return distFrom0 / (distFrom0 + distFrom1);
    }

    public void setHorizontalScroll(double amount01) {
        if (!this.topmosts.isFull()) {
            return;
        }
        amount01 = Mth.m_14008_((double)amount01, (double)0.0, (double)1.0);
        int moveBy = this.getTpeX() + this.getScrollPadding() - ((TElement)this.topmosts.Item3).getTpeX();
        Tuple2<Point, Point> seCnvElm = this.__getHorizontalSeCnvElm();
        ((Point)seCnvElm.Item1).y -= ((Point)seCnvElm.Item1).x;
        ((Point)seCnvElm.Item1).x = 0;
        ((Point)seCnvElm.Item2).y -= ((Point)seCnvElm.Item2).x;
        ((Point)seCnvElm.Item2).x = 0;
        int elmW = ((Point)seCnvElm.Item2).x + ((Point)seCnvElm.Item2).y;
        int cnvW = ((Point)seCnvElm.Item1).x + ((Point)seCnvElm.Item1).y;
        double d0 = elmW - cnvW;
        if (d0 > 0.0) {
            moveBy -= (int)(d0 * amount01);
        }
        int delta = moveBy;
        this.moveChildren(delta, 0);
        this.getEvents().SCROLL_H.p_invoke(handler -> handler.accept(delta));
    }

    public void setVerticalScroll(double amount01) {
        if (!this.topmosts.isFull()) {
            return;
        }
        amount01 = Mth.m_14008_((double)amount01, (double)0.0, (double)1.0);
        int moveBy = this.getTpeY() + this.getScrollPadding() - ((TElement)this.topmosts.Item3).getTpeY();
        Tuple2<Point, Point> seCnvElm = this.__getVerticalSeCnvElm();
        ((Point)seCnvElm.Item1).y -= ((Point)seCnvElm.Item1).x;
        ((Point)seCnvElm.Item1).x = 0;
        ((Point)seCnvElm.Item2).y -= ((Point)seCnvElm.Item2).x;
        ((Point)seCnvElm.Item2).x = 0;
        int elmW = ((Point)seCnvElm.Item2).x + ((Point)seCnvElm.Item2).y;
        int cnvW = ((Point)seCnvElm.Item1).x + ((Point)seCnvElm.Item1).y;
        double d0 = elmW - cnvW;
        if (d0 > 0.0) {
            moveBy -= (int)(d0 * amount01);
        }
        int delta = moveBy;
        this.moveChildren(0, delta);
        this.getEvents().SCROLL_V.p_invoke(handler -> handler.accept(delta));
    }

    public double getHorizontalScrollKnobSize01() {
        double elmW;
        Tuple2<Point, Point> seCnvElm = this.__getHorizontalSeCnvElm();
        if (seCnvElm == null) {
            return 1.0;
        }
        double cnvW = Math.abs(((Point)seCnvElm.Item1).x - ((Point)seCnvElm.Item1).y);
        if (cnvW > (elmW = (double)Math.abs(((Point)seCnvElm.Item2).x - ((Point)seCnvElm.Item2).y))) {
            return 1.0;
        }
        return Mth.m_14008_((double)(cnvW / Math.max(elmW, 1.0)), (double)0.0, (double)1.0);
    }

    public double getVerticalScrollKnobSize01() {
        double elmW;
        Tuple2<Point, Point> seCnvElm = this.__getVerticalSeCnvElm();
        if (seCnvElm == null) {
            return 1.0;
        }
        double cnvW = Math.abs(((Point)seCnvElm.Item1).x - ((Point)seCnvElm.Item1).y);
        if (cnvW > (elmW = (double)Math.abs(((Point)seCnvElm.Item2).x - ((Point)seCnvElm.Item2).y))) {
            return 1.0;
        }
        return Mth.m_14008_((double)(cnvW / Math.max(elmW, 1.0)), (double)0.0, (double)1.0);
    }

    public void scrollToChild(TElement child) {
        int tY;
        int cY;
        int teY;
        int ceY;
        int tX;
        int cX;
        int diffB;
        int teX;
        if (child == null) {
            return;
        }
        int inputX = 0;
        int inputY = 0;
        int ceX = child.getTpeEndX();
        int diffA = ceX - (teX = this.getTpeEndX() - this.getScrollPadding());
        if (diffA > 0) {
            inputX = -diffA;
        }
        if ((diffB = (cX = child.getTpeX()) - (tX = this.getTpeX() + this.getScrollPadding())) < 0) {
            inputX = -diffB;
        }
        if ((diffA = (ceY = child.getTpeEndY()) - (teY = this.getTpeEndY() - this.getScrollPadding())) > 0) {
            inputY = -diffA;
        }
        if ((diffB = (cY = child.getTpeY()) - (tY = this.getTpeY() + this.getScrollPadding())) < 0) {
            inputY = -diffB;
        }
        if (inputX != 0 || inputY != 0) {
            this.inputScroll(inputX, inputY);
        }
    }

    protected boolean applyScrollDrag() {
        int sdX = (int)this.scrollDragX;
        int sdY = (int)this.scrollDragY;
        if (sdX == 0 && sdY == 0) {
            return false;
        }
        this.scrollDragX -= (double)sdX;
        this.scrollDragY -= (double)sdY;
        boolean h = this.inputHorizontalScroll(sdX);
        boolean v = this.inputVerticalScroll(sdY);
        if (sdX != 0 && !h) {
            this.scrollDragX = 0.0;
            this.scrollVelocityX = 0.0;
        }
        if (sdY != 0 && !v) {
            this.scrollDragY = 0.0;
            this.scrollVelocityY = 0.0;
        }
        return h || v;
    }

    protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        TPanelElement.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)GuiUtils.applyAlpha(0x50000000, this.getAlpha()));
    }

    protected void renderSmoothScroll(float deltaTime) {
        double sign;
        if (!this.getSmoothScroll() || this.isBeingDragged()) {
            return;
        }
        if (this.scrollVelocityY != 0.0) {
            sign = this.scrollVelocityY * (double)deltaTime * (double)Math.abs(this.smoothScrollSpeed) * 0.5;
            this.scrollVelocityY -= sign;
            this.scrollDragY += sign;
            if (Math.abs(this.scrollVelocityY) <= Math.abs(sign)) {
                this.scrollVelocityY = 0.0;
            }
        }
        if (this.scrollVelocityX != 0.0) {
            sign = this.scrollVelocityX * (double)deltaTime * (double)Math.abs(this.smoothScrollSpeed) * 0.5;
            this.scrollVelocityX -= sign;
            this.scrollDragX += sign;
            if (Math.abs(this.scrollVelocityX) <= Math.abs(sign)) {
                this.scrollVelocityX = 0.0;
            }
        }
        this.applyScrollDrag();
    }

    @Override
    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        this.renderBackground(matrices, mouseX, mouseY, deltaTime);
        this.renderSmoothScroll(deltaTime);
    }

    @Override
    public void postRender(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        this.drawOutline(matrices, GuiUtils.applyAlpha(this.isFocused() ? -5570561 : 0x50FFFFFF, this.getAlpha()));
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int button) {
        this.scrollDragX = 0.0;
        this.scrollDragY = 0.0;
        this.scrollVelocityX = 0.0;
        this.scrollVelocityY = 0.0;
        return super.mousePressed(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
        this.scrollDragX += deltaX;
        this.scrollDragY += deltaY;
        return this.applyScrollDrag();
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, int amount) {
        if (this.isBeingDragged()) {
            return false;
        }
        int scrollAmount = amount * this.getScrollSensitivity();
        if (this.sFlag(4) || this.sFlag(6)) {
            if (this.getSmoothScroll()) {
                this.scrollVelocityY += (double)scrollAmount;
                return true;
            }
            return this.inputVerticalScroll(scrollAmount);
        }
        if (this.sFlag(2)) {
            if (this.getSmoothScroll()) {
                this.scrollVelocityX += (double)scrollAmount;
                return true;
            }
            return this.inputHorizontalScroll(scrollAmount);
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean b0 = false;
        if (keyCode == 265) {
            b0 = b0 || this.inputVerticalScroll(-this.scrollSensitivity);
        } else if (keyCode == 264) {
            boolean bl = b0 = b0 || this.inputVerticalScroll(this.scrollSensitivity);
        }
        if (keyCode == 263) {
            b0 = b0 || this.inputHorizontalScroll(-this.scrollSensitivity);
        } else if (keyCode == 262) {
            b0 = b0 || this.inputHorizontalScroll(this.scrollSensitivity);
        }
        return b0;
    }
}

