/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.other;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TTooltipElement
extends TElement {
    @Nullable
    protected MultiLineLabel multilineText;
    protected int textColor;
    protected int maxWidth;
    protected int lineSpacing;

    public TTooltipElement(int maxWidth) {
        this(0, 0, maxWidth, null);
    }

    public TTooltipElement(int x, int y, int maxWidth) {
        this(x, y, maxWidth, null);
    }

    public TTooltipElement(int x, int y, int maxWidth, Component text) {
        super(x, y, Math.max(maxWidth, 60), 10);
        this.m_93250_((int)(this.getItemRenderer().f_115093_ + 120.0f));
        this.textColor = Color.WHITE.getRGB();
        this.setMaxWidth(maxWidth);
        this.setLineSpacing(4);
        this.setTooltip(text);
    }

    @Override
    public final boolean getEnabled() {
        return false;
    }

    @Override
    public final boolean isClickThrough() {
        return true;
    }

    @Override
    @Nullable
    public Rectangle getRenderingBoundingBox() {
        this.RENDER_RECT.setLocation(this.getTpeX(), this.getTpeY());
        this.RENDER_RECT.setSize(this.getTpeWidth(), this.getTpeHeight());
        return this.RENDER_RECT;
    }

    @Override
    public void setTooltip(@Nullable Component tooltip) {
        super.setTooltip(tooltip);
        this.refreshText();
    }

    public final void refreshText() {
        Component text = this.getTooltip();
        int textW = this.getTextWidth(text);
        this.width = textW < this.maxWidth ? 10 + textW : this.maxWidth;
        this.multilineText = text != null ? MultiLineLabel.m_94341_((Font)this.getTextRenderer(), (FormattedText)text, (int)this.getTpeWidth()) : null;
        this.height = 10 + this.getTextHeight();
    }

    public void refreshPosition(@Nullable TElement target, int mouseX, int mouseY) {
        if (target != null && target.isFocused()) {
            this.refreshPosition_toElement(target);
        } else {
            this.refreshPosition_toCursor(mouseX, mouseY);
        }
    }

    protected void refreshPosition_toCursor(int mouseX, int mouseY) {
        TScreen p = this.screen;
        if (p == null) {
            return;
        }
        this.x = mouseX + 5;
        this.y = mouseY + 5;
        if (this.getTpeEndX() > p.getTpeEndX()) {
            this.x -= this.getTpeWidth() + 10;
        }
        if (this.getTpeEndY() > p.getTpeEndY()) {
            this.y -= this.getTextHeight() + 10;
        }
    }

    protected void refreshPosition_toElement(TElement target) {
        TScreen p = this.screen;
        if (p == null) {
            return;
        }
        this.x = target.getTpeX();
        this.y = target.getTpeEndY();
        if (this.getTpeEndX() > p.getTpeEndX()) {
            this.x -= this.getTpeWidth() - target.getTpeWidth();
        }
        if (this.getTpeEndY() > p.getTpeEndY()) {
            this.y -= this.getTpeHeight() + target.getTpeHeight();
        }
    }

    public final int getTextHeight() {
        Objects.requireNonNull(this.getTextRenderer());
        int fh = 9;
        int ls = this.getLineSpacing();
        if (this.multilineText == null) {
            return fh;
        }
        return this.multilineText.m_5770_() * (fh + ls) - ls;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int spacing) {
        this.lineSpacing = Mth.m_14045_((int)spacing, (int)0, (int)20);
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = Math.max(maxWidth, 60);
    }

    @Override
    public void render(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)T_WIDGETS_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        this.draw9SliceTexture(matrices, 40, 20, 20, 20, 3);
        this.drawMessage(matrices, mouseX, mouseY, deltaTime);
    }

    public void drawMessage(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        if (this.multilineText == null || this.screen == null) {
            return;
        }
        Rectangle rr = this.getRenderingBoundingBox();
        if (rr == null) {
            return;
        }
        GuiUtils.enableScissor(this.screen.getClient(), rr.x, rr.y, rr.width, rr.height);
        Objects.requireNonNull(this.getTextRenderer());
        int lh = 9 + this.getLineSpacing();
        this.multilineText.m_6516_(matrices, this.getTpeX() + 5, this.getTpeY() + 5, lh, this.textColor);
        this.screen.resetScissors();
    }

    public final int getTextWidth(Component text) {
        if (text == null) {
            return 0;
        }
        Font tr = this.getTextRenderer();
        String[] lines = text.getString().split("\\r?\\n");
        if (lines.length < 2) {
            return tr.m_92852_((FormattedText)text);
        }
        int maxLineSize = 0;
        for (String line : lines) {
            int lineSize = tr.m_92895_(line);
            if (maxLineSize >= lineSize) continue;
            maxLineSize = lineSize;
        }
        return maxLineSize;
    }
}

