/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TElementList;
import java.awt.Rectangle;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface TParentElement {
    public int getTpeX();

    public int getTpeY();

    public int getTpeWidth();

    public int getTpeHeight();

    default public int getTpeEndX() {
        return this.getTpeX() + this.getTpeWidth();
    }

    default public int getTpeEndY() {
        return this.getTpeY() + this.getTpeHeight();
    }

    default public double getZIndex() {
        return 0.0;
    }

    default public float getAlpha() {
        return 1.0f;
    }

    @Nullable
    public TParentElement getTParent();

    public TElementList getTChildren();

    default public void clearTChildren() {
        this.getTChildren().clear();
    }

    @Nullable
    default public TElement getLastTChild(boolean nested) {
        TElementList children = this.getTChildren();
        if (children == null || children.size() == 0) {
            return null;
        }
        TElement last = (TElement)children.get(children.size() - 1);
        while (nested && last.getTChildren().size() > 0) {
            last = last.getLastTChild(nested);
        }
        return last;
    }

    @Nullable
    default public <T extends TElement> T findTChildOfType(Class<T> type, boolean nested) {
        TElement found = this.forEachChild(child -> type.isAssignableFrom(child.getClass()), nested);
        if (found == null) {
            return null;
        }
        return (T)found;
    }

    default public <T extends TElement> boolean addTChild(T child) {
        return this.getTChildren().add(child);
    }

    default public <T extends TElement> boolean addTChild(T child, boolean reposition) {
        return this.getTChildren().add(child, reposition);
    }

    default public <T extends TElement> boolean removeTChild(T child) {
        return this.getTChildren().remove(child);
    }

    default public <T extends TElement> boolean removeTChild(T child, boolean reposition) {
        return this.getTChildren().remove(child, reposition);
    }

    @Nullable
    public Rectangle getRenderingBoundingBox();

    public void updateRenderingBoundingBox();

    @Nullable
    default public TElement forEachChild(@Nullable Function<TElement, Boolean> action, boolean nested) {
        return this.forEachChild(action, null, nested);
    }

    @Nullable
    default public TElement forEachChild(@Nullable Function<TElement, Boolean> action, @Nullable Function<TElement, Boolean> postAction, boolean nested) {
        return TParentElement.internal_forEachChild(this, action, postAction, nested, 0);
    }

    @Nullable
    private static TElement internal_forEachChild(TParentElement parent, @Nullable Function<TElement, Boolean> action, @Nullable Function<TElement, Boolean> postAction, boolean nested, int iteration) {
        TElement parentTEl;
        TElementList children = parent.getTChildren();
        if (children == null || iteration > 7) {
            return null;
        }
        TElement tElement = parentTEl = parent instanceof TElement ? (TElement)parent : null;
        TScreen parentTSc = parent instanceof TScreen ? (TScreen)parent : (parentTEl != null ? parentTEl.screen : null);
        for (TElement child : parent.getTChildren()) {
            TElement canceller;
            if (child == null) continue;
            child.parent = parentTEl;
            child.screen = parentTSc;
            if (action != null && action.apply(child).booleanValue()) {
                return child;
            }
            if (nested && (canceller = TParentElement.internal_forEachChild(child, action, postAction, nested, iteration + 1)) != null) {
                return canceller;
            }
            if (postAction == null || !postAction.apply(child).booleanValue()) continue;
            return child;
        }
        return null;
    }
}

