/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class TDrawableHelper
extends GuiComponent
implements TParentElement {
    public static final ResourceLocation WIDGETS_TEXTURE = AbstractButton.f_93098_;
    public static final ResourceLocation T_WIDGETS_TEXTURE = new ResourceLocation(TCDCommons.getModID(), "textures/gui/widgets.png");

    public void drawOutline(PoseStack matrices, int color) {
        int x = this.getTpeX();
        int y = this.getTpeY();
        int w = this.getTpeWidth();
        int h = this.getTpeHeight();
        int ol = GuiUtils.applyAlpha(color, this.getAlpha());
        this.drawHorizontalLine(matrices, x, x + w - 1, y, ol);
        this.drawHorizontalLine(matrices, x, x + w - 1, y + h - 1, ol);
        this.drawVerticalLine(matrices, x, y, y + h - 1, ol);
        this.drawVerticalLine(matrices, x + w - 1, y, y + h - 1, ol);
    }

    public void drawHorizontalLine(PoseStack matrices, int x1, int x2, int y, int color) {
        this.m_93154_(matrices, x1, x2, y, color);
    }

    public void drawVerticalLine(PoseStack matrices, int x, int y1, int y2, int color) {
        this.m_93222_(matrices, x, y1, y2, color);
    }

    public void draw9SliceTexture(PoseStack matrices, int u, int v, int regionWidth, int regionHeight, int slice) {
        TDrawableHelper.draw9SliceTexture(matrices, this.getTpeX(), this.getTpeY(), this.getTpeWidth(), this.getTpeHeight(), u, v, regionHeight, regionHeight, 256, 256, slice);
    }

    public static void draw9SliceTexture(PoseStack matrices, int x, int y, int w, int h, int u, int v, int uW, int vH, int tW, int tH, int s) {
        int s2 = s * 2;
        if (s2 < w || s2 < h) {
            TDrawableHelper.drawTexture(matrices, x, y, s, s, u, v, s, s, tW, tH);
            TDrawableHelper.drawTexture(matrices, x + w - s, y, s, s, u + uW - s, v, s, s, tW, tH);
            TDrawableHelper.drawTexture(matrices, x, y + h - s, s, s, u, v + vH - s, s, s, tW, tH);
            TDrawableHelper.drawTexture(matrices, x + w - s, y + h - s, s, s, u + uW - s, v + vH - s, s, s, tW, tH);
            TDrawableHelper.drawTexture(matrices, x + s, y, w - s2, s, u + s, v, uW - s2, s, tW, tH);
            TDrawableHelper.drawTexture(matrices, x, y + s, s, h - s2, u, v + s, s, vH - s2, tW, tH);
            TDrawableHelper.drawTexture(matrices, x + w - s, y + s, s, h - s2, u + uW - s, v + s, s, vH - s2, tW, tH);
            TDrawableHelper.drawTexture(matrices, x + s, y + h - s, w - s2, s, u + s, v + vH - s, uW - s2, s, tW, tH);
            TDrawableHelper.drawTiledTexture(matrices, x + s, y + s, w - s2, h - s2, u + s, v + s, uW - s2, vH - s2, tW, tH);
        } else {
            TDrawableHelper.drawTexture(matrices, x, y, w, h, u, v, uW, vH, tW, tH);
        }
    }

    public static void drawTiledTexture(PoseStack matrices, int x, int y, int w, int h, int u, int v, int uW, int vH, int tW, int tH) {
        int endX = x + w;
        int endY = y + h;
        for (int y1 = y; y1 < endY; y1 += vH) {
            for (int x1 = x; x1 < endX; x1 += uW) {
                int nextW = uW;
                int nextH = vH;
                if (x1 + nextW > endX) {
                    nextW -= x1 + nextW - endX;
                }
                if (y1 + nextH > endY) {
                    nextH -= y1 + nextH - endY;
                }
                if (nextW < 1 || nextH < 1) continue;
                TDrawableHelper.drawTexture(matrices, x1, y1, nextW, nextH, u, v, nextW, nextH, tW, tH);
            }
        }
    }

    public static void drawTexture(PoseStack matrices, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        TDrawableHelper.m_93160_((PoseStack)matrices, (int)x, (int)y, (int)width, (int)height, (float)u, (float)v, (int)regionWidth, (int)regionHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void drawTexture(PoseStack matrices, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        TDrawableHelper.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
    }

    public static void drawTextWithShadow(PoseStack matrices, Font textRenderer, Component text, int x, int y, int color) {
        TDrawableHelper.m_93243_((PoseStack)matrices, (Font)textRenderer, (Component)text, (int)x, (int)y, (int)color);
    }

    public static void drawCenteredText(PoseStack matrices, Font textRenderer, String text, int centerX, int y, int color) {
        TDrawableHelper.m_93208_((PoseStack)matrices, (Font)textRenderer, (String)text, (int)centerX, (int)y, (int)color);
    }

    public static void drawCenteredText(PoseStack matrices, Font textRenderer, Component text, int centerX, int y, int color) {
        TDrawableHelper.m_93215_((PoseStack)matrices, (Font)textRenderer, (Component)text, (int)centerX, (int)y, (int)color);
    }
}

