/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.events.TClickableElementEvents;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class TClickableElement
extends TElement {
    protected boolean enabled = true;
    @Nullable
    protected Component message;
    private final TClickableElementEvents __events = new TClickableElementEvents(this);

    public TClickableElement(int x, int y, int width, int height, @Nullable Component message) {
        super(x, y, width, height);
        this.message = message;
    }

    @Override
    public TClickableElementEvents getEvents() {
        return this.__events;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract void onClick();

    @Nullable
    public Component getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable Component label) {
        this.message = label;
    }

    @Override
    public boolean mousePressed(int mouseX, int mouseY, int button) {
        if (button == 0 && this.isHovered()) {
            GuiUtils.playClickSound();
            this.onClick();
            this.getEvents().CLICKED.p_invoke(handler -> handler.run());
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335 || keyCode == 32) {
            GuiUtils.playClickSound();
            this.onClick();
            this.getEvents().CLICKED.p_invoke(handler -> handler.run());
            return true;
        }
        return false;
    }

    protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
    }

    public final int getButtonYImage() {
        return TClickableElement.getButtonYImage(this.isEnabled(), this.isFocusedOrHovered());
    }

    public static int getButtonYImage(boolean enabled, boolean hovered) {
        if (!enabled) {
            return 0;
        }
        if (hovered) {
            return 2;
        }
        return 1;
    }

    protected void drawButton(PoseStack matrices, int mouseX, int mouseY, float deltaTime) {
        this.drawButton(matrices, mouseX, mouseY, deltaTime, this.getButtonYImage());
    }

    protected void drawButton(PoseStack matrices, int mouseX, int mouseY, float deltaTime, int yImage) {
        this.drawButton(matrices, mouseX, mouseY, deltaTime, 1.0f, 1.0f, 1.0f, yImage);
    }

    protected void drawButton(PoseStack matrices, int mouseX, int mouseY, float deltaTime, float r, float g, float b, int yImage) {
        float alpha = this.getAlpha();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)alpha);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)T_WIDGETS_TEXTURE);
        this.draw9SliceTexture(matrices, yImage * 20, 0, 20, 20, 3);
        this.renderBackground(matrices, mouseX, mouseY, deltaTime);
    }

    protected final void drawMessage(PoseStack matrices, float deltaTime) {
        this.drawMessage(matrices, HorizontalAlignment.CENTER, deltaTime);
    }

    protected void drawMessage(PoseStack matrices, HorizontalAlignment alignment, float deltaTime) {
        this.drawTElementText(matrices, this.getMessage(), alignment, deltaTime);
    }
}

