/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons;

import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.server.TCDCommonsServer;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="tcdcommons")
public class TCDCommons {
    private static TCDCommons Instance;
    public static final Logger LOGGER;
    public static final String ModName = "TCDCommons API";
    public static final String ModID = "tcdcommons";
    public final ModContainer ModInfo = (ModContainer)ModList.get().getModContainerById("tcdcommons").get();

    public TCDCommons() {
        if (TCDCommons.isModInitialized()) {
            TCDCommons.crash("Attempting to initialize tcdcommons", new RuntimeException("tcdcommons has already been initialized."));
        }
        if (this.getClass().equals(TCDCommons.class)) {
            if (FMLEnvironment.dist.isClient()) {
                new TCDCommonsClient();
            } else if (FMLEnvironment.dist.isDedicatedServer()) {
                new TCDCommonsServer();
            } else {
                TCDCommons.crash("Attempting to initialize tcdcommons", new RuntimeException("Invalid FMLEnvironment.dist()"));
            }
            return;
        }
        Instance = this;
        LOGGER.info("Initializing '" + TCDCommons.getModName() + "' as '" + this.getClass().getSimpleName() + "'.");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void crash(String crashMessage, Throwable exception) {
        CrashReport crashReport = CrashReport.m_127521_((Throwable)exception, (String)crashMessage);
        throw new ReportedException(crashReport);
    }

    public static String getModName() {
        return ModName;
    }

    public static String getModID() {
        return ModID;
    }

    public static TCDCommons getInstance() {
        return Instance;
    }

    public static boolean isModInitialized() {
        return TCDCommons.isInstanceValid(Instance);
    }

    private static boolean isInstanceValid(TCDCommons instance) {
        return TCDCommons.isServer(instance) || TCDCommons.isClient(instance);
    }

    public static boolean isServer() {
        return TCDCommons.isServer(Instance);
    }

    public static boolean isClient() {
        return TCDCommons.isClient(Instance);
    }

    private static boolean isServer(TCDCommons arg0) {
        return arg0 instanceof TCDCommonsServer;
    }

    private static boolean isClient(TCDCommons arg0) {
        return arg0 instanceof TCDCommonsClient;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)TCDCommons.getModID());
    }
}

