/*
 * Decompiled with CFR 0.152.
 */
package thecsdev.nounusedchunks.mixin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import net.minecraft.class_1257;
import net.minecraft.class_148;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_2794;
import net.minecraft.class_32;
import net.minecraft.class_3977;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thecsdev.nounusedchunks.NoUnusedChunks;
import thecsdev.nounusedchunks.config.NUCConfig;

@Mixin(value={class_1257.class}, priority=1001)
public abstract class WorldUpdaterMixin {
    @Shadow
    public static Logger field_5756;
    @Shadow
    public class_5285 field_35454;
    @Shadow
    public boolean field_19225;
    @Shadow
    public class_32.class_5143 field_24083;
    @Shadow
    public Thread field_5767;
    @Shadow
    public DataFixer field_24084;
    @Shadow
    public volatile boolean field_5760;
    @Shadow
    public volatile boolean field_5759;
    @Shadow
    public volatile float field_5763;
    @Shadow
    public volatile int field_5768;
    @Shadow
    public volatile int field_5766;
    @Shadow
    public volatile int field_5764;
    @Shadow
    public volatile class_2561 field_5765;
    @Shadow
    public class_26 field_5755;
    @Shadow
    public Object2FloatMap<class_5321<class_1937>> field_5762;

    @Shadow
    public abstract List<class_1923> method_17830(class_5321<class_1937> var1);

    @Inject(method={"updateWorld"}, at={@At(value="HEAD")}, cancellable=true)
    public void onUpdateWorld(CallbackInfo callback) {
        if (!NUCConfig.OW_RUC) {
            return;
        }
        callback.cancel();
        field_5756.info("Using \"nounusedchunks's\" WorldUpdater and optimization system.");
        this.field_5768 = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableSet immutableSet = this.field_35454.method_29575();
        for (class_5321 registryKey : immutableSet) {
            List<class_1923> list = this.method_17830((class_5321<class_1937>)registryKey);
            builder.put((Object)registryKey, list.listIterator());
            this.field_5768 += list.size();
        }
        if (this.field_5768 == 0) {
            this.field_5759 = true;
            return;
        }
        float f = this.field_5768;
        ImmutableMap immutableMap = builder.build();
        ImmutableMap.Builder worldRegionFilesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder __worldTempRegionFilesBuilder = ImmutableMap.builder();
        for (class_5321 registryKey2 : immutableSet) {
            Path path = this.field_24083.method_27424(registryKey2);
            worldRegionFilesBuilder.put((Object)registryKey2, (Object)new class_3977(path.resolve("region"), this.field_24084, true));
            __worldTempRegionFilesBuilder.put((Object)registryKey2, (Object)new class_3977(path.resolve("region").resolve("nounusedchunks_temp"), this.field_24084, true));
        }
        ImmutableMap worldRegionFiles = worldRegionFilesBuilder.build();
        ImmutableMap __worldTempRegionFiles = __worldTempRegionFilesBuilder.build();
        long l = class_156.method_658();
        this.field_5765 = class_2561.method_43471((String)"optimizeWorld.stage.upgrading");
        while (this.field_5760) {
            boolean willKeepUpgradingChunks = false;
            float g = 0.0f;
            for (class_5321 worldRegKey : immutableSet) {
                ListIterator worldChunkIterator = (ListIterator)immutableMap.get((Object)worldRegKey);
                class_3977 versionedChunkStorage = (class_3977)worldRegionFiles.get((Object)worldRegKey);
                class_3977 __vcsTemp = (class_3977)__worldTempRegionFiles.get((Object)worldRegKey);
                if (worldChunkIterator.hasNext()) {
                    class_1923 chunkPos = (class_1923)worldChunkIterator.next();
                    boolean willChunkNotSkip = false;
                    try {
                        class_2487 oldChunkNbt = ((Optional)versionedChunkStorage.method_23696(chunkPos).join()).orElse(null);
                        if (oldChunkNbt != null) {
                            int chunkDataVersion = class_3977.method_17908((class_2487)oldChunkNbt);
                            class_2794 chunkGenerator = ((class_5363)this.field_35454.method_28609().method_29107(class_5285.method_39335((class_5321)worldRegKey))).method_29571();
                            class_2487 newChunkNbt = versionedChunkStorage.method_17907(worldRegKey, () -> this.field_5755, oldChunkNbt, chunkGenerator.method_39301());
                            class_1923 chunkPos2 = new class_1923(newChunkNbt.method_10550("xPos"), newChunkNbt.method_10550("zPos"));
                            if (!chunkPos2.equals((Object)chunkPos)) {
                                field_5756.warn("Chunk {} has invalid position {}", (Object)chunkPos, (Object)chunkPos2);
                            }
                            boolean chunkChangesMade = chunkDataVersion < class_155.method_16673().getWorldVersion();
                            boolean chunkIsUnused = NoUnusedChunks.isChunkUnused((class_5321<class_1937>)worldRegKey, chunkPos, this.field_35454, newChunkNbt);
                            if (this.field_19225 && !chunkIsUnused) {
                                chunkChangesMade = chunkChangesMade || newChunkNbt.method_10545("Heightmaps");
                                chunkChangesMade = chunkChangesMade || newChunkNbt.method_10545("isLightOn");
                                newChunkNbt.method_10551("Heightmaps");
                                newChunkNbt.method_10551("isLightOn");
                                class_2499 nbtList = newChunkNbt.method_10554("sections", 10);
                                for (int j = 0; j < nbtList.size(); ++j) {
                                    class_2487 nbtCompound3 = nbtList.method_10602(j);
                                    chunkChangesMade = chunkChangesMade || nbtCompound3.method_10545("BlockLight");
                                    chunkChangesMade = chunkChangesMade || nbtCompound3.method_10545("SkyLight");
                                    nbtCompound3.method_10551("BlockLight");
                                    nbtCompound3.method_10551("SkyLight");
                                }
                            } else if (chunkIsUnused) {
                                newChunkNbt = null;
                                chunkChangesMade = true;
                            }
                            if (!chunkIsUnused) {
                                __vcsTemp.method_17910(chunkPos, newChunkNbt);
                            }
                            if (chunkChangesMade) {
                                willChunkNotSkip = true;
                            }
                        }
                    }
                    catch (CompletionException | class_148 runtimeException) {
                        Throwable throwable = runtimeException.getCause();
                        if (throwable instanceof IOException) {
                            field_5756.error("Error upgrading chunk {}", (Object)chunkPos, (Object)throwable);
                        }
                        throw runtimeException;
                    }
                    if (willChunkNotSkip) {
                        ++this.field_5766;
                    } else {
                        ++this.field_5764;
                    }
                    willKeepUpgradingChunks = true;
                }
                float h = (float)worldChunkIterator.nextIndex() / f;
                this.field_5762.put((Object)worldRegKey, h);
                g += h;
            }
            this.field_5763 = g;
            if (willKeepUpgradingChunks) continue;
            this.field_5760 = false;
        }
        this.field_5765 = class_2561.method_43471((String)"optimizeWorld.stage.finished");
        worldRegionFiles.forEach((wrKey, vcsValue) -> {
            try {
                vcsValue.close();
                ((class_3977)__worldTempRegionFiles.get(wrKey)).close();
                Path worldRegDir = this.field_24083.method_27424(wrKey).resolve("region");
                Path worldRegTempDir = worldRegDir.resolve("nounusedchunks_temp");
                for (File wrtdChild : worldRegTempDir.toFile().listFiles()) {
                    Files.move(wrtdChild.toPath(), worldRegDir.resolve(wrtdChild.getName()), StandardCopyOption.REPLACE_EXISTING);
                }
                worldRegTempDir.toFile().delete();
            }
            catch (IOException iOException) {
                field_5756.error("Error upgrading chunk", (Throwable)iOException);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.field_5755.method_125();
        l = class_156.method_658() - l;
        field_5756.info("World optimizaton finished after {} ms", (Object)l);
        this.field_5759 = true;
    }
}

