/*
 * Decompiled with CFR 0.152.
 */
package thecsdev.nounusedchunks.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_3532;
import thecsdev.nounusedchunks.NoUnusedChunks;

public final class NUCConfig {
    public static boolean ENABLED = true;
    public static int UNFLAG_CHANCE = 100;
    public static boolean OW_RUC = false;

    public static void saveProperties() {
        try {
            File fProp = NUCConfig.getPropertiesFile();
            if (!fProp.exists()) {
                fProp.getParentFile().mkdirs();
                fProp.createNewFile();
            }
            Properties prop = new Properties();
            prop.setProperty("ENABLED", Boolean.toString(ENABLED));
            prop.setProperty("UNFLAG_CHANCE", Integer.toString(UNFLAG_CHANCE));
            FileOutputStream fos = new FileOutputStream(fProp);
            prop.store(fos, "nounusedchunks properties");
            fos.close();
            NoUnusedChunks.LOGGER.info("Save 'nounusedchunks' config.");
        }
        catch (IOException ioExc) {
            String mid = "nounusedchunks";
            throw new class_148(new class_128("Unable to save the '" + mid + "' mod config.", (Throwable)ioExc));
        }
    }

    public static void loadProperties() {
        try {
            File fProp = NUCConfig.getPropertiesFile();
            if (!fProp.exists()) {
                NoUnusedChunks.LOGGER.info("Could not load 'nounusedchunks' config. File not found.");
                return;
            }
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(fProp);
            prop.load(fis);
            fis.close();
            ENABLED = NUCConfig.smartBool(prop.getProperty("ENABLED"), true);
            UNFLAG_CHANCE = NUCConfig.smartInt(prop.getProperty("UNFLAG_CHANCE"), 1, 100, 100);
            OW_RUC = NUCConfig.smartBool(prop.getProperty("OW_RUC"), false);
            NoUnusedChunks.LOGGER.info("Loaded 'nounusedchunks' config.");
        }
        catch (IOException ioExc) {
            String mid = "nounusedchunks";
            throw new class_148(new class_128("Unable to load the '" + mid + "' mod config.", (Throwable)ioExc));
        }
    }

    public static File getPropertiesFile() {
        return new File(System.getProperty("user.dir") + "/config/nounusedchunks.properties");
    }

    private static boolean smartBool(String arg0, boolean def) {
        if (arg0 == null) {
            return def;
        }
        String a = arg0.split(" ")[0].toLowerCase();
        return (a.startsWith("true") || a.startsWith("ye") || a.startsWith("ok") || a.startsWith("sur")) && a.length() <= 5;
    }

    private static int smartInt(String arg0, int min, int max, int def) {
        try {
            return class_3532.method_15340((int)Integer.parseInt(arg0), (int)min, (int)max);
        }
        catch (Exception e) {
            return class_3532.method_15340((int)def, (int)min, (int)max);
        }
    }
}

