/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.packets.SingleNoteClientPacket;

public class SingleNoteClientPacketHandler {
    static final Map<IItemInstrument.Pair<Player, Integer>, NoteSoundEntry> noteSounds = new HashMap<IItemInstrument.Pair<Player, Integer>, NoteSoundEntry>();

    public static void handle(SingleNoteClientPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> SingleNoteClientPacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(SingleNoteClientPacket msg) {
        Player playerEntity = msg.getPlayerEntity();
        if (!playerEntity.equals((Object)Minecraft.m_91087_().f_91074_)) {
            IItemInstrument.InsSound sound = msg.getInstrumentItem().getSound(msg.getNote());
            if (sound == null) {
                return;
            }
            if (!msg.isStop()) {
                double x = playerEntity.m_20185_();
                double y = playerEntity.m_20186_();
                double z = playerEntity.m_20189_();
                NoteSound noteSound = (NoteSound)((Object)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(sound.sound, x, y, z, SoundSource.PLAYERS, msg.getVolume() * 1.5f, sound.pitch, (byte)-1)));
                noteSounds.put(IItemInstrument.Pair.of(playerEntity, msg.getNote()), new NoteSoundEntry(noteSound, playerEntity));
                playerEntity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x, y + 2.2, z, (double)msg.getNote() / 24.0, 0.0, 0.0);
            } else {
                NoteSoundEntry oldNoteSoundEntry = noteSounds.get(IItemInstrument.Pair.of(playerEntity, msg.getNote()));
                if (oldNoteSoundEntry != null && !oldNoteSoundEntry.noteSound.m_7801_()) {
                    oldNoteSoundEntry.noteSound.stopSound();
                }
            }
        }
    }

    private static class NoteSoundEntry {
        public final NoteSound noteSound;
        public final Player playerEntity;

        public NoteSoundEntry(NoteSound noteSound, Player playerEntity) {
            this.noteSound = noteSound;
            this.playerEntity = playerEntity;
        }
    }
}

