/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;

public class ItemMusicSheet
extends Item {
    private static final HashMap<IItemInstrument.Pair<String, String>, UUID> convertMap = new HashMap();
    private static final int addToOldEnd = 8;

    ItemMusicSheet() {
        super(new Item.Properties().m_41491_((CreativeModeTab)Items.musicTab).m_41487_(1));
    }

    public static ArrayList<NoteEvent> oldMusicToNotes(byte[] music) {
        ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
        for (int i = 0; i < music.length; ++i) {
            if (music[i] <= 0) continue;
            int nextTime = -1;
            for (int j = i + 1; j < music.length; ++j) {
                if (music[j] <= 0) continue;
                nextTime = j;
                break;
            }
            int l = 1;
            if (nextTime > i && nextTime - i < 20) {
                l = nextTime - i;
            } else if (i == music.length - 1) {
                l = 8;
            }
            byte note = (byte)(music[i] + 32);
            notes.add(new NoteEvent(note, (short)i, 64, (byte)l));
        }
        return notes;
    }

    public static ArrayList<NoteEvent> convertFromOld(CompoundTag nbt, MinecraftServer server) {
        UUID id;
        int length = nbt.m_128451_("length");
        byte pause = nbt.m_128445_("pause");
        byte[] music = nbt.m_128463_("music");
        byte bps = (byte)Math.round(20.0f / (float)pause);
        ArrayList<NoteEvent> notes = ItemMusicSheet.oldMusicToNotes(music);
        nbt.m_128405_("l", length + 8);
        nbt.m_128344_("bps", bps);
        if (nbt.m_128441_("author") && nbt.m_128441_("title")) {
            String title;
            String author = nbt.m_128461_("author");
            IItemInstrument.Pair<String, String> key = new IItemInstrument.Pair<String, String>(author, title = nbt.m_128461_("title"));
            if (convertMap.containsKey(key)) {
                id = convertMap.get(key);
            } else {
                id = UUID.randomUUID();
                convertMap.put(key, id);
                MusicManager.setMusicData(id, 1, notes, server);
            }
        } else {
            id = UUID.randomUUID();
            MusicManager.setMusicData(id, 1, notes, server);
        }
        nbt.m_128362_("id", id);
        nbt.m_128405_("ver", 1);
        nbt.m_128473_("length");
        nbt.m_128473_("pause");
        nbt.m_128473_("music");
        return notes;
    }

    public void m_142312_(@NotNull CompoundTag nbt) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && nbt.m_128441_("music")) {
            MinecraftServer server = ((Level)((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.SERVER)).orElseThrow()).m_7654_();
            ItemMusicSheet.convertFromOld(nbt, server);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack heldItem = playerIn.m_21120_(hand);
        if (worldIn.f_46443_) {
            if (SoundEvents.OPEN_SCROLL != null) {
                playerIn.m_5496_(SoundEvents.OPEN_SCROLL, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            }
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientStuff::showMusicGui);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        String s;
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && !StringUtil.m_14408_((String)(s = tag.m_128461_("title")))) {
            return Component.m_237113_((String)s);
        }
        return super.m_7626_(stack);
    }

    public static int getBPS(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("bps")) {
            return tag.m_128445_("bps");
        }
        return -1;
    }

    public static int getPrevInstrument(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("prevIns")) {
            return tag.m_128445_("prevIns");
        }
        return -1;
    }

    public static float getVolume(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("vol")) {
            return tag.m_128457_("vol");
        }
        return 1.0f;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            IItemInstrument iItemInstrument;
            byte ins;
            int generation;
            CompoundTag tag = stack.m_41784_();
            String s = tag.m_128461_("author");
            if (!StringUtil.m_14408_((String)s)) {
                tooltip.add((Component)Component.m_237110_((String)"note.byAuthor", (Object[])new Object[]{s}));
            }
            if ((generation = tag.m_128451_("generation")) > 0) {
                tooltip.add((Component)Component.m_237115_((String)("note.generation." + (generation - 1))).m_130940_(generation == 1 ? ChatFormatting.GOLD : ChatFormatting.GRAY));
            }
            if (tag.m_128441_("l")) {
                int lengthBeats = tag.m_128451_("l");
                tooltip.add((Component)Component.m_237110_((String)"note.length", (Object[])new Object[]{lengthBeats}).m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128441_("bps")) {
                int bps = tag.m_128451_("bps");
                tooltip.add((Component)Component.m_237110_((String)"note.tempo", (Object[])new Object[]{bps * 60}).m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128441_("prevIns") && (ins = tag.m_128445_("prevIns")) >= 0 && ins < Items.instruments.length && (iItemInstrument = Items.instruments[ins]) instanceof Item) {
                Item item = (Item)iItemInstrument;
                Component name = item.m_7626_(new ItemStack((ItemLike)item));
                tooltip.add((Component)Component.m_237110_((String)"note.preview_instrument", (Object[])new Object[]{name}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        BlockState blockState = world.m_8055_(blockpos = context.m_8083_());
        if (blockState.m_60734_() == Blocks.MUSIC_BOX.get() && !((Boolean)blockState.m_61143_((Property)BlockMusicBox.HAS_MUSIC)).booleanValue()) {
            ItemStack itemstack = context.m_43722_();
            if (itemstack.m_41782_() && !world.f_46443_) {
                BlockMusicBox.insertMusic((LevelAccessor)world, blockpos, blockState, itemstack.m_41777_());
                if (context.m_43723_() != null && !context.m_43723_().m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag ntc;
        if (stack.m_41782_() && (ntc = stack.m_41783_()) != null && ntc.m_128441_("generation")) {
            int generation = ntc.m_128451_("generation");
            return generation > 0;
        }
        return false;
    }
}

