/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.TripleNoteClientPacket;

public class ItemInstrument
extends Item
implements IItemInstrument {
    private ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> sounds;
    private IItemInstrument.InsSound[] insSounds;
    public final boolean isLong;
    private final int minOctave;
    private final int maxOctave;
    private final int instrumentId;

    public ItemInstrument(boolean isLong, int instrumentId, int minOctave, int maxOctave) {
        this(isLong, instrumentId, minOctave, maxOctave, new Item.Properties().m_41491_((CreativeModeTab)Items.musicTab));
    }

    public ItemInstrument(boolean isLong, int instrumentId, int minOctave, int maxOctave, Item.Properties properties) {
        super(properties);
        this.isLong = isLong;
        this.instrumentId = instrumentId;
        this.minOctave = minOctave;
        this.maxOctave = maxOctave;
    }

    @Override
    public int getInstrumentId() {
        return this.instrumentId;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        ItemStack off = playerIn.m_21206_();
        if (handIn == InteractionHand.MAIN_HAND && off.m_41720_() == Items.MUSIC_SHEET.get()) {
            if (!worldIn.f_46443_) {
                IItemInstrument.playMusic(worldIn, playerIn, true);
            }
        } else if (worldIn.f_46443_) {
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientStuff::showInstrumentGui);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        BlockState blockState = world.m_8055_(blockpos = context.m_8083_());
        if (blockState.m_60734_() == Blocks.MUSIC_BOX.get() && !((Boolean)blockState.m_61143_((Property)BlockMusicBox.HAS_INSTRUMENT)).booleanValue()) {
            ItemStack itemstack = context.m_43722_();
            if (!world.f_46443_) {
                BlockMusicBox.insertInstrument((LevelAccessor)world, blockpos, blockState, itemstack.m_41720_());
                if (context.m_43723_() != null && !context.m_43723_().m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, LivingEntity attacker) {
        Level world = attacker.f_19853_;
        if (!world.f_46443_) {
            int note1 = 21 + this.minOctave * 12 + world.f_46441_.m_188503_((this.maxOctave + 1) * 12 - this.minOctave * 12);
            int note2 = 21 + this.minOctave * 12 + world.f_46441_.m_188503_((this.maxOctave + 1) * 12 - this.minOctave * 12);
            int note3 = 21 + this.minOctave * 12 + world.f_46441_.m_188503_((this.maxOctave + 1) * 12 - this.minOctave * 12);
            PacketDistributor.PacketTarget networkTarget = PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(target.m_20185_(), target.m_20186_(), target.m_20189_(), 24.0, target.f_19853_.m_46472_()));
            TripleNoteClientPacket packet = new TripleNoteClientPacket(note1, note2, note3, this, (Entity)target);
            XercaMusic.NETWORK_HANDLER.send(networkTarget, (Object)packet);
        }
        return true;
    }

    @Override
    public void setSounds(ArrayList<IItemInstrument.Pair<Integer, SoundEvent>> sounds) {
        this.sounds = sounds;
        this.insSounds = new IItemInstrument.InsSound[96];
        for (int i = 0; i < 96; ++i) {
            int octave;
            int note = IItemInstrument.idToNote(i);
            int index = this.getClosest(note);
            if (index < 0 || index >= sounds.size()) {
                XercaMusic.LOGGER.error("Invalid sound index in Instrument construction");
            }
            if ((octave = i / 12) < this.minOctave || octave > this.maxOctave) continue;
            float pitch = (float)Math.pow(1.05946314465679, note - sounds.get(index).first());
            this.insSounds[i] = new IItemInstrument.InsSound(sounds.get(index).second(), pitch);
        }
    }

    private int getClosest(int note) {
        int minDiff = 100;
        int bestIndex = -1;
        for (int i = 0; i < this.sounds.size(); ++i) {
            int diff = Math.abs(this.sounds.get(i).first() - note);
            if (diff >= minDiff) continue;
            minDiff = diff;
            bestIndex = i;
        }
        return bestIndex;
    }

    @Override
    public IItemInstrument.InsSound getSound(int note) {
        int id = IItemInstrument.noteToId(note);
        if (id >= 0 && id < 96) {
            return this.insSounds[id];
        }
        XercaMusic.LOGGER.warn("Requested invalid note from Instrument getSound: " + note);
        return null;
    }

    @Override
    public int getMinOctave() {
        return this.minOctave;
    }

    @Override
    public int getMaxOctave() {
        return this.maxOctave;
    }
}

