/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.Unpooled;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Deque;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import xerca.xercamusic.client.BetterSlider;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.client.MidiHandler;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.ImportMusicSendPacket;
import xerca.xercamusic.common.packets.MusicUpdatePacket;
import xerca.xercamusic.common.packets.NotesPartAckFromServerPacketHandler;
import xerca.xercamusic.common.packets.SendNotesPartToServerPacket;

public class GuiMusicSheet
extends Screen {
    private static final String[] octaveNames = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII"};
    private static final ResourceLocation noteGuiLeftTexture = new ResourceLocation("xercamusic", "textures/gui/music_sheet_left.png");
    private static final ResourceLocation noteGuiTextures = new ResourceLocation("xercamusic", "textures/gui/music_sheet.png");
    private static final ResourceLocation instrumentTextures = new ResourceLocation("xercamusic", "textures/gui/instruments.png");
    private final Player editingPlayer;
    public static final int beatsInScreen = 91;
    private static final int noteImageLeftTexX = 175;
    private static final int noteImageLeftTexY = 51;
    private static final int noteImageLeftWidth = 81;
    private static final int noteImageLeftHeight = 205;
    private static final int noteImageTexX = 0;
    private static final int noteImageTexY = 44;
    private static final int noteImageWidth = 256;
    private static final int noteImageHeight = 210;
    private static final int noteRegionLeft = 44;
    private static final int noteRegionTop = 39;
    private static final int noteRegionRight = 316;
    private static final int noteRegionBottom = 182;
    private static final int bpmButW = 10;
    private static final int bpmButH = 10;
    private static final int bpmButX = 245;
    private static final int bpmButY = 12;
    private static final int hlButX = 261;
    private static final int hlButY = 23;
    private static final int[] octaveColors = new int[]{-10800640, -65536, -16060928, -16754177, -8716033, -1113929, -16719137, -727040};
    private static final int[] octaveColorsTrans = new int[]{375075328, 385810432, 369815040, 369121791, 377159935, 384762039, 369156831, 385148928};
    private static final int maxLengthBeats = 32000;
    private static final byte copyBeginByte = 50;
    private int noteImageX;
    private int noteImageLeftX;
    private int noteImageY;
    private static int currentOctave = 1;
    private byte highlightInterval = (byte)12;
    private boolean isSigned;
    private int generation;
    private boolean gettingSigned;
    private boolean previewing;
    private boolean previewStarted;
    private boolean recording;
    private boolean preRecording;
    private boolean preRecordPlayTick;
    private int previewCursor;
    private int previewCursorStart;
    private int oldPreRecordBeat;
    private int editCursor;
    private int editCursorEnd;
    private int selectionStart;
    private int tickCount;
    private String noteTitle = "";
    private Button bpmUp;
    private Button bpmDown;
    private Button octaveUp;
    private Button octaveDown;
    private Button hlUp;
    private Button hlDown;
    private Button buttonSign;
    private Button buttonCancel;
    private Button buttonFinalize;
    private Button buttonHelp;
    private BetterSlider sliderTime;
    private BetterSlider sliderSheetVolume;
    private BetterSlider sliderNoteVolume;
    private NoteEditBox noteEditBox;
    private ChangeableImageButton buttonPreview;
    private ChangeableImageButton buttonRecord;
    private ChangeableImageButton buttonHideNeighbors;
    private LockImageButton buttonLockPrevIns;
    private boolean neighborsHidden = false;
    private boolean prevInsLocked = false;
    private boolean selfSigned = false;
    private final NoteSound[] notePlaySounds;
    private final ArrayList<NoteEvent> recordingNotes = new ArrayList();
    private final boolean[] buttonPushStates = new boolean[96];
    private final UUID id;
    private int version;
    private ArrayList<NoteEvent> notes = new ArrayList();
    private short lengthBeats = 0;
    private byte bps;
    private int bpm;
    private final MusicUpdatePacket.FieldFlag dirtyFlag = new MusicUpdatePacket.FieldFlag();
    private int previewInstrument = -1;
    private long lastMillis = 0L;
    private long cumMillis = 0L;
    private int previewNextNoteID = 0;
    private NoteEvent currentlyAddedNote;
    private int sliderPosition = 0;
    private int maxSliderPosition = 500;
    private int currentOctavePos = 1;
    private float volume = 1.0f;
    private static float brushVolume = 0.5f;
    private static final int maxNoteLength = 60;
    private boolean helpOn = false;
    private static final int maxUndoLength = 16;
    private final Deque<ArrayList<NoteEvent>> undoStack = new ArrayDeque<ArrayList<NoteEvent>>(16);
    private final ArrayList<ArrayList<NoteEvent>> neighborNotes = new ArrayList();
    private final ArrayList<Float> neighborVolumes = new ArrayList();
    private final ArrayList<Integer> neighborPreviewNextNoteIDs = new ArrayList();
    private final ArrayList<Integer> neighborPrevInstruments = new ArrayList();
    private final MidiHandler midiHandler;

    private int getCurrentOffhandInsIndex() {
        Item offhand = this.editingPlayer.m_21206_().m_41720_();
        if (offhand instanceof IItemInstrument) {
            IItemInstrument ins = (IItemInstrument)offhand;
            return ArrayUtils.indexOf((Object[])Items.instruments, (Object)ins);
        }
        return -1;
    }

    GuiMusicSheet(Player player, CompoundTag noteTag, Component title) {
        super(title);
        int currentSlot;
        boolean added;
        int index;
        this.editingPlayer = player;
        if (noteTag != null && !noteTag.m_128456_() && noteTag.m_128441_("id") && noteTag.m_128441_("ver")) {
            this.id = noteTag.m_128342_("id");
            this.version = noteTag.m_128451_("ver");
            MusicManager.MusicData data = MusicManagerClient.getMusicData(this.id, this.version);
            if (data != null) {
                this.notes.addAll(data.notes);
            }
            this.lengthBeats = noteTag.m_128448_("l");
            this.bps = noteTag.m_128445_("bps");
            if (noteTag.m_128441_("vol")) {
                this.volume = noteTag.m_128457_("vol");
            }
            this.generation = noteTag.m_128451_("generation");
            this.isSigned = this.generation > 0;
            this.noteTitle = noteTag.m_128461_("title");
            String authorName = noteTag.m_128461_("author");
            this.prevInsLocked = noteTag.m_128471_("piLocked");
            if (noteTag.m_128441_("prevIns")) {
                this.previewInstrument = noteTag.m_128445_("prevIns");
            }
            if (noteTag.m_128441_("hl")) {
                this.highlightInterval = noteTag.m_128445_("hl");
            }
            if (authorName.equals(player.m_7755_().getString())) {
                this.selfSigned = true;
            }
        } else {
            this.isSigned = false;
            this.id = UUID.randomUUID();
            this.version = 0;
            this.dirtyFlag.hasId = true;
            this.dirtyFlag.hasVersion = true;
        }
        if (this.notes.isEmpty()) {
            this.lengthBeats = 0;
        }
        if (this.bps == 0) {
            this.bps = (byte)8;
        }
        this.bpm = this.bps * 60;
        this.tickCount = 0;
        if (!this.prevInsLocked && (index = this.getCurrentOffhandInsIndex()) != this.previewInstrument) {
            this.previewInstrument = index;
            if (!this.isSigned || this.selfSigned || this.generation > 1) {
                this.dirtyFlag.hasPrevIns = true;
            }
        }
        if (added = this.addNeighborSheet(this.getStackInSlot((currentSlot = player.m_150109_().f_35977_) - 1))) {
            this.addNeighborSheet(this.getStackInSlot(currentSlot - 2));
        }
        if (added = this.addNeighborSheet(this.getStackInSlot(currentSlot + 1))) {
            this.addNeighborSheet(this.getStackInSlot(currentSlot + 2));
        }
        this.midiHandler = new MidiHandler(this::startSound, this::endSound, this::midiControlCommand);
        this.midiHandler.currentOctave = currentOctave;
        this.notePlaySounds = new NoteSound[96];
    }

    private void startSound(MidiHandler.MidiData data) {
        int noteId = data.noteId();
        byte volume = (byte)(data.volume() * 128.0f);
        this.startSound(noteId, volume);
    }

    private void startSound(int noteId, byte volume) {
        if (noteId >= 0 && noteId < this.buttonPushStates.length && this.buttonPushStates[noteId]) {
            XercaMusic.LOGGER.warn("Key pushed twice noteId: " + noteId + " vol: " + volume);
        }
        if (noteId >= 0 && noteId < this.buttonPushStates.length && !this.buttonPushStates[noteId]) {
            IItemInstrument.InsSound noteSound;
            this.buttonPushStates[noteId] = true;
            int note = IItemInstrument.idToNote(noteId);
            for (NoteEvent noteEvent : this.recordingNotes) {
                if (noteEvent.note != note) continue;
                XercaMusic.LOGGER.warn("Existing note pushed? " + noteId + " vol: " + volume);
                return;
            }
            if (this.previewInstrument >= 0 && this.previewInstrument < Items.instruments.length) {
                IItemInstrument ins = Items.instruments[this.previewInstrument];
                noteSound = ins.getSound(note);
            } else {
                noteSound = ((ItemInstrument)Items.HARP_MC.get()).getSound(note);
            }
            if (noteSound == null) {
                XercaMusic.LOGGER.warn("noteSound not found - noteId: " + noteId + " vol: " + volume);
                return;
            }
            this.notePlaySounds[noteId] = (NoteSound)((Object)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(noteSound.sound, this.editingPlayer.m_20185_(), this.editingPlayer.m_20186_(), this.editingPlayer.m_20189_(), (float)volume / 128.0f, noteSound.pitch)));
            if (this.recording) {
                NoteEvent newNote = new NoteEvent((byte)note, (short)Math.max(0, this.previewCursor - 1), volume, 1);
                this.addRecordingNote(newNote);
                ++this.previewNextNoteID;
                this.dirtyFlag.hasNotes = true;
                this.dirtyFlag.hasLength = true;
            }
        }
    }

    private void endSound(int noteId) {
        if (noteId >= 0 && noteId < this.buttonPushStates.length && this.buttonPushStates[noteId]) {
            this.buttonPushStates[noteId] = false;
            if (this.notePlaySounds[noteId] != null) {
                this.notePlaySounds[noteId].stopSound();
                this.notePlaySounds[noteId] = null;
            }
            if (this.recording) {
                int note = IItemInstrument.idToNote(noteId);
                for (int i = 0; i < this.recordingNotes.size(); ++i) {
                    if (this.recordingNotes.get((int)i).note != note) continue;
                    this.recordingNotes.remove(i);
                    break;
                }
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private boolean addNeighborSheet(ItemStack neighbor) {
        int neighborBPS;
        if (!neighbor.m_41619_() && neighbor.m_41720_() instanceof ItemMusicSheet && (neighborBPS = ItemMusicSheet.getBPS(neighbor)) == this.bps) {
            CompoundTag tag = neighbor.m_41783_();
            if (tag != null && tag.m_128441_("id") && tag.m_128441_("ver")) {
                UUID id = tag.m_128342_("id");
                int ver = tag.m_128451_("ver");
                MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                    if (data != null) {
                        this.neighborNotes.add(new ArrayList<NoteEvent>(data.notes));
                        this.neighborPrevInstruments.add(ItemMusicSheet.getPrevInstrument(neighbor));
                        this.neighborPreviewNextNoteIDs.add(-1);
                        this.neighborVolumes.add(Float.valueOf(ItemMusicSheet.getVolume(neighbor)));
                    }
                });
            }
            return true;
        }
        return false;
    }

    private ItemStack getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.editingPlayer.m_150109_().m_6643_()) {
            return this.editingPlayer.m_150109_().m_8020_(slot);
        }
        return ItemStack.f_41583_;
    }

    public void m_7856_() {
        this.noteImageX = (this.f_96543_ - 337) / 2 + 81;
        this.noteImageLeftX = this.noteImageX - 81;
        this.noteImageY = 2;
        if (!this.isSigned) {
            this.buttonSign = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 112, this.noteImageY + 210, 98, 20, (Component)Component.m_237115_((String)"note.signButton"), button -> {
                if (!this.isSigned) {
                    this.gettingSigned = true;
                    this.updateButtons();
                }
            }));
            this.buttonFinalize = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 112, 145, 98, 20, (Component)Component.m_237115_((String)"note.finalizeButton"), button -> {
                if (!this.isSigned) {
                    this.dirtyFlag.hasSigned = true;
                    this.dirtyFlag.hasTitle = true;
                    this.isSigned = true;
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91152_(null);
                    }
                }
            }));
            this.buttonCancel = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 112, 170, 98, 20, (Component)Component.m_237115_((String)"gui.cancel"), button -> {
                if (!this.isSigned) {
                    this.gettingSigned = false;
                    this.updateButtons();
                }
            }));
        }
        this.buttonPreview = (ChangeableImageButton)this.m_142416_((GuiEventListener)new ChangeableImageButton(this.noteImageLeftX + 50, 16, 16, 16, 224, 0, 16, noteGuiTextures, button -> this.previewButton()));
        this.buttonRecord = (ChangeableImageButton)this.m_142416_((GuiEventListener)new ChangeableImageButton(this.noteImageLeftX + 70, 16, 16, 16, 176, 0, 16, noteGuiTextures, button -> this.recordButton()));
        this.buttonHideNeighbors = (ChangeableImageButton)this.m_142416_((GuiEventListener)new ChangeableImageButton(this.noteImageLeftX + 90, 16, 16, 16, 192, 0, 16, noteGuiTextures, button -> {
            boolean bl = this.neighborsHidden = !this.neighborsHidden;
            if (this.neighborsHidden) {
                this.buttonHideNeighbors.setTexStarts(208, 0);
            } else {
                this.buttonHideNeighbors.setTexStarts(192, 0);
            }
        }));
        this.buttonLockPrevIns = (LockImageButton)this.m_142416_((GuiEventListener)new LockImageButton(this.noteImageLeftX + 110, 16, 16, 16, this.previewInstrument * 16 + 16, 32 * ((this.previewInstrument + 1) / 16), 16, instrumentTextures, button -> {
            if (!this.isSigned || this.selfSigned || this.generation > 1) {
                int index;
                this.prevInsLocked = !this.prevInsLocked;
                this.dirtyFlag.hasPrevInsLocked = true;
                if (!this.prevInsLocked && (index = this.getCurrentOffhandInsIndex()) != this.previewInstrument) {
                    this.previewInstrument = index;
                    this.buttonLockPrevIns.setTexStarts(this.previewInstrument * 16 + 16, 32 * ((this.previewInstrument + 1) / 16));
                    this.dirtyFlag.hasPrevIns = true;
                }
            }
        }));
        this.bpmUp = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 245, this.noteImageY + 12, 10, 10, (Component)Component.m_237115_((String)"note.upButton"), button -> {
            if (!this.isSigned || this.selfSigned || this.generation > 1) {
                if (GuiMusicSheet.m_96638_()) {
                    int mult;
                    int n = mult = GuiMusicSheet.m_96637_() ? 3 : 2;
                    if (this.bps * mult <= 50) {
                        this.pushUndo();
                        this.bps = (byte)(this.bps * mult);
                        this.dirtyFlag.hasBps = true;
                        this.previewing = false;
                        this.previewCursor = this.previewCursorStart;
                        for (NoteEvent note : this.notes) {
                            note.time = (short)(note.time * mult);
                            note.length = (byte)Math.min(60, note.length * mult);
                        }
                        this.updateLength();
                    }
                } else if (this.bps < 50) {
                    this.bps = (byte)(this.bps + 1);
                    this.dirtyFlag.hasBps = true;
                    this.cumMillis = (long)((float)this.cumMillis * ((float)(this.bps - 1) / (float)this.bps));
                }
                this.bpm = 60 * this.bps;
            }
        }));
        this.bpmDown = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 245, this.noteImageY + 12 + 1 + 10, 10, 10, (Component)Component.m_237115_((String)"note.downButton"), button -> {
            if (!this.isSigned || this.selfSigned || this.generation > 1) {
                if (GuiMusicSheet.m_96638_()) {
                    float mult;
                    float f = mult = GuiMusicSheet.m_96637_() ? 0.33f : 0.5f;
                    if (Math.round((float)this.bps * mult) >= 1) {
                        this.pushUndo();
                        this.bps = (byte)Math.round((float)this.bps * mult);
                        this.dirtyFlag.hasBps = true;
                        this.previewing = false;
                        this.previewCursor = this.previewCursorStart;
                        for (NoteEvent note : this.notes) {
                            note.time = (short)Math.round((float)note.time * mult);
                            note.length = (byte)Math.max(Math.round((float)note.length * mult), 1);
                        }
                        this.updateLength();
                        this.removeDuplicates();
                    }
                } else if (this.bps > 1) {
                    this.bps = (byte)(this.bps - 1);
                    this.dirtyFlag.hasBps = true;
                    this.cumMillis = (long)((float)this.cumMillis * ((float)(this.bps + 1) / (float)this.bps));
                }
                this.bpm = 60 * this.bps;
            }
        }));
        this.octaveUp = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 15, this.noteImageY + 30, 10, 10, (Component)Component.m_237115_((String)"note.upButton"), button -> {
            if (this.currentOctavePos < 4) {
                ++this.currentOctavePos;
            }
        }));
        this.octaveDown = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 15, this.noteImageY + 182, 10, 10, (Component)Component.m_237115_((String)"note.downButton"), button -> {
            if (this.currentOctavePos > 0) {
                --this.currentOctavePos;
            }
        }));
        this.sliderTime = (BetterSlider)this.m_142416_((GuiEventListener)new BetterSlider(this.noteImageLeftX + 44, this.noteImageY + 182 + 4, 272, 10, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.0, 1.0, 0.0, 0.001, 3, false){

            @Override
            public void m_5697_() {
                GuiMusicSheet.this.sliderPosition = (int)(this.f_93577_ * (double)GuiMusicSheet.this.maxSliderPosition);
            }
        });
        this.sliderSheetVolume = (BetterSlider)this.m_142416_((GuiEventListener)new BetterSlider(this.noteImageLeftX + 316 - 55, this.noteImageY + 12, 54, 10, (Component)Component.m_237113_((String)"S Vol "), (Component)Component.m_237119_(), 0.0, 100.0, this.volume * 100.0f, true){

            @Override
            public void m_5697_() {
                if (!GuiMusicSheet.this.isSigned || GuiMusicSheet.this.selfSigned || GuiMusicSheet.this.generation > 1) {
                    GuiMusicSheet.this.volume = (float)this.f_93577_;
                    GuiMusicSheet.this.dirtyFlag.hasVolume = true;
                }
            }
        });
        this.sliderNoteVolume = (BetterSlider)this.m_142416_((GuiEventListener)new BetterSlider(this.noteImageLeftX + 130, this.noteImageY + 12, 54, 10, (Component)Component.m_237113_((String)"N Vol "), (Component)Component.m_237119_(), 0.0, 100.0, brushVolume * 100.0f, true){

            @Override
            public void m_5697_() {
                if (!GuiMusicSheet.this.isSigned) {
                    brushVolume = (float)this.f_93577_;
                }
            }
        });
        this.hlDown = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 261, this.noteImageY + 23, 10, 10, (Component)Component.m_237115_((String)"note.leftButton"), button -> {
            if ((!this.isSigned || this.selfSigned || this.generation > 1) && this.highlightInterval > 1) {
                this.highlightInterval = (byte)(this.highlightInterval - 1);
                this.dirtyFlag.hasHlInterval = true;
            }
        }));
        this.hlUp = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 261 + 44, this.noteImageY + 23, 10, 10, (Component)Component.m_237115_((String)"note.rightButton"), button -> {
            if ((!this.isSigned || this.selfSigned || this.generation > 1) && this.highlightInterval < 24) {
                this.highlightInterval = (byte)(this.highlightInterval + 1);
                this.dirtyFlag.hasHlInterval = true;
            }
        }));
        this.noteEditBox = (NoteEditBox)this.m_142416_((GuiEventListener)new NoteEditBox(0, 0, 70, 55, (Component)Component.m_237119_()));
        this.buttonHelp = (Button)this.m_142416_((GuiEventListener)new Button(this.noteImageLeftX + 316 + 30, this.noteImageY + 12, 20, 20, (Component)Component.m_237113_((String)"?"), button -> this.toggleHelp()));
        this.updateButtons();
        this.updateLength();
    }

    private void previewButton() {
        if (!this.previewing) {
            this.startPreview();
        } else {
            this.stopPreview();
        }
    }

    private void recordButton() {
        if (!this.recording && !this.preRecording) {
            this.startPreRecording();
        } else {
            this.stopRecording();
        }
    }

    private void updateButtons() {
        if (!this.isSigned) {
            this.buttonSign.f_93624_ = !this.gettingSigned;
            this.buttonSign.f_93623_ = !this.helpOn && !this.recording && !this.preRecording;
            this.buttonCancel.f_93624_ = this.gettingSigned;
            this.buttonFinalize.f_93624_ = this.gettingSigned;
            this.buttonFinalize.f_93623_ = !this.noteTitle.trim().isEmpty();
        }
        this.bpmUp.f_93624_ = !this.gettingSigned && (!this.isSigned || this.selfSigned || this.generation > 1);
        this.bpmDown.f_93624_ = this.bpmUp.f_93624_;
        this.bpmUp.f_93623_ = !this.recording && !this.preRecording;
        this.bpmDown.f_93623_ = this.bpmUp.f_93623_;
        this.buttonPreview.f_93624_ = !this.gettingSigned;
        this.buttonPreview.f_93623_ = !this.recording && !this.preRecording;
        this.buttonLockPrevIns.f_93624_ = !this.gettingSigned;
        this.buttonLockPrevIns.f_93623_ = (!this.isSigned || this.selfSigned || this.generation > 1) && !this.recording && !this.preRecording;
        this.sliderSheetVolume.f_93624_ = !this.gettingSigned;
        this.sliderSheetVolume.f_93623_ = (!this.isSigned || this.selfSigned || this.generation > 1) && !this.recording && !this.preRecording;
        this.noteEditBox.f_93624_ = false;
        this.noteEditBox.f_93623_ = false;
        this.octaveDown.f_93624_ = !this.gettingSigned;
        this.octaveUp.f_93624_ = !this.gettingSigned;
        this.sliderTime.f_93624_ = !this.gettingSigned;
        this.sliderTime.f_93623_ = !this.recording && !this.preRecording;
        this.hlUp.f_93624_ = !this.gettingSigned && (!this.isSigned || this.selfSigned || this.generation > 1);
        this.hlUp.f_93623_ = (!this.isSigned || this.selfSigned || this.generation > 1) && !this.recording && !this.preRecording;
        this.hlDown.f_93624_ = !this.gettingSigned && (!this.isSigned || this.selfSigned || this.generation > 1);
        this.hlDown.f_93623_ = (!this.isSigned || this.selfSigned || this.generation > 1) && !this.recording && !this.preRecording;
        this.sliderNoteVolume.f_93624_ = !this.isSigned && !this.gettingSigned;
        this.sliderNoteVolume.f_93623_ = this.sliderNoteVolume.f_93624_ && !this.recording && !this.preRecording;
        this.buttonHelp.f_93624_ = !this.isSigned && !this.gettingSigned;
        this.buttonHelp.f_93623_ = this.buttonHelp.f_93624_ && !this.recording && !this.preRecording;
        this.buttonHideNeighbors.f_93624_ = this.neighborNotes.size() > 0 && !this.gettingSigned;
        this.buttonHideNeighbors.f_93623_ = !this.recording && !this.preRecording;
        this.buttonRecord.f_93624_ = !this.gettingSigned && !this.isSigned;
        this.buttonRecord.f_93623_ = this.recording || this.preRecording || !this.previewing;
    }

    private void toggleHelp() {
        this.helpOn = !this.helpOn;
        this.updateButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.tickCount;
    }

    private void playMetronomeTick() {
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(SoundEvents.TICK, this.editingPlayer.m_20185_(), this.editingPlayer.m_20186_(), this.editingPlayer.m_20189_(), SoundSource.PLAYERS, 1.0f, 0.975f + this.editingPlayer.f_19853_.f_46441_.m_188501_() * 0.05f, (byte)-1));
    }

    private NoteSound playSound(NoteEvent event, int previewInstrument) {
        return this.playSound(event, previewInstrument, this.volume);
    }

    private NoteSound playSound(NoteEvent event, int previewInstrument, float sheetVolume) {
        IItemInstrument.InsSound insSound;
        if (event.note < 21 || event.note > 117) {
            XercaMusic.LOGGER.warn("Note is invalid: " + event.note);
            return null;
        }
        if (previewInstrument >= 0 && previewInstrument < Items.instruments.length) {
            IItemInstrument ins = Items.instruments[previewInstrument];
            insSound = ins.getSound(event.note);
        } else {
            insSound = ((ItemInstrument)Items.HARP_MC.get()).getSound(event.note);
        }
        if (insSound == null) {
            return null;
        }
        return (NoteSound)((Object)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.playNote(insSound.sound, this.editingPlayer.m_20185_(), this.editingPlayer.m_20186_(), this.editingPlayer.m_20189_(), sheetVolume * event.floatVolume(), insSound.pitch, (byte)this.beatsToTicks(event.length))));
    }

    private int beatsToTicks(int beats) {
        return Math.round((float)beats * 20.0f / (float)this.bps);
    }

    private void playPreviewSound(int curStart, int curEnd) {
        if (this.previewNextNoteID < this.notes.size()) {
            NoteEvent event = this.notes.get(this.previewNextNoteID);
            while (event.time >= curStart && event.time < curEnd) {
                if (!this.recordingNotes.contains(event)) {
                    this.playSound(event, this.previewInstrument);
                }
                ++this.previewNextNoteID;
                if (this.previewNextNoteID >= this.notes.size()) break;
                event = this.notes.get(this.previewNextNoteID);
            }
        }
        if (!this.neighborsHidden) {
            for (int i = 0; i < this.neighborNotes.size(); ++i) {
                ArrayList<NoteEvent> nn = this.neighborNotes.get(i);
                int nPrevNoteID = this.neighborPreviewNextNoteIDs.get(i);
                if (nPrevNoteID < 0 || nPrevNoteID >= nn.size()) continue;
                NoteEvent n = nn.get(nPrevNoteID);
                int ins = this.neighborPrevInstruments.get(i);
                while (n.time >= curStart && n.time < curEnd) {
                    this.playSound(n, ins, this.neighborVolumes.get(i).floatValue());
                    if (++nPrevNoteID >= nn.size()) break;
                    n = nn.get(nPrevNoteID);
                }
                this.neighborPreviewNextNoteIDs.set(i, nPrevNoteID);
            }
        }
    }

    private void drawSigning(PoseStack matrixStack) {
        int i = this.noteImageLeftX;
        int j = this.noteImageY;
        int left = i + 100;
        int top = j + 40;
        int width = 120;
        int height = 100;
        GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)left, (int)top, (int)(left + 120), (int)(top + 100), (int)-1);
        Object titleStr = this.noteTitle;
        if (!this.isSigned) {
            titleStr = this.tickCount / 6 % 2 == 0 ? (String)titleStr + ChatFormatting.BLACK + "_" : (String)titleStr + ChatFormatting.GRAY + "_";
        }
        String writeTitleStr = I18n.m_118938_((String)"note.editTitle", (Object[])new Object[0]);
        int k = this.f_96547_.m_92895_(writeTitleStr);
        this.f_96547_.m_92883_(matrixStack, writeTitleStr, (float)left + (float)(120 - k) / 2.0f, (float)(top + 16), 0);
        int l = this.f_96547_.m_92895_((String)titleStr);
        this.f_96547_.m_92883_(matrixStack, (String)titleStr, (float)left + (float)(120 - l) / 2.0f, (float)(top + 30), 0);
        String authorStr = I18n.m_118938_((String)"note.byAuthor", (Object[])new Object[]{this.editingPlayer.m_7755_().getString()});
        int i1 = this.f_96547_.m_92895_(authorStr);
        this.f_96547_.m_92883_(matrixStack, ChatFormatting.DARK_GRAY + authorStr, (float)left + (float)(116 - i1) / 2.0f, (float)(top + 42), 0);
        this.f_96547_.m_92857_((FormattedText)Component.m_237115_((String)"note.finalizeWarning"), left + 10, top + 60, 116, 0);
    }

    private int noteToPixelX(int noteX) {
        return this.noteImageLeftX + 44 + noteX * 3;
    }

    private void drawCursor(PoseStack matrixStack, int cursorX, int color) {
        if (this.inScreen(cursorX)) {
            int x = this.noteToPixelX(cursorX - this.sliderPosition);
            int y = this.noteImageY + 39;
            GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)(x + 1), (int)y, (int)(x + 2), (int)(y + 144), (int)color);
        }
    }

    public void midiControlCommand(MidiControl controlType) {
        switch (controlType) {
            case BEGINNING: {
                if (this.previewing || this.recording || this.preRecording) break;
                this.editCursor = 0;
                this.editCursorEnd = 0;
                if (this.inScreen(this.editCursor)) break;
                this.setSliderPos(this.editCursor);
                break;
            }
            case END: {
                if (this.previewing || this.recording || this.preRecording) break;
                this.editCursor = this.lengthBeats - 1;
                this.editCursorEnd = this.lengthBeats - 1;
                if (this.inScreen(this.editCursor)) break;
                this.setSliderPos(this.editCursor);
                break;
            }
            case STOP: {
                if (this.recording || this.preRecording) {
                    this.stopRecording();
                    break;
                }
                if (!this.previewing) break;
                this.stopPreview();
                break;
            }
            case PREVIEW: {
                if (!this.buttonPreview.f_93623_) break;
                this.previewButton();
                break;
            }
            case RECORD: {
                if (!this.buttonRecord.f_93623_) break;
                this.recordButton();
            }
        }
    }

    public void m_6305_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.previewing || this.recording || this.preRecording) {
            long currentMillis = System.currentTimeMillis();
            long delta = currentMillis - this.lastMillis;
            this.lastMillis = currentMillis;
            this.cumMillis += delta;
            int currentBeat = (int)(this.cumMillis * (long)this.bps) / 1000;
            if (this.preRecording) {
                if (currentBeat > this.oldPreRecordBeat) {
                    for (int i = 0; i < currentBeat - this.oldPreRecordBeat; ++i) {
                        if (this.preRecordPlayTick) {
                            this.preRecordPlayTick = false;
                            this.playMetronomeTick();
                            continue;
                        }
                        this.preRecordPlayTick = true;
                    }
                    if (currentBeat % 8 == 0 && this.cumMillis > 1500L || currentBeat % 4 == 0 && this.cumMillis > 1950L) {
                        this.startRecording();
                    }
                    this.oldPreRecordBeat = currentBeat;
                }
            } else {
                int oldPreviewCursor = this.previewCursor;
                this.previewCursor = this.previewCursorStart + currentBeat;
                if (this.previewCursor > this.sliderPosition + 91 - 12 && (this.lengthBeats > this.sliderPosition + 91 || this.recording)) {
                    this.setSliderPos(this.previewCursor - 24);
                }
                if (oldPreviewCursor != this.previewCursor) {
                    if (!this.recording && (this.previewCursor > this.lengthBeats || this.editCursorEnd != this.editCursor && this.previewCursor > this.editCursorEnd + 1)) {
                        this.stopPreview();
                    } else {
                        this.previewStarted = true;
                        this.playPreviewSound(oldPreviewCursor, this.previewCursor);
                    }
                    if (this.recording) {
                        for (NoteEvent note : this.recordingNotes) {
                            if (this.previewCursor - note.time <= 1) continue;
                            note.length = (byte)(note.length + (this.previewCursor - oldPreviewCursor));
                            if (note.length <= 60) continue;
                            note.length = (byte)60;
                        }
                    }
                }
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)noteGuiLeftTexture);
        this.m_93228_(matrixStack, this.noteImageLeftX, this.noteImageY + 7, 175, 51, 81, 205);
        RenderSystem.m_157456_((int)0, (ResourceLocation)noteGuiTextures);
        this.m_93228_(matrixStack, this.noteImageX, this.noteImageY, 0, 44, 256, 210);
        if (this.gettingSigned) {
            this.drawSigning(matrixStack);
        } else {
            int x;
            int y;
            int i;
            int x1 = this.noteImageLeftX + 44;
            int x2 = this.noteImageLeftX + 316;
            for (i = 0; i < 4; ++i) {
                int y1 = this.noteImageY + 39 + (4 - i) * 12 * 3;
                int y2 = this.noteImageY + 39 + (3 - i) * 12 * 3;
                GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)y2, (int)octaveColorsTrans[i + this.currentOctavePos]);
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 6; ++j) {
                    y = this.noteImageY + 182 - i * 36 - j * 6;
                    GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)x1, (int)(y - 1), (int)(x2 + 1), (int)y, (int)octaveColors[i + this.currentOctavePos]);
                }
            }
            for (i = 0; i < 4; ++i) {
                x = x1 - 24;
                y = this.noteImageY + 182 - 18 - i * 36;
                if (currentOctave == i + this.currentOctavePos) {
                    GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)(x - 10), (int)(y - 4), (int)(x + 10), (int)(y + 12), (int)-1426063446);
                }
                GuiMusicSheet.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)octaveNames[i + this.currentOctavePos], (int)x, (int)y, (int)octaveColors[i + this.currentOctavePos]);
            }
            if (this.highlightInterval > 1) {
                for (i = this.sliderPosition; i < this.sliderPosition + 91; ++i) {
                    x = (i - this.sliderPosition) * 3 + this.noteImageLeftX + 44 + 1;
                    if (i % this.highlightInterval != 0) continue;
                    GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)x, (int)(this.noteImageY + 39 - 1), (int)(x + 1), (int)(this.noteImageY + 182 + 3), (int)-7833238);
                }
                matrixStack.m_85836_();
                matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                for (i = this.sliderPosition; i < this.sliderPosition + 91; ++i) {
                    if (i % this.highlightInterval != 0) continue;
                    x = (i - this.sliderPosition) * 3 + this.noteImageLeftX + 44;
                    y = this.noteImageY + 39 - 5;
                    String name = "" + (i / this.highlightInterval + 1);
                    int w = this.f_96547_.m_92895_(name);
                    this.f_96547_.m_92883_(matrixStack, name, ((float)x - ((float)w - 6.0f) / 4.0f) * 2.0f, (float)(y * 2), -12303360);
                }
                matrixStack.m_85849_();
            }
            this.f_96547_.m_92883_(matrixStack, "M:", (float)(this.noteImageLeftX + 261 + 14), (float)(this.noteImageY + 23 + 2), -16777216);
            this.f_96547_.m_92883_(matrixStack, "" + (Serializable)(this.highlightInterval > 1 ? Byte.valueOf(this.highlightInterval) : "-"), (float)(this.noteImageLeftX + 261 + 22), (float)(this.noteImageY + 23 + 2), -16777216);
            this.f_96547_.m_92883_(matrixStack, "Tempo", (float)(this.noteImageLeftX + 245 - 30), (float)(this.noteImageY + 12), -16777216);
            this.f_96547_.m_92883_(matrixStack, "" + this.bpm, (float)(this.noteImageLeftX + 245 - 30), (float)(this.noteImageY + 12 + 10), -16777216);
            this.drawCursor(matrixStack, this.editCursor, -5627358);
            if (!this.isSigned) {
                if (this.editCursor != this.editCursorEnd) {
                    this.drawCursor(matrixStack, this.editCursorEnd, -5627358);
                    this.drawSelectionRect(matrixStack);
                }
            } else {
                int k = this.f_96547_.m_92895_(this.noteTitle);
                this.f_96547_.m_92883_(matrixStack, this.noteTitle, (float)this.noteImageLeftX + (float)(337 - k) / 2.0f, (float)(this.noteImageY + 14), -6750208);
                if (this.selfSigned) {
                    this.drawCursor(matrixStack, this.editCursor, -5627358);
                    if (this.editCursor != this.editCursorEnd) {
                        this.drawCursor(matrixStack, this.editCursorEnd, -5627358);
                        this.drawSelectionRect(matrixStack);
                    }
                }
            }
            if (!this.neighborsHidden) {
                for (ArrayList<NoteEvent> nn : this.neighborNotes) {
                    for (NoteEvent event : nn) {
                        this.drawNote(matrixStack, event, true);
                    }
                }
            }
            for (NoteEvent note : this.notes) {
                this.drawNote(matrixStack, note, false);
            }
        }
        if (this.previewStarted) {
            int i = this.previewCursor - 1;
            this.drawCursor(matrixStack, i, -5601246);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.buttonHideNeighbors.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.toggleTooltip"), mouseX, mouseY);
        } else if (this.buttonLockPrevIns.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.lockTooltip"), mouseX, mouseY);
        } else if (this.buttonPreview.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.previewTooltip"), mouseX, mouseY);
        } else if (this.buttonRecord.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.recordTooltip"), mouseX, mouseY);
        } else if (this.bpmDown.m_198029_() || this.bpmUp.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.tempoTooltip"), mouseX, mouseY);
        } else if (this.hlDown.m_198029_() || this.hlUp.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.measureTooltip"), mouseX, mouseY);
        } else if (this.sliderSheetVolume.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.sheetVolumeTooltip"), mouseX, mouseY);
        } else if (this.sliderNoteVolume.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.noteVolumeTooltip"), mouseX, mouseY);
        } else if (this.buttonHelp.m_198029_()) {
            this.m_96602_(matrixStack, (Component)Component.m_237115_((String)"note.helpTooltip"), mouseX, mouseY);
        }
        if (this.helpOn) {
            int x = this.noteImageLeftX + 15;
            int y = this.noteImageY;
            GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)x, (int)y, (int)(x + 315), (int)(y + 220), (int)-298634445);
            matrixStack.m_85836_();
            matrixStack.m_85841_(1.2f, 1.2f, 1.2f);
            GuiMusicSheet.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"note.helpText0"), (int)((int)((float)(x + 10) / 1.2f)), (int)((int)((float)(y + 5) / 1.2f)), (int)-1118703);
            matrixStack.m_85849_();
            for (int i = 1; i <= 19; ++i) {
                MutableComponent leftSide = Component.m_237115_((String)("note.helpText" + i + "a"));
                MutableComponent rightSide = Component.m_237115_((String)("note.helpText" + i + "b"));
                GuiMusicSheet.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)leftSide, (int)(x + 10), (int)(y + 10 + 10 * i), (int)-1118703);
                GuiMusicSheet.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)rightSide, (int)(x + 10 + this.f_96547_.m_92852_((FormattedText)leftSide)), (int)(y + 10 + 10 * i), (int)-1118482);
            }
        }
    }

    private void drawSelectionRect(PoseStack matrixStack) {
        if (this.inScreen(this.editCursor) || this.inScreen(this.editCursorEnd) || this.editCursor < this.sliderPosition && this.editCursorEnd >= this.sliderPosition + 91) {
            int selectionColor = -2011028822;
            int timeDrawBeginning = Math.max(this.editCursor - this.sliderPosition, 0);
            int timeDrawEnd = Math.min(this.editCursorEnd - this.sliderPosition, 91);
            int x1 = this.noteToPixelX(timeDrawBeginning);
            int x2 = this.noteToPixelX(timeDrawEnd);
            int y1 = this.noteImageY + 39;
            int y2 = y1 + 144;
            GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)(x1 + 1), (int)y1, (int)(x2 + 2), (int)y2, (int)-2011028822);
        }
    }

    private boolean inScreen(int time) {
        return time >= this.sliderPosition && time < this.sliderPosition + 91;
    }

    private static int octaveFromNote(byte note) {
        return (note - 21) / 12;
    }

    private void drawNote(PoseStack matrixStack, NoteEvent event, boolean isNeighbor) {
        int octave = GuiMusicSheet.octaveFromNote(event.note);
        if (octave >= this.currentOctavePos && octave < this.currentOctavePos + 4 && (this.inScreen(event.time) || this.inScreen(event.time + event.length))) {
            int timeDrawEnd;
            int xEnd;
            int timeDrawBeginning = Math.max(event.time - this.sliderPosition, 0);
            int xBegin = this.noteImageLeftX + 44 + timeDrawBeginning * 3;
            if (xBegin == (xEnd = this.noteImageLeftX + 44 + (timeDrawEnd = Math.min(event.time - this.sliderPosition + event.length, 91)) * 3)) {
                return;
            }
            int xFillBegin = timeDrawBeginning == event.time - this.sliderPosition ? xBegin + 1 : xBegin;
            int xFillEnd = timeDrawEnd == event.time - this.sliderPosition + event.length ? xEnd - 1 : xEnd;
            int y = this.noteImageY + 39 + (47 - event.note + 21) * 3 + this.currentOctavePos * 36;
            int outlineColor = event == this.currentlyAddedNote || isNeighbor ? 0x77000000 : -16777216;
            int red = event.volume >= 64 ? 255 : event.volume * 4;
            int green = event.volume < 64 ? 255 : 255 - event.volume * 4;
            int fillColor = (event == this.currentlyAddedNote || isNeighbor ? 0x77000000 : -16777216) | red << 16 | green << 8;
            GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)xBegin, (int)y, (int)xEnd, (int)(y + 3), (int)outlineColor);
            GuiMusicSheet.m_93172_((PoseStack)matrixStack, (int)xFillBegin, (int)(y + 1), (int)xFillEnd, (int)(y + 2), (int)fillColor);
        }
    }

    private void startPreview() {
        int i;
        this.previewCursor = this.editCursor;
        boolean noteFound = false;
        for (i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get((int)i).time < this.previewCursor) continue;
            this.previewNextNoteID = i;
            noteFound = true;
            break;
        }
        if (noteFound) {
            if (!this.neighborsHidden) {
                block1: for (i = 0; i < this.neighborNotes.size(); ++i) {
                    ArrayList<NoteEvent> nn = this.neighborNotes.get(i);
                    for (int j = 0; j < nn.size(); ++j) {
                        if (nn.get((int)j).time < this.previewCursor) continue;
                        this.neighborPreviewNextNoteIDs.set(i, j);
                        continue block1;
                    }
                }
            }
            this.previewCursorStart = this.editCursor;
            this.previewStarted = false;
            this.previewing = true;
            this.cumMillis = 0L;
            this.lastMillis = System.currentTimeMillis();
            this.buttonPreview.setTexStarts(240, 0);
            if (!this.inScreen(this.previewCursorStart)) {
                this.setSliderPos(this.previewCursorStart);
            }
        }
        this.updateButtons();
    }

    private void startPreRecording() {
        int i;
        this.preRecording = true;
        this.previewCursor = this.editCursor;
        for (i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get((int)i).time < this.previewCursor) continue;
            this.previewNextNoteID = i;
            break;
        }
        if (!this.neighborsHidden) {
            block1: for (i = 0; i < this.neighborNotes.size(); ++i) {
                ArrayList<NoteEvent> nn = this.neighborNotes.get(i);
                for (int j = 0; j < nn.size(); ++j) {
                    if (nn.get((int)j).time < this.previewCursor) continue;
                    this.neighborPreviewNextNoteIDs.set(i, j);
                    continue block1;
                }
            }
        }
        this.previewCursorStart = this.editCursor;
        this.previewStarted = false;
        this.cumMillis = 0L;
        this.oldPreRecordBeat = 0;
        this.lastMillis = System.currentTimeMillis();
        this.buttonRecord.setTexStarts(240, 0);
        if (!this.inScreen(this.previewCursorStart)) {
            this.setSliderPos(this.previewCursorStart);
        }
        this.updateButtons();
    }

    private void startRecording() {
        this.preRecording = false;
        this.previewing = true;
        this.recording = true;
        this.cumMillis = 0L;
        this.lastMillis = System.currentTimeMillis();
        this.buttonRecord.setTexStarts(240, 0);
        if (!this.inScreen(this.previewCursorStart)) {
            this.setSliderPos(this.previewCursorStart);
        }
        this.updateButtons();
    }

    private void stopRecording() {
        this.preRecording = false;
        this.previewing = false;
        this.recording = false;
        this.previewStarted = false;
        this.buttonRecord.setTexStarts(176, 0);
        this.updateLength();
        this.recordingNotes.clear();
        this.updateButtons();
    }

    private void setSliderPos(int time) {
        time = Math.min(Math.max(time, 0), this.maxSliderPosition);
        this.sliderTime.m_93611_((float)time / (float)this.maxSliderPosition);
        this.sliderTime.m_5697_();
    }

    private void stopPreview() {
        this.previewing = false;
        this.previewStarted = false;
        this.buttonPreview.setTexStarts(224, 0);
        this.updateButtons();
    }

    private void updateLength() {
        this.updateLength(true);
    }

    private void updateLength(boolean updateSliderPos) {
        this.lengthBeats = 0;
        if (!this.notes.isEmpty()) {
            for (NoteEvent event : this.notes) {
                this.lengthBeats = (short)(event.time + event.length) > this.lengthBeats ? (short)(event.time + event.length) : this.lengthBeats;
            }
            if (updateSliderPos) {
                int oldMaxSliderPos = this.maxSliderPosition;
                this.maxSliderPosition = Math.min(Math.max(this.lengthBeats + 91, 680), 32000);
                if (this.maxSliderPosition > oldMaxSliderPos) {
                    this.setSliderPos(this.sliderPosition);
                } else if (this.maxSliderPosition < oldMaxSliderPos) {
                    this.setSliderPos(this.maxSliderPosition - 91);
                }
            }
        }
    }

    public boolean m_6375_(double dmouseX, double dmouseY, int mouseButton) {
        block5: {
            int my;
            int mx;
            block6: {
                int i;
                int note;
                int time;
                int mouseY;
                int mouseX;
                block7: {
                    boolean composing;
                    if (this.helpOn) {
                        this.helpOn = false;
                        return true;
                    }
                    if (super.m_6375_(dmouseX, dmouseY, mouseButton)) {
                        this.m_7897_(true);
                        return true;
                    }
                    mouseX = (int)Math.round(dmouseX);
                    mouseY = (int)Math.round(dmouseY);
                    boolean viewingSelfSigned = this.isSigned && this.selfSigned;
                    boolean bl = composing = !this.isSigned && !this.gettingSigned;
                    if (!this.gettingSigned && mouseButton == 1 && this.validClick(mx = mouseX - this.noteImageLeftX, my = mouseY - this.noteImageY)) {
                        this.editCursorEnd = this.editCursor = (mx - 44) / 3 + this.sliderPosition;
                        this.selectionStart = this.editCursor;
                    }
                    if (viewingSelfSigned && mouseButton == 0) {
                        this.editCursorEnd = this.editCursor;
                    }
                    if (!composing) break block5;
                    mx = mouseX - this.noteImageLeftX;
                    my = mouseY - this.noteImageY;
                    if (!this.validClick(mx, my)) break block6;
                    int nrx = mx - 44;
                    int nry = my - 39;
                    time = nrx / 3 + this.sliderPosition;
                    note = 47 - nry / 3 + 21 + this.currentOctavePos * 12;
                    if (mouseButton != 0) break block7;
                    this.addNote((byte)note, (short)time);
                    this.dirtyFlag.hasNotes = true;
                    this.dirtyFlag.hasLength = true;
                    this.editCursorEnd = this.editCursor;
                    break block5;
                }
                if (mouseButton != 2 || (i = this.findNote((byte)note, (short)time)) < 0) break block5;
                NoteEvent event = this.notes.get(i);
                this.noteEditBox.appear(mouseX, mouseY, event);
                break block5;
            }
            for (int i = 0; i < 4; ++i) {
                int x = 20;
                int y = 164 - i * 36;
                if (mx < 10 || mx > 30 || my < y - 4 || my > y + 12) continue;
                this.midiHandler.currentOctave = currentOctave = this.currentOctavePos + i;
                if (!this.recording) break;
                this.recordingNotes.clear();
                break;
            }
        }
        return true;
    }

    private void pushUndo() {
        if (this.undoStack.size() >= 16) {
            this.undoStack.removeLast();
        }
        ArrayList<NoteEvent> stackNotes = new ArrayList<NoteEvent>(this.notes.size());
        for (NoteEvent note : this.notes) {
            stackNotes.add(note.clone());
        }
        this.undoStack.push(stackNotes);
    }

    private void addNote(byte note, short time) {
        this.addNote(note, time, true);
    }

    private void addNote(byte note, short time, boolean pushUndo) {
        int i;
        if (pushUndo) {
            this.pushUndo();
        }
        if ((i = this.findNote(note, time)) < 0) {
            this.addNote(note, time, (byte)(127.0f * brushVolume));
        } else {
            this.notes.remove(i);
        }
        this.updateLength();
    }

    private void addNote(byte note, short time, byte volume) {
        NoteEvent newEvent;
        this.currentlyAddedNote = newEvent = new NoteEvent(note, time, volume, 1);
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get((int)i).time <= time) continue;
            this.notes.add(i, newEvent);
            return;
        }
        this.notes.add(newEvent);
    }

    private void addRecordingNote(NoteEvent noteEvent) {
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get((int)i).time <= noteEvent.time) continue;
            this.notes.add(i, noteEvent);
            this.recordingNotes.add(noteEvent);
            return;
        }
        this.notes.add(noteEvent);
        this.recordingNotes.add(noteEvent);
    }

    private void finishAddingNote() {
        if (this.currentlyAddedNote == null) {
            return;
        }
        this.playSound(this.currentlyAddedNote, this.previewInstrument);
        this.currentlyAddedNote = null;
        this.updateLength();
    }

    private int findNote(byte note, short time) {
        for (int i = this.notes.size() - 1; i >= 0; --i) {
            NoteEvent event = this.notes.get(i);
            if (event.time > time || event.endTime() < time || event.note != note) continue;
            return i;
        }
        return -1;
    }

    public boolean m_7979_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        int time;
        if (this.m_7222_() != null && this.m_7282_()) {
            this.m_7222_().m_7979_(posX, posY, mouseButton, deltaX, deltaY);
            return true;
        }
        if (this.tickCount < 10) {
            return super.m_7979_(posX, posY, mouseButton, deltaX, deltaY);
        }
        int mouseX = (int)Math.round(posX);
        int mouseY = (int)Math.round(posY);
        int mx = mouseX - this.noteImageLeftX;
        int my = mouseY - this.noteImageY;
        if (mouseButton == 1) {
            if (this.validClick(mx, my)) {
                int noteX = (mx - 44) / 3 + this.sliderPosition;
                if (this.selectionStart > noteX) {
                    this.editCursor = noteX;
                } else {
                    this.editCursorEnd = noteX;
                }
            }
        } else if (mouseButton == 0 && this.currentlyAddedNote != null && this.validClick(mx, my) && this.currentlyAddedNote.time < (time = (mx - 44) / 3 + this.sliderPosition) && time - this.currentlyAddedNote.time <= 60) {
            this.currentlyAddedNote.length = (byte)(time - this.currentlyAddedNote.time);
        }
        return true;
    }

    public boolean m_6348_(double posX, double posY, int mouseButton) {
        this.m_7897_(false);
        if (this.noteEditBox.f_93623_) {
            this.noteEditBox.m_6348_(posX, posY, mouseButton);
            return true;
        }
        if (mouseButton == 0) {
            this.finishAddingNote();
        }
        return true;
    }

    private void putSpace(int x) {
        if (x == 31999) {
            return;
        }
        this.addEditCursor(1);
        if (this.lengthBeats == 0 || this.lengthBeats <= x) {
            return;
        }
        this.pushUndo();
        this.dirtyFlag.hasNotes = true;
        this.dirtyFlag.hasLength = true;
        for (int i = 0; i < this.notes.size(); ++i) {
            NoteEvent event = this.notes.get(i);
            if (event.time <= x) continue;
            event.time = (short)(event.time + 1);
            if (event.time + event.length <= 32000) continue;
            this.notes.remove(i);
            --i;
        }
        this.updateLength();
    }

    private void encodeToClipboard() {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        ArrayList<NoteEvent> toBeCopied = new ArrayList<NoteEvent>();
        for (NoteEvent event : this.notes) {
            if (event.time < this.editCursor || event.time > this.editCursorEnd || event.endTime() < this.editCursor || event.endTime() > this.editCursorEnd) continue;
            toBeCopied.add(event);
        }
        buffer.writeByte(50);
        buffer.writeInt(this.editCursorEnd - this.editCursor);
        buffer.writeInt(toBeCopied.size());
        for (NoteEvent event : toBeCopied) {
            event.time = (short)(event.time - this.editCursor);
            event.encodeToBuffer(buffer);
            event.time = (short)(event.time + this.editCursor);
        }
        String encodeBytes = Base64.getEncoder().encodeToString(buffer.m_178382_());
        GLFW.glfwSetClipboardString((long)Minecraft.m_91087_().m_91268_().m_85439_(), (CharSequence)encodeBytes);
        this.editCursorEnd = this.editCursor;
    }

    private void decodeFromClipboard(boolean pushBack) {
        String encodedMusic = GLFW.glfwGetClipboardString((long)Minecraft.m_91087_().m_91268_().m_85439_());
        if (encodedMusic != null && !encodedMusic.isEmpty()) {
            ArrayList<NoteEvent> toBePasted;
            byte[] byteArray;
            try {
                byteArray = Base64.getDecoder().decode(encodedMusic);
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            int length = 0;
            if (byteArray[0] != 50) {
                for (byte b : byteArray) {
                    if (b >= 0 && b <= 48) continue;
                    XercaMusic.LOGGER.info("User tried to copy invalid data into music: " + b);
                    return;
                }
                toBePasted = ItemMusicSheet.oldMusicToNotes(byteArray);
                if (!toBePasted.isEmpty()) {
                    Object object = toBePasted.iterator();
                    while (object.hasNext()) {
                        NoteEvent event = (NoteEvent)object.next();
                        length = (short)(event.time + event.length) > length ? (int)(event.time + event.length) : length;
                    }
                }
            } else {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])byteArray));
                buffer.readByte();
                length = buffer.readInt();
                int count = buffer.readInt();
                toBePasted = new ArrayList(count);
                for (int i = 0; i < count; ++i) {
                    toBePasted.add(NoteEvent.fromBuffer(buffer));
                }
            }
            this.pushUndo();
            if (pushBack) {
                for (NoteEvent event : this.notes) {
                    if (event.time < this.editCursor) continue;
                    event.time = (short)(event.time + length);
                }
            }
            for (NoteEvent event : toBePasted) {
                event.time = (short)(event.time + this.editCursor);
                this.notes.add(event);
            }
            this.sortNotes();
            if (!pushBack) {
                this.removeDuplicates();
            }
            this.updateLength();
            this.editCursor += length + 1;
            this.editCursorEnd = this.editCursor;
            this.dirtyFlag.hasNotes = true;
            this.dirtyFlag.hasLength = true;
        }
    }

    private void removeDuplicates() {
        for (int i = 0; i < this.notes.size() - 1; ++i) {
            NoteEvent event1 = this.notes.get(i);
            NoteEvent event2 = this.notes.get(i + 1);
            if (event1.time != event2.time || event1.note != event2.note || event1.length != event2.length) continue;
            this.notes.remove(i);
            --i;
        }
    }

    private void delAtCursor(int x) {
        boolean doSort = false;
        for (int i = 0; i < this.notes.size(); ++i) {
            NoteEvent event = this.notes.get(i);
            if (event.time > x) {
                event.time = (short)(event.time - 1);
                doSort = true;
                continue;
            }
            if (event.time < x && event.time + event.length > x) {
                event.length = (byte)(event.length - 1);
                continue;
            }
            if (event.time != x) continue;
            if (event.length == 1) {
                this.notes.remove(i);
                --i;
                continue;
            }
            event.length = (byte)(event.length - 1);
        }
        if (doSort) {
            this.sortNotes();
        }
        this.updateLength();
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.m_7522_(null);
        super.m_7920_(keyCode, scanCode, modifiers);
        int firstScanCode = GLFW.glfwGetKeyScancode((int)81);
        int lastScanCode = firstScanCode + 11;
        if (scanCode >= firstScanCode && scanCode <= lastScanCode && currentOctave >= 0 && this.recording) {
            this.endSound(IItemInstrument.noteToId((byte)(scanCode - firstScanCode + 1 + 21 + 12 * currentOctave)));
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean viewingSelfSigned;
        this.m_7522_(null);
        super.m_7933_(keyCode, scanCode, modifiers);
        boolean bl = viewingSelfSigned = this.isSigned && this.selfSigned;
        if (viewingSelfSigned) {
            if (keyCode == 67 && (modifiers & 2) == 2) {
                this.encodeToClipboard();
            }
            if (keyCode == 65 && (modifiers & 2) == 2) {
                this.editCursor = 0;
                this.editCursorEnd = this.lengthBeats - 1;
            }
        }
        if (!this.isSigned) {
            if (this.gettingSigned) {
                switch (keyCode) {
                    case 259: {
                        if (this.noteTitle.isEmpty()) break;
                        this.noteTitle = this.noteTitle.substring(0, this.noteTitle.length() - 1);
                        this.updateButtons();
                        break;
                    }
                    case 257: {
                        if (this.noteTitle.isEmpty()) break;
                        this.dirtyFlag.hasSigned = true;
                        this.dirtyFlag.hasTitle = true;
                        this.isSigned = true;
                        if (this.f_96541_ == null) break;
                        this.f_96541_.m_91152_(null);
                        break;
                    }
                }
                return true;
            }
            int x = this.editCursor;
            boolean resetEditCursorEnd = true;
            switch (keyCode) {
                case 261: {
                    if (this.lengthBeats == 0 || this.lengthBeats <= x) break;
                    this.pushUndo();
                    this.dirtyFlag.hasNotes = true;
                    this.dirtyFlag.hasLength = true;
                    if (this.editCursorEnd == x) {
                        this.delAtCursor(x);
                        break;
                    }
                    this.deleteSelected();
                    this.updateLength();
                    break;
                }
                case 259: {
                    if (this.editCursorEnd == x) {
                        if (x == 0) break;
                        if (this.lengthBeats == 0 || this.lengthBeats < x) {
                            this.addEditCursor(-1);
                            break;
                        }
                        this.pushUndo();
                        this.dirtyFlag.hasNotes = true;
                        this.dirtyFlag.hasLength = true;
                        this.addEditCursor(-1);
                        this.delAtCursor(this.editCursor);
                        break;
                    }
                    this.pushUndo();
                    this.dirtyFlag.hasNotes = true;
                    this.dirtyFlag.hasLength = true;
                    this.deleteSelected();
                    this.updateLength();
                    break;
                }
                case 32: {
                    this.putSpace(x - 1);
                    break;
                }
                case 262: {
                    this.addEditCursor(1);
                    if (this.editCursor <= 31999) break;
                    this.setEditCursor(31999);
                    break;
                }
                case 263: {
                    this.addEditCursor(-1);
                    if (this.editCursor >= 0) break;
                    this.setEditCursor(0);
                    break;
                }
                case 257: {
                    this.previewButton();
                    break;
                }
                case 342: 
                case 346: {
                    this.recordButton();
                    break;
                }
                case 67: {
                    if ((modifiers & 2) != 2) break;
                    this.encodeToClipboard();
                    break;
                }
                case 86: {
                    if ((modifiers & 2) != 2) break;
                    this.decodeFromClipboard((modifiers & 1) != 1);
                    break;
                }
                case 72: {
                    this.toggleHelp();
                    break;
                }
                case 90: {
                    if ((modifiers & 2) != 2 || this.noteEditBox.f_93623_ || this.undoStack.isEmpty()) break;
                    this.notes = this.undoStack.pop();
                    this.updateLength(false);
                    break;
                }
                case 65: {
                    if ((modifiers & 2) == 2) {
                        this.editCursor = 0;
                        this.editCursorEnd = this.lengthBeats - 1;
                        resetEditCursorEnd = false;
                        break;
                    }
                    if (this.editCursor == this.editCursorEnd) {
                        if (--currentOctave < -2) {
                            currentOctave = -2;
                        }
                        this.midiHandler.currentOctave = currentOctave;
                        if (!this.recording) break;
                        this.recordingNotes.clear();
                        break;
                    }
                    boolean changed = false;
                    for (NoteEvent event : this.notes) {
                        if (event.endTime() < this.editCursor || event.time > this.editCursorEnd || IItemInstrument.noteToId(event.note) / 12 <= 0) continue;
                        if (!changed) {
                            this.pushUndo();
                            this.dirtyFlag.hasNotes = true;
                            this.dirtyFlag.hasLength = true;
                            changed = true;
                        }
                        event.note = (byte)(event.note - 12);
                    }
                    resetEditCursorEnd = false;
                    break;
                }
                case 83: {
                    if (this.editCursor == this.editCursorEnd) {
                        if (++currentOctave > 7) {
                            currentOctave = 7;
                        }
                        this.midiHandler.currentOctave = currentOctave;
                        if (!this.recording) break;
                        this.recordingNotes.clear();
                        break;
                    }
                    boolean changed = false;
                    for (NoteEvent event : this.notes) {
                        if (event.endTime() < this.editCursor || event.time > this.editCursorEnd || IItemInstrument.noteToId(event.note) / 12 >= 7) continue;
                        if (!changed) {
                            this.pushUndo();
                            this.dirtyFlag.hasNotes = true;
                            this.dirtyFlag.hasLength = true;
                            changed = true;
                        }
                        event.note = (byte)(event.note + 12);
                    }
                    resetEditCursorEnd = false;
                    break;
                }
                case 341: 
                case 345: {
                    resetEditCursorEnd = false;
                    break;
                }
                default: {
                    int firstScanCode = GLFW.glfwGetKeyScancode((int)81);
                    int lastScanCode = firstScanCode + 11;
                    if (scanCode < firstScanCode || scanCode > lastScanCode || currentOctave < 0) break;
                    if (this.recording) {
                        this.startSound(IItemInstrument.noteToId((byte)(scanCode - firstScanCode + 1 + 21 + 12 * currentOctave)), (byte)100);
                        break;
                    }
                    this.putSpace(x - 1);
                    this.addNote((byte)(scanCode - firstScanCode + 1 + 21 + 12 * currentOctave), (short)x, false);
                    this.finishAddingNote();
                }
            }
            if (resetEditCursorEnd) {
                this.editCursorEnd = this.editCursor;
            }
        }
        return true;
    }

    private void deleteSelected() {
        boolean doSort = false;
        for (int i = 0; i < this.notes.size(); ++i) {
            NoteEvent event = this.notes.get(i);
            if (event.time >= this.editCursor && event.endTime() <= this.editCursorEnd) {
                this.notes.remove(i);
                --i;
                continue;
            }
            if (event.time < this.editCursor && event.endTime() >= this.editCursor && event.endTime() <= this.editCursorEnd) {
                event.length = (byte)(this.editCursor - event.time);
                continue;
            }
            if (event.time >= this.editCursor && event.time <= this.editCursorEnd && event.endTime() > this.editCursorEnd) {
                event.length = (byte)(event.endTime() - this.editCursorEnd);
                event.time = (short)(this.editCursor + 1);
                doSort = true;
                continue;
            }
            if (event.time < this.editCursor && event.endTime() > this.editCursorEnd) {
                event.length = (byte)(this.editCursor - event.time);
                continue;
            }
            if (event.time <= this.editCursorEnd) continue;
            event.time = (short)(event.time - (this.editCursorEnd - this.editCursor));
            doSort = true;
        }
        if (doSort) {
            this.sortNotes();
        }
    }

    private void sortNotes() {
        this.notes.sort(Comparator.comparingInt(NoteEvent::startTime));
    }

    private void setEditCursor(int x) {
        if (this.editCursor != this.editCursorEnd) {
            this.editCursor = x;
        } else {
            this.editCursor = x;
            this.editCursorEnd = x;
        }
    }

    private void addEditCursor(int x) {
        this.setEditCursor(this.editCursor + x);
    }

    public boolean m_5534_(char typedChar, int something) {
        super.m_5534_(typedChar, something);
        if (!this.isSigned) {
            if (this.gettingSigned && this.noteTitle.length() < 16 && SharedConstants.m_136188_((char)typedChar)) {
                this.noteTitle = this.noteTitle + typedChar;
                this.updateButtons();
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double x, double y, double scroll) {
        if (scroll != 0.0) {
            if (scroll > 0.0) {
                this.octaveUp.m_7435_(Minecraft.m_91087_().m_91106_());
                this.octaveUp.m_5691_();
            } else if (scroll < 0.0) {
                this.octaveDown.m_7435_(Minecraft.m_91087_().m_91106_());
                this.octaveDown.m_5691_();
            }
            return true;
        }
        return super.m_6050_(x, y, scroll);
    }

    public void m_7861_() {
        if (this.dirtyFlag.hasAny()) {
            if (this.recording) {
                this.stopRecording();
            }
            if (this.dirtyFlag.hasNotes || this.dirtyFlag.hasLength) {
                ++this.version;
                this.dirtyFlag.hasVersion = true;
                MusicManagerClient.setMusicData(this.id, this.version, this.notes);
            }
            try {
                MusicUpdatePacket pack = new MusicUpdatePacket(this.dirtyFlag, this.notes, this.lengthBeats, this.bps, this.volume, this.isSigned, this.noteTitle, (byte)this.previewInstrument, this.prevInsLocked, this.id, this.version, this.highlightInterval);
                XercaMusic.NETWORK_HANDLER.sendToServer((Object)pack);
            }
            catch (ImportMusicSendPacket.NotesTooLargeException e) {
                int partsCount = (int)Math.ceil((double)this.notes.size() / 5000.0);
                try {
                    MusicUpdatePacket pack = new MusicUpdatePacket(this.dirtyFlag, null, this.lengthBeats, this.bps, this.volume, this.isSigned, this.noteTitle, (byte)this.previewInstrument, this.prevInsLocked, this.id, this.version, this.highlightInterval);
                    NotesPartAckFromServerPacketHandler.addCallback(this.id, () -> XercaMusic.NETWORK_HANDLER.sendToServer((Object)pack));
                    for (int i = 0; i < partsCount; ++i) {
                        SendNotesPartToServerPacket partPack = new SendNotesPartToServerPacket(this.id, partsCount, i, this.notes.subList(i * 5000, Math.min((i + 1) * 5000, this.notes.size())));
                        XercaMusic.NETWORK_HANDLER.sendToServer((Object)partPack);
                    }
                }
                catch (ImportMusicSendPacket.NotesTooLargeException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (SoundEvents.CLOSE_SCROLL != null) {
            this.editingPlayer.m_5496_(SoundEvents.CLOSE_SCROLL, 1.0f, 0.8f + this.editingPlayer.f_19853_.f_46441_.m_188501_() * 0.4f);
        }
    }

    private boolean validClick(int x, int y) {
        return x <= 316 && x >= 44 && y <= 182 && y >= 39;
    }

    public static class ChangeableImageButton
    extends Button {
        protected final ResourceLocation resourceLocation;
        protected int xTexStart;
        protected int yTexStart;
        protected final int yDiffText;
        protected final int texWidth;
        protected final int texHeight;

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, Button.OnPress onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, 256, 256, onClick);
        }

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.OnPress onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, (Component)Component.m_237119_());
        }

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.OnPress onClick, Component message) {
            super(x, y, width, height, message, onClick);
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.xTexStart = xTexStart;
            this.yTexStart = yTexStart;
            this.yDiffText = yDiffText;
            this.resourceLocation = texture;
        }

        public void setTexStarts(int x, int y) {
            this.xTexStart = x;
            this.yTexStart = y;
        }

        protected int preRender() {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
            GlStateManager.m_84507_();
            int yTexStartNew = this.yTexStart;
            if (this.f_93622_ && this.f_93623_) {
                yTexStartNew += this.yDiffText;
            }
            return yTexStartNew;
        }

        protected void postRender() {
            GlStateManager.m_84513_();
        }

        public void m_6303_(@NotNull PoseStack matrixStack, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            int yTexStartNew = this.preRender();
            ChangeableImageButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)this.xTexStart, (float)yTexStartNew, (int)this.f_93618_, (int)this.f_93619_, (int)this.texWidth, (int)this.texHeight);
            this.postRender();
        }
    }

    public class LockImageButton
    extends ChangeableImageButton {
        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, Button.OnPress onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, 256, 256, onClick);
        }

        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.OnPress onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, (Component)Component.m_237119_());
        }

        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.OnPress onClick, Component message) {
            super(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, message);
        }

        @Override
        public void m_6303_(@NotNull PoseStack matrixStack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            int yTexStartNew = this.preRender();
            LockImageButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)this.xTexStart, (float)yTexStartNew, (int)this.f_93618_, (int)this.f_93619_, (int)this.texWidth, (int)this.texHeight);
            if (GuiMusicSheet.this.prevInsLocked) {
                LockImageButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)(this.texHeight - this.f_93619_), (int)this.f_93618_, (int)this.f_93619_, (int)this.texWidth, (int)this.texHeight);
            }
            this.postRender();
        }
    }

    public class NoteEditBox
    extends AbstractWidget {
        public final Button buttonNoteDown;
        public final Button buttonNoteUp;
        public final Button buttonLengthDown;
        public final Button buttonLengthUp;
        public final Button buttonExit;
        public final Button buttonPrev;
        public final BetterSlider sliderVelocity;
        private NoteEvent event;
        private final int noteY = 18;
        private final int lengthY = 29;
        private final AbstractWidget[] children;
        private NoteSound previewSound;
        private boolean changed;
        private final String[] noteNames;
        private final String[] noteNamesSolfege;

        public NoteEditBox(int x, int y, int w, int h, Component msg) {
            super(x, y, w, h, msg);
            this.noteY = 18;
            this.lengthY = 29;
            this.children = new AbstractWidget[7];
            this.changed = false;
            this.noteNames = new String[]{"A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#"};
            this.noteNamesSolfege = new String[]{"La", "La#", "Si", "Do", "Do#", "Re", "Re#", "Mi", "Fa", "Fa#", "Sol", "Sol#"};
            this.sliderVelocity = new BetterSlider(10, 0, 50, 10, (Component)Component.m_237113_((String)"Vol "), (Component)Component.m_237119_(), 0.0, 100.0, 50.0, true){

                @Override
                public void m_5697_() {
                    NoteEditBox.this.setChanged();
                    NoteEditBox.this.event.volume = (byte)Math.round(this.f_93577_ * 127.0);
                }
            };
            this.buttonNoteDown = new Button(0, 0, 10, 8, (Component)Component.m_237115_((String)"note.leftButton"), button -> {
                if (this.event.note > 0) {
                    this.setChanged();
                    this.event.note = (byte)(this.event.note - 1);
                    this.playPrev();
                }
            });
            this.buttonNoteUp = new Button(0, 0, 10, 8, (Component)Component.m_237115_((String)"note.rightButton"), button -> {
                if (this.event.note < 95) {
                    this.setChanged();
                    this.event.note = (byte)(this.event.note + 1);
                    this.playPrev();
                }
            });
            this.buttonLengthDown = new Button(0, 0, 10, 8, (Component)Component.m_237115_((String)"note.leftButton"), button -> {
                if (this.event.length > 1) {
                    this.setChanged();
                    this.event.length = (byte)(this.event.length - 1);
                    this.playPrev();
                }
            });
            this.buttonLengthUp = new Button(0, 0, 10, 8, (Component)Component.m_237115_((String)"note.rightButton"), button -> {
                if (this.event.length < 60) {
                    this.setChanged();
                    this.event.length = (byte)(this.event.length + 1);
                    this.playPrev();
                }
            });
            this.buttonExit = new Button(0, 0, 10, 10, (Component)Component.m_237115_((String)"note.exitButton"), button -> {
                this.f_93624_ = false;
                this.f_93623_ = false;
                if (this.previewSound != null && !this.previewSound.m_7801_()) {
                    this.previewSound.stopSound();
                }
            });
            this.buttonPrev = new Button(0, 0, 10, 10, (Component)Component.m_237115_((String)"note.startPreviewButton"), button -> this.playPrev());
            this.children[0] = this.sliderVelocity;
            this.children[1] = this.buttonNoteDown;
            this.children[2] = this.buttonNoteUp;
            this.children[3] = this.buttonLengthDown;
            this.children[4] = this.buttonLengthUp;
            this.children[5] = this.buttonExit;
            this.children[6] = this.buttonPrev;
        }

        private void setChanged() {
            if (!this.changed) {
                this.changed = true;
                GuiMusicSheet.this.dirtyFlag.hasNotes = true;
                GuiMusicSheet.this.dirtyFlag.hasLength = true;
                GuiMusicSheet.this.pushUndo();
            }
        }

        private void playPrev() {
            if (this.previewSound != null && !this.previewSound.m_7801_()) {
                this.previewSound.stopSound();
            }
            this.previewSound = GuiMusicSheet.this.playSound(this.event, GuiMusicSheet.this.previewInstrument);
        }

        public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_ && this.event != null) {
                NoteEditBox.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-1118482);
                Minecraft minecraft = Minecraft.m_91087_();
                Font font = minecraft.f_91062_;
                int noteId = IItemInstrument.noteToId(this.event.note);
                int octave = noteId / 12;
                font.m_92883_(poseStack, this.noteNames[noteId % 12] + (noteId % 12 < 3 ? octave : octave + 1), (float)(this.f_93620_ + 15), (float)(this.f_93621_ + 18), -2899456);
                font.m_92883_(poseStack, this.noteNamesSolfege[noteId % 12], (float)(this.f_93620_ + 35), (float)(this.f_93621_ + 18), -2899456);
                font.m_92883_(poseStack, this.event.length + (this.event.length == 1 ? " Beat" : " Beats"), (float)(this.f_93620_ + 15), (float)(this.f_93621_ + 29), -11968795);
                for (AbstractWidget widget : this.children) {
                    widget.m_6305_(poseStack, mouseX, mouseY, partialTicks);
                }
                if (this.buttonPrev.m_198029_()) {
                    GuiMusicSheet.this.m_96602_(poseStack, (Component)Component.m_237115_((String)"note.previewNoteTooltip"), mouseX, mouseY);
                } else if (this.buttonExit.m_198029_()) {
                    GuiMusicSheet.this.m_96602_(poseStack, (Component)Component.m_237115_((String)"note.closeNoteTooltip"), mouseX, mouseY);
                }
            }
        }

        public void appear(int x, int y, NoteEvent event) {
            this.changed = false;
            this.f_93620_ = x;
            this.f_93621_ = y;
            this.f_93624_ = true;
            this.f_93623_ = true;
            this.event = event;
            this.sliderVelocity.f_93620_ = x + 10;
            int sliderY = 41;
            this.sliderVelocity.f_93621_ = y + sliderY;
            this.sliderVelocity.m_93611_(event.floatVolume() * 100.0f);
            this.sliderVelocity.m_5697_();
            this.buttonNoteDown.f_93620_ = x + 3;
            this.buttonNoteDown.f_93621_ = y + 18;
            this.buttonNoteUp.f_93620_ = x + 59;
            this.buttonNoteUp.f_93621_ = y + 18;
            this.buttonLengthDown.f_93620_ = x + 3;
            this.buttonLengthDown.f_93621_ = y + 29;
            this.buttonLengthUp.f_93620_ = x + 59;
            this.buttonLengthUp.f_93621_ = y + 29;
            this.buttonExit.f_93620_ = x + 59;
            this.buttonExit.f_93621_ = y + 2;
            this.buttonPrev.f_93620_ = x + 3;
            this.buttonPrev.f_93621_ = y + 2;
            this.playPrev();
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            if (this.f_93623_ && this.f_93624_) {
                if (mouseButton == 2) {
                    this.f_93624_ = false;
                    this.f_93623_ = false;
                }
                for (AbstractWidget widget : this.children) {
                    if (!(mouseX >= (double)widget.f_93620_) || !(mouseX < (double)(widget.f_93620_ + widget.m_5711_())) || !(mouseY >= (double)widget.f_93621_) || !(mouseY < (double)(widget.f_93621_ + widget.m_93694_()))) continue;
                    widget.m_6375_(mouseX, mouseY, mouseButton);
                    return true;
                }
                boolean flag = this.m_93680_(mouseX, mouseY);
                if (flag) {
                    this.m_5716_(mouseX, mouseY);
                } else {
                    this.f_93624_ = false;
                    this.f_93623_ = false;
                }
                return true;
            }
            return false;
        }

        public boolean m_7979_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
            if (posX >= (double)this.sliderVelocity.f_93620_ && posX < (double)(this.sliderVelocity.f_93620_ + this.sliderVelocity.m_5711_()) && posY >= (double)this.sliderVelocity.f_93621_ && posY < (double)(this.sliderVelocity.f_93621_ + this.sliderVelocity.m_93694_())) {
                this.sliderVelocity.m_7979_(posX, posY, mouseButton, deltaX, deltaY);
            }
            return true;
        }

        public boolean m_6348_(double posX, double posY, int mouseButton) {
            this.sliderVelocity.m_7691_(posX, posY);
            return true;
        }

        public void m_142291_(@NotNull NarrationElementOutput output) {
        }
    }

    public static enum MidiControl {
        BEGINNING,
        END,
        STOP,
        PREVIEW,
        RECORD;

    }
}

