/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.teamderpy.shouldersurfing.client.ShoulderHelper;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.Vec2f;
import com.teamderpy.shouldersurfing.mixins.CameraAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShoulderRenderer {
    private static final ShoulderRenderer INSTANCE = new ShoulderRenderer();
    private double cameraDistance;
    private Vec2f lastTranslation = Vec2f.ZERO;
    private Vec2f translation = Vec2f.ZERO;
    private Vec2f projected;
    private double cameraOffsetX;
    private double cameraOffsetY;
    private double cameraOffsetZ;
    private float cameraEntityAlpha = 1.0f;

    public void offsetCrosshair(PoseStack poseStack, Window window, float partialTicks) {
        if (this.projected != null) {
            Vec2f scaledDimensions = new Vec2f(window.m_85445_(), window.m_85446_());
            Vec2f dimensions = new Vec2f(window.m_85443_(), window.m_85444_());
            Vec2f scale = scaledDimensions.divide(dimensions);
            Vec2f center = dimensions.divide(2.0f);
            Vec2f projectedOffset = this.projected.subtract(center).scale(scale);
            Vec2f interpolated = projectedOffset.subtract(this.lastTranslation).scale(partialTicks);
            this.translation = this.lastTranslation.add(interpolated);
        }
        if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderInstance.getInstance().doShoulderSurfing()) {
            poseStack.m_85836_();
            poseStack.m_85850_().m_85861_().m_27648_(new Vector3f(this.translation.getX(), -this.translation.getY(), 0.0f));
            this.lastTranslation = this.translation;
        } else {
            this.lastTranslation = Vec2f.ZERO;
        }
    }

    public void clearCrosshairOffset(PoseStack poseStack) {
        if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderInstance.getInstance().doShoulderSurfing() && !Vec2f.ZERO.equals(this.lastTranslation)) {
            poseStack.m_85849_();
        }
    }

    public void offsetCamera(Camera camera, Level level, float partialTick) {
        if (ShoulderInstance.getInstance().doShoulderSurfing() && level != null) {
            LivingEntity living;
            Entity entity;
            ShoulderInstance instance = ShoulderInstance.getInstance();
            double targetXOffset = Config.CLIENT.getOffsetX();
            double targetYOffset = Config.CLIENT.getOffsetY();
            double targetZOffset = Config.CLIENT.getOffsetZ();
            if (camera.m_90592_().m_20159_()) {
                targetXOffset += Config.CLIENT.getOffsetX() * (Config.CLIENT.getPassengerOffsetXMultiplier() - 1.0);
                targetYOffset += Config.CLIENT.getOffsetY() * (Config.CLIENT.getPassengerOffsetYMultiplier() - 1.0);
                targetZOffset += Config.CLIENT.getOffsetZ() * (Config.CLIENT.getPassengerOffsetZMultiplier() - 1.0);
            }
            if (camera.m_90592_().m_20142_()) {
                targetXOffset += Config.CLIENT.getOffsetX() * (Config.CLIENT.getSprintOffsetXMultiplier() - 1.0);
                targetYOffset += Config.CLIENT.getOffsetY() * (Config.CLIENT.getSprintOffsetYMultiplier() - 1.0);
                targetZOffset += Config.CLIENT.getOffsetZ() * (Config.CLIENT.getSprintOffsetZMultiplier() - 1.0);
            }
            if (Config.CLIENT.doCenterCameraWhenClimbing() && (entity = camera.m_90592_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_6147_()) {
                targetXOffset = 0.0;
            }
            if (ShoulderHelper.angle(camera.m_90596_(), Vector3f.f_122224_) < Config.CLIENT.getCenterCameraWhenLookingDownAngle() * 0.01745329238474369) {
                targetXOffset = 0.0;
                targetYOffset = 0.0;
            }
            if (Config.CLIENT.doDynamicallyAdjustOffsets()) {
                Vec3 localCameraOffset = new Vec3(targetXOffset, targetYOffset, targetZOffset);
                Vec3 worldCameraOffset = new Vec3(camera.m_90597_()).m_82490_(targetYOffset).m_82549_(new Vec3(camera.m_167686_()).m_82490_(targetXOffset)).m_82549_(new Vec3(camera.m_90596_()).m_82490_(-targetZOffset)).m_82541_().m_82490_(localCameraOffset.m_82553_());
                Vec3 worldXYOffset = ShoulderHelper.calcRayTraceHeadOffset(camera, worldCameraOffset);
                Vec3 eyePosition = camera.m_90592_().m_20299_(partialTick);
                double absOffsetX = Math.abs(targetXOffset);
                double absOffsetY = Math.abs(targetYOffset);
                double absOffsetZ = Math.abs(targetZOffset);
                double targetX = absOffsetX;
                double targetY = absOffsetY;
                double clearance = (double)Minecraft.m_91087_().m_91288_().m_20205_() / 3.0;
                for (double dz = 0.0; dz <= absOffsetZ; dz += 0.03125) {
                    double newTargetY;
                    Vec3 to;
                    double scale = dz / absOffsetZ;
                    Vec3 from = eyePosition.m_82549_(worldCameraOffset.m_82490_(scale));
                    ClipContext context = new ClipContext(from, to = eyePosition.m_82549_(worldXYOffset).m_82549_(new Vec3(camera.m_90596_()).m_82490_(-dz)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, camera.m_90592_());
                    BlockHitResult hitResult = level.m_45547_(context);
                    if (hitResult.m_6662_() == HitResult.Type.MISS) continue;
                    double distance = hitResult.m_82450_().m_82554_(from);
                    double newTargetX = Math.max(distance + absOffsetX * scale - clearance, 0.0);
                    if (newTargetX < targetX) {
                        targetX = newTargetX;
                    }
                    if (!((newTargetY = Math.max(distance + absOffsetY * scale - clearance, 0.0)) < targetY)) continue;
                    targetY = newTargetY;
                }
                targetXOffset = Math.signum(Config.CLIENT.getOffsetX()) * targetX;
                targetYOffset = Math.signum(Config.CLIENT.getOffsetY()) * targetY;
            }
            instance.setTargetOffsetX(targetXOffset);
            instance.setTargetOffsetY(targetYOffset);
            instance.setTargetOffsetZ(targetZOffset);
            CameraAccessor accessor = (CameraAccessor)camera;
            double x = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19854_, (double)camera.m_90592_().m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19855_, (double)camera.m_90592_().m_20186_()) + (double)Mth.m_14179_((float)partialTick, (float)accessor.getEyeHeightOld(), (float)accessor.getEyeHeight());
            double z = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19856_, (double)camera.m_90592_().m_20189_());
            accessor.invokeSetPosition(x, y, z);
            double offsetX = Mth.m_14139_((double)partialTick, (double)instance.getOffsetXOld(), (double)instance.getOffsetX());
            double offsetY = Mth.m_14139_((double)partialTick, (double)instance.getOffsetYOld(), (double)instance.getOffsetY());
            double offsetZ = Mth.m_14139_((double)partialTick, (double)instance.getOffsetZOld(), (double)instance.getOffsetZ());
            Vec3 offset = new Vec3(offsetX, offsetY, offsetZ);
            this.cameraDistance = this.calcCameraDistance(camera, level, accessor.invokeGetMaxZoom(offset.m_82553_()), partialTick);
            Vec3 scaled = offset.m_82541_().m_82490_(this.cameraDistance);
            this.cameraOffsetX = scaled.f_82479_;
            this.cameraOffsetY = scaled.f_82480_;
            this.cameraOffsetZ = scaled.f_82481_;
            accessor.invokeMove(-scaled.f_82481_, scaled.f_82480_, scaled.f_82479_);
        }
    }

    private double calcCameraDistance(Camera camera, Level level, double distance, float partialTick) {
        Vec3 cameraPos = camera.m_90583_();
        Vec3 cameraOffset = ShoulderHelper.calcCameraOffset(camera, distance, partialTick);
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            Vec3 to;
            Vec3 offset = new Vec3((double)(i & 1), (double)(i >> 1 & 1), (double)(i >> 2 & 1)).m_82490_(2.0).m_82492_(1.0, 1.0, 1.0).m_82490_(0.075).m_82524_(-camera.m_90590_() * ((float)Math.PI / 180));
            Vec3 from = cameraPos.m_82549_(offset);
            ClipContext context = new ClipContext(from, to = from.m_82549_(cameraOffset), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, camera.m_90592_());
            BlockHitResult hitResult = level.m_45547_(context);
            if (hitResult.m_6662_() == HitResult.Type.MISS || !((newDistance = hitResult.m_82450_().m_82554_(cameraPos)) < distance)) continue;
            distance = newDistance;
        }
        return distance;
    }

    public void updateDynamicRaytrace(Camera camera, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float partialTick) {
        if (ShoulderInstance.getInstance().doShoulderSurfing()) {
            Minecraft minecraft = Minecraft.m_91087_();
            MultiPlayerGameMode gameMode = minecraft.f_91072_;
            HitResult hitResult = ShoulderHelper.traceBlocksAndEntities(camera, gameMode, this.getPlayerReach(), ClipContext.Fluid.NONE, partialTick, true, false);
            Vec3 position = hitResult.m_82450_().m_82546_(camera.m_90583_());
            this.projected = this.project2D(position, modelViewMatrix, projectionMatrix);
        }
    }

    @Nullable
    private Vec2f project2D(Vec3 position, Matrix4f modelView, Matrix4f projection) {
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85443_();
        int screenHeight = window.m_85444_();
        if (screenWidth == 0 || screenHeight == 0) {
            return null;
        }
        Vector4f vec = new Vector4f((float)position.m_7096_(), (float)position.m_7098_(), (float)position.m_7094_(), 1.0f);
        vec.m_123607_(modelView);
        vec.m_123607_(projection);
        if (vec.m_123617_() == 0.0f) {
            return null;
        }
        float w = 1.0f / vec.m_123617_() * 0.5f;
        float x = (vec.m_123601_() * w + 0.5f) * (float)screenWidth;
        float y = (vec.m_123615_() * w + 0.5f) * (float)screenHeight;
        float z = vec.m_123616_() * w + 0.5f;
        vec.m_123602_(x, y, z, w);
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y)) {
            return null;
        }
        return new Vec2f(x, y);
    }

    private boolean skipCameraEntityRendering() {
        Player player;
        Entity entity;
        return ShoulderInstance.getInstance().doShoulderSurfing() && (this.cameraDistance < (double)Minecraft.m_91087_().m_91288_().m_20205_() * Config.CLIENT.keepCameraOutOfHeadMultiplier() || (double)Minecraft.m_91087_().m_91288_().m_146909_() < Config.CLIENT.getCenterCameraWhenLookingDownAngle() - 90.0 || (entity = Minecraft.m_91087_().m_91288_()) instanceof Player && (player = (Player)entity).m_150108_());
    }

    public boolean preRenderCameraEntity(Entity entity, float partialTick) {
        if (this.skipCameraEntityRendering()) {
            return true;
        }
        if (this.shouldRenderCameraEntityTransparent(entity)) {
            float xAlpha = (float)Mth.m_14008_((double)(Math.abs(this.cameraOffsetX) / ((double)entity.m_20205_() / 2.0)), (double)0.0, (double)1.0);
            float yAlpha = 0.0f;
            if (this.cameraOffsetY > 0.0) {
                yAlpha = (float)Mth.m_14008_((double)(this.cameraOffsetY / (double)(entity.m_20206_() - entity.m_20192_())), (double)0.0, (double)1.0);
            } else if (this.cameraOffsetY < 0.0) {
                yAlpha = (float)Mth.m_14008_((double)(-this.cameraOffsetY / (double)(-entity.m_20192_())), (double)0.0, (double)1.0);
            }
            this.cameraEntityAlpha = Mth.m_14036_((float)((float)Math.sqrt(xAlpha * xAlpha + yAlpha * yAlpha)), (float)0.15f, (float)1.0f);
        }
        return false;
    }

    public void postRenderCameraEntity(Entity entity, float partialTick) {
        this.cameraEntityAlpha = 1.0f;
    }

    private boolean shouldRenderCameraEntityTransparent(Entity entity) {
        return ShoulderInstance.getInstance().doShoulderSurfing() && Config.CLIENT.isPlayerTransparencyEnabled() && Math.abs(this.cameraOffsetX) < (double)entity.m_20205_() / 2.0 && (this.cameraOffsetY >= 0.0 && this.cameraOffsetY < (double)(entity.m_20206_() - entity.m_20192_()) || this.cameraOffsetY <= 0.0 && -this.cameraOffsetY < (double)entity.m_20192_());
    }

    public double getPlayerReach() {
        return Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
    }

    public double getCameraDistance() {
        return this.cameraDistance;
    }

    public double getCameraOffsetX() {
        return this.cameraOffsetX;
    }

    public double getCameraOffsetY() {
        return this.cameraOffsetY;
    }

    public double getCameraOffsetZ() {
        return this.cameraOffsetZ;
    }

    public float getCameraEntityAlpha() {
        return this.cameraEntityAlpha;
    }

    public static ShoulderRenderer getInstance() {
        return INSTANCE;
    }
}

