/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.items;

import com.yellowbrossproductions.illageandspillage.entities.TrickOrTreatEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.PumpkinBombEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.ScytheEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BagOfHorrorsItemBase
extends Item {
    private final Random random = new Random();

    public BagOfHorrorsItemBase() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40757_));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player p_77659_2_, InteractionHand p_77659_3_) {
        p_77659_2_.m_5496_(SoundEvents.f_12473_, 1.0f, 0.5f);
        int randomSelection = this.random.nextInt(3);
        if (randomSelection == 0) {
            for (int i = 0; i < 4; ++i) {
                double throwSpeed = 0.7;
                PumpkinBombEntity s1 = (PumpkinBombEntity)((EntityType)ModEntityTypes.PumpkinBomb.get()).m_20615_(level);
                assert (s1 != null);
                s1.m_6034_(p_77659_2_.m_20185_(), p_77659_2_.m_20186_() + 0.25, p_77659_2_.m_20189_());
                s1.setOwner((LivingEntity)p_77659_2_);
                s1.m_6710_(level.m_45963_(Monster.class, TargetingConditions.f_26872_, (LivingEntity)p_77659_2_, p_77659_2_.m_20185_(), p_77659_2_.m_20186_(), p_77659_2_.m_20189_(), p_77659_2_.m_20191_().m_82400_(40.0)));
                if (i == 0) {
                    s1.m_20334_(-throwSpeed, 0.3, -throwSpeed);
                } else if (i == 1) {
                    s1.m_20334_(-throwSpeed, 0.3, throwSpeed);
                } else if (i == 2) {
                    s1.m_20334_(throwSpeed, 0.3, -throwSpeed);
                } else {
                    s1.m_20334_(throwSpeed, 0.3, throwSpeed);
                }
                if (p_77659_2_.m_5647_() != null) {
                    level.m_6188_().m_6546_(s1.m_20149_(), level.m_6188_().m_83489_(p_77659_2_.m_5647_().m_5758_()));
                }
                level.m_7967_((Entity)s1);
            }
        } else if (randomSelection == 1) {
            ScytheEntity scythe = (ScytheEntity)((EntityType)ModEntityTypes.Scythe.get()).m_20615_(level);
            assert (scythe != null);
            scythe.m_6034_(p_77659_2_.m_20185_(), p_77659_2_.m_20186_() + 1.5, p_77659_2_.m_20189_());
            scythe.shootFromRotation((Entity)p_77659_2_, p_77659_2_.m_146909_(), p_77659_2_.m_146908_(), 0.0f, 2.0f, 0.0f);
            scythe.setShooter((LivingEntity)p_77659_2_);
            level.m_7967_((Entity)scythe);
        } else {
            int amount = 3;
            for (int i = 0; i < amount; ++i) {
                TrickOrTreatEntity treat = (TrickOrTreatEntity)((EntityType)ModEntityTypes.TrickOrTreat.get()).m_20615_(level);
                assert (treat != null);
                treat.circleTime = i * 20;
                treat.bounceTime = i;
                treat.m_6034_(p_77659_2_.m_20185_(), p_77659_2_.m_20186_(), p_77659_2_.m_20189_());
                treat.setOwner((LivingEntity)p_77659_2_);
                treat.setTreat(this.random.nextInt(5) + 1);
                if (p_77659_2_.m_5647_() != null) {
                    level.m_6188_().m_6546_(treat.m_20149_(), level.m_6188_().m_83489_(p_77659_2_.m_5647_().m_5758_()));
                }
                this.circleTreat((Entity)treat, i, amount);
                level.m_7967_((Entity)treat);
            }
        }
        p_77659_2_.m_36335_().m_41524_((Item)this, 300);
        return super.m_7203_(level, p_77659_2_, p_77659_3_);
    }

    private void circleTreat(Entity entity, int number, int amount) {
        float TAU = (float)Math.PI * 2;
        float velocity = 0.5f;
        float yaw = (float)number * ((float)Math.PI * 2 / (float)amount);
        float vy = 0.3f;
        float vx = 0.5f * Mth.m_14089_((float)yaw);
        float vz = 0.5f * Mth.m_14031_((float)yaw);
        entity.m_20334_((double)vx, (double)vy, (double)vz);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }
}

