/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.events;

import com.yellowbrossproductions.illageandspillage.IllageAndSpillage;
import com.yellowbrossproductions.illageandspillage.entities.AbsorberEntity;
import com.yellowbrossproductions.illageandspillage.entities.BossRandomizerEntity;
import com.yellowbrossproductions.illageandspillage.entities.CrocofangEntity;
import com.yellowbrossproductions.illageandspillage.entities.DevastatorEntity;
import com.yellowbrossproductions.illageandspillage.entities.IgniterEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerBoss;
import com.yellowbrossproductions.illageandspillage.entities.IllagerSoulEntity;
import com.yellowbrossproductions.illageandspillage.entities.MagispellerEntity;
import com.yellowbrossproductions.illageandspillage.entities.OldMagispellerEntity;
import com.yellowbrossproductions.illageandspillage.entities.PreserverEntity;
import com.yellowbrossproductions.illageandspillage.entities.SpiritcallerEntity;
import com.yellowbrossproductions.illageandspillage.entities.TwittollagerEntity;
import com.yellowbrossproductions.illageandspillage.entities.goal.LoseAIGoal;
import com.yellowbrossproductions.illageandspillage.entities.goal.StareAtDeadMagiGoal;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.init.RaidWaveMembers;
import com.yellowbrossproductions.illageandspillage.util.EffectRegisterer;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="illageandspillage", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ModClientEvents {
    @SubscribeEvent
    public static void scareVillagersAway(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractVillager) {
            double runSpeed = 1.0;
            if (entity instanceof Villager) {
                runSpeed = 0.8;
            }
            if (entity instanceof WanderingTrader) {
                runSpeed = 0.5;
            }
            ((PathfinderMob)entity).f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, BossRandomizerEntity.class, 8.0f, runSpeed, runSpeed));
            ((PathfinderMob)entity).f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, IgniterEntity.class, 8.0f, runSpeed, runSpeed));
            ((PathfinderMob)entity).f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, TwittollagerEntity.class, 8.0f, runSpeed, runSpeed));
            ((PathfinderMob)entity).f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, OldMagispellerEntity.class, 8.0f, runSpeed, runSpeed));
            ((PathfinderMob)entity).f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, SpiritcallerEntity.class, 8.0f, runSpeed, runSpeed));
            ((PathfinderMob)entity).f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, CrocofangEntity.class, 8.0f, runSpeed, runSpeed));
            ((PathfinderMob)entity).f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, DevastatorEntity.class, 24.0f, runSpeed, runSpeed));
            ((PathfinderMob)entity).f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, AbsorberEntity.class, 8.0f, runSpeed, runSpeed));
        }
    }

    @SubscribeEvent
    public static void stopMobs(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            ((Mob)entity).f_21345_.m_25352_(0, (Goal)new LoseAIGoal((LivingEntity)((Mob)entity)));
            ((Mob)entity).f_21345_.m_25352_(0, (Goal)new StareAtDeadMagiGoal((Mob)entity));
        }
    }

    @SubscribeEvent
    public static void addRaidMembers(LevelEvent.Load event) {
        RaidWaveMembers.registerWaveMembers();
    }

    @SubscribeEvent
    public static void removeRaidMembers(LevelEvent.Unload event) {
        Object[] members;
        for (Raid.RaiderType raiderType : members = Raid.RaiderType.values()) {
            if (!RaidWaveMembers.CUSTOM_RAID_MEMBERS.contains(raiderType)) continue;
            ArrayUtils.remove((Object[])members, (int)raiderType.ordinal());
            IllageAndSpillage.LOGGER.info("Removed " + raiderType.name() + " from Raids to prevent a post-mod-removal crash");
        }
    }

    @SubscribeEvent
    public static void extinguishIllagers(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource reason = event.getSource();
        if (reason.m_7639_() instanceof IgniterEntity && reason.m_19360_() && !reason.m_19384_() && entity.m_6060_()) {
            entity.m_20095_();
        }
    }

    @SubscribeEvent
    public static void misconductionAttack1(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().m_21205_() == ItemStack.f_41583_ && event.getHitVec().m_82434_() == Direction.UP && event.getEntity().m_21023_((MobEffect)EffectRegisterer.MISCONDUCTION.get())) {
            BlockPos blockpos = event.getPos();
            if (event.getLevel().f_46443_) {
                event.getEntity().m_6674_(InteractionHand.MAIN_HAND);
            }
            EntityUtil.createLineImpsAttack(blockpos, (LivingEntity)event.getEntity(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), event.getLevel());
        }
    }

    @SubscribeEvent
    public static void misconductionAttack2(LivingAttackEvent event) {
        LivingEntity entity;
        List list;
        if (!event.isCanceled() && event.getSource().m_7639_() instanceof LivingEntity && ((LivingEntity)event.getSource().m_7639_()).m_21205_() == ItemStack.f_41583_ && ((LivingEntity)event.getSource().m_7639_()).m_21023_((MobEffect)EffectRegisterer.MISCONDUCTION.get()) && !event.getSource().m_19387_() && (list = entity.f_19853_.m_6443_(IllagerSoulEntity.class, (entity = (LivingEntity)event.getSource().m_7639_()).m_20191_().m_82400_(100.0), predicate -> predicate.m_5448_() == event.getEntity() && predicate.getOwner() == entity)).isEmpty()) {
            for (int i = 0; i < 3; ++i) {
                Random random = new Random();
                if (event.getEntity().f_19853_.f_46443_) continue;
                IllagerSoulEntity soul = (IllagerSoulEntity)((EntityType)ModEntityTypes.IllagerSoul.get()).m_20615_(event.getEntity().f_19853_);
                assert (soul != null);
                soul.m_6034_(event.getEntity().m_20185_() + -4.0 + (double)random.nextInt(8), event.getEntity().m_20186_() + (double)(1 + random.nextInt(4)), event.getEntity().m_20189_() + -4.0 + (double)random.nextInt(8));
                soul.setOwner(entity);
                soul.setAngelOrDevil(random.nextBoolean());
                soul.m_6710_(event.getEntity());
                soul.m_20334_(0.0, 0.1, 0.0);
                if (entity.m_5647_() != null) {
                    event.getEntity().f_19853_.m_6188_().m_6546_(soul.m_20149_(), event.getEntity().f_19853_.m_6188_().m_83489_(entity.m_5647_().m_5758_()));
                }
                event.getEntity().f_19853_.m_7967_((Entity)soul);
            }
        }
    }

    @SubscribeEvent
    public static void preventGettingHurt(LivingAttackEvent event) {
        IllagerSoulEntity soul;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof IllagerSoulEntity && (soul = (IllagerSoulEntity)entity).getOwner() == event.getEntity()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void absorberGetsHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof AbsorberEntity) {
            event.getEntity().f_19802_ = 0;
        }
    }

    @SubscribeEvent
    public static void preserverGetsHurt(LivingEvent.LivingTickEvent event) {
        PreserverEntity thing;
        LivingEntity mob = event.getEntity();
        if (mob instanceof PreserverEntity && (thing = (PreserverEntity)mob).m_6060_() && thing.m_20094_() % 5 == 1) {
            thing.f_19802_ = 3;
            thing.m_6469_(DamageSource.f_19307_, 2.0f);
        }
        if (mob.m_21023_((MobEffect)EffectRegisterer.PRESERVED.get()) && mob.m_6060_() && mob.m_20094_() % 5 == 1) {
            mob.f_19802_ = 3;
            mob.m_6469_(DamageSource.f_19307_, 2.0f);
        }
    }

    @SubscribeEvent
    public static void calculatePreservedDamage(LivingHurtEvent event) {
        LivingEntity mob = event.getEntity();
        if (mob.m_21023_((MobEffect)EffectRegisterer.PRESERVED.get()) && event.getSource() != DamageSource.f_19317_ && !event.getSource().m_19384_()) {
            event.setAmount(event.getAmount() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void mutateNegativeEffect(LivingEvent.LivingTickEvent event) {
        LivingEntity mob = event.getEntity();
        Random random = new Random();
        if (mob.m_21023_((MobEffect)EffectRegisterer.MUTATION.get())) {
            mob.m_20256_(mob.m_20184_().m_82520_((-0.5 + random.nextDouble()) * 0.1, 0.0, (-0.5 + random.nextDouble()) * 0.1));
            if (mob.f_19797_ % 15 == 0 && mob.m_21223_() > 1.0f && mob.f_19802_ < 1) {
                mob.m_6469_(DamageSource.f_19319_, 1.0f);
                mob.f_19802_ = 0;
            }
        }
    }

    @SubscribeEvent
    public static void magispellerNegateDamage(LivingHurtEvent event) {
        LivingEntity mob = event.getEntity();
        if (mob instanceof MagispellerEntity && ((MagispellerEntity)mob).isWavingArms() && event.getSource() != DamageSource.f_19317_ && !event.isCanceled()) {
            ((MagispellerEntity)mob).addDamageTaken(event.getAmount());
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void tickOffBosses(LivingHurtEvent event) {
        LivingEntity mob = event.getEntity();
        if (mob instanceof IllagerBoss && mob instanceof Mob) {
            Mob targeter = (Mob)mob;
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_150110_().f_35934_) {
                    targeter.m_6710_((LivingEntity)player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void webParticles(LivingEvent.LivingTickEvent event) {
        LivingEntity mob = event.getEntity();
        Random random = new Random();
        if (mob.m_21023_((MobEffect)EffectRegisterer.WEBBED.get())) {
            EntityUtil.makeWebParticles(mob.f_19853_, (Entity)mob);
        }
    }
}

