/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities.projectile;

import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;

public class SkullBombEntity
extends PathfinderMob
implements IllagerAttack {
    private static final EntityDataAccessor<Boolean> IS_SMALL = SynchedEntityData.m_135353_(SkullBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity owner;
    private int oldSwell;
    private int swell;
    private int maxSwell = 40;

    public SkullBombEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SMALL, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    public void m_8119_() {
        this.oldSwell = this.swell++;
        if (this.swell >= this.maxSwell) {
            this.swell = this.maxSwell;
        }
        super.m_8119_();
        if (this.f_19797_ == 1) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_SHIVER.get(), 1.0f, 1.0f);
        }
        if (this.f_19797_ == 33) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_SKULLBOMB_EXPLODE.get(), 3.0f, 1.0f);
        }
        if (this.f_19797_ >= 40) {
            this.explode();
        }
        if (this.m_20096_()) {
            this.m_20334_((-0.5 + this.f_19796_.m_188500_()) * 0.6, 0.3, (-0.5 + this.f_19796_.m_188500_()) * 0.6);
        }
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    private void explode() {
        if (!this.f_19853_.f_46443_) {
            float f = this.isSmall() ? 1.5f : 2.5f;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this.getOwner(), this.m_20185_(), this.m_20186_(), this.m_20189_(), f, Explosion.BlockInteraction.NONE);
            if (!this.isSmall()) {
                SkullBombEntity s1 = (SkullBombEntity)((EntityType)ModEntityTypes.SkullBomb.get()).m_20615_(this.f_19853_);
                assert (s1 != null);
                s1.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                s1.setSmall(true);
                s1.m_20334_(-0.3, 0.3, -0.3);
                s1.setOwner(this.getOwner());
                this.f_19853_.m_7967_((Entity)s1);
                SkullBombEntity s2 = (SkullBombEntity)((EntityType)ModEntityTypes.SkullBomb.get()).m_20615_(this.f_19853_);
                assert (s2 != null);
                s2.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                s2.setSmall(true);
                s2.m_20334_(-0.3, 0.3, 0.3);
                s1.setOwner(this.getOwner());
                this.f_19853_.m_7967_((Entity)s2);
                SkullBombEntity s3 = (SkullBombEntity)((EntityType)ModEntityTypes.SkullBomb.get()).m_20615_(this.f_19853_);
                assert (s3 != null);
                s3.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                s3.setSmall(true);
                s3.m_20334_(0.3, 0.3, -0.3);
                s1.setOwner(this.getOwner());
                this.f_19853_.m_7967_((Entity)s3);
                SkullBombEntity s4 = (SkullBombEntity)((EntityType)ModEntityTypes.SkullBomb.get()).m_20615_(this.f_19853_);
                assert (s4 != null);
                s4.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                s4.setSmall(true);
                s4.m_20334_(0.3, 0.3, 0.3);
                s1.setOwner(this.getOwner());
                this.f_19853_.m_7967_((Entity)s4);
            }
            this.m_146870_();
        }
    }

    public void m_8107_() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                double d0 = (-0.5 + this.f_19796_.m_188583_()) / 12.0;
                double d1 = (-0.5 + this.f_19796_.m_188583_()) / 12.0;
                double d2 = (-0.5 + this.f_19796_.m_188583_()) / 12.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_() + 0.25, this.m_20262_(1.0), d0, d1, d2);
            }
        }
        super.m_8107_();
    }

    public boolean isSmall() {
        return (Boolean)this.f_19804_.m_135370_(IS_SMALL);
    }

    public void setSmall(boolean small) {
        this.f_19804_.m_135381_(IS_SMALL, (Object)small);
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (p_21016_ != DamageSource.f_19317_) {
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public void m_6667_(DamageSource p_21014_) {
        this.f_20919_ = 19;
        super.m_6667_(p_21014_);
    }
}

