/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.FreakagerEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerBoss;
import com.yellowbrossproductions.illageandspillage.entities.TrickOrTreatEntity;
import com.yellowbrossproductions.illageandspillage.entities.VillagerSoulEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.PumpkinBombEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.WebEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;

public class RagnoEntity
extends Raider
implements IllagerBoss,
ICanBeAnimated {
    private static final UUID SPEED_PENALTY_UUID = UUID.fromString("5CD17A52-AB9A-42D3-A629-90FDE04B281E");
    private static final AttributeModifier SPEED_PENALTY;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE;
    private static final EntityDataAccessor<Boolean> CRAZY;
    private static final EntityDataAccessor<Boolean> STUNNED;
    private static final EntityDataAccessor<Integer> ATTACK_TYPE;
    public AnimationState introAnimationState = new AnimationState();
    public AnimationState phaseAnimationState = new AnimationState();
    public AnimationState blockAnimationState = new AnimationState();
    public AnimationState webAnimationState = new AnimationState();
    public AnimationState leapAnimationState = new AnimationState();
    public AnimationState burrowAnimationState = new AnimationState();
    public AnimationState popupAnimationState = new AnimationState();
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState coughAnimationState = new AnimationState();
    public AnimationState stunAnimationState = new AnimationState();
    public int attackType;
    private int attackTicks;
    private int attackCooldown;
    private int WEB_ATTACK = 1;
    private int LEAP_ATTACK = 2;
    private int BURROW_ATTACK = 3;
    private int CHARGE_ATTACK = 4;
    private int COUGH_ATTACK = 5;
    private int webCooldown;
    private int leapCooldown;
    private int burrowCooldown;
    private int chargeCooldown;
    private int coughCooldown;
    int introTicks;
    int phaseTicks;
    private Mob owner;
    public ItemEntity item = null;
    int blockTicks;
    boolean shouldHurtOnTouch;
    public boolean isPlayingIntro;
    public double chargeX;
    public double chargeZ;
    public boolean circleDirection;
    public int circleTick;
    public int attacksUsed;
    public int stunTick;
    private boolean isBurrowing = false;

    public RagnoEntity(EntityType<? extends Raider> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 40;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new StunGoal());
        this.f_21345_.m_25352_(0, (Goal)new WebGoal());
        this.f_21345_.m_25352_(0, (Goal)new LeapGoal());
        this.f_21345_.m_25352_(0, (Goal)new BurrowGoal());
        this.f_21345_.m_25352_(0, (Goal)new ChargeGoal());
        this.f_21345_.m_25352_(0, (Goal)new CoughGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AlwaysWatchTargetGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean m_7327_(Entity p_21372_) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 160.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(CRAZY, (Object)false);
        this.f_19804_.m_135372_(STUNNED, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public boolean isCrazy() {
        return (Boolean)this.f_19804_.m_135370_(CRAZY);
    }

    public void setCrazy(boolean crazy) {
        this.f_19804_.m_135381_(CRAZY, (Object)crazy);
    }

    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(STUNNED);
    }

    public void setStunned(boolean stunned) {
        this.f_19804_.m_135381_(STUNNED, (Object)stunned);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
    }

    public void m_7378_(CompoundTag p_37862_) {
        super.m_7378_(p_37862_);
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        if (this.isPlayingIntro) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.m_37886_() && this.m_37885_() != null) {
            this.m_37885_().m_37776_();
        }
        if (this.owner == null && this.f_19797_ > 5) {
            List list = this.f_19853_.m_45976_(FreakagerEntity.class, this.m_20191_().m_82400_(2.0));
            if (!list.isEmpty()) {
                this.owner = (Mob)list.get(this.f_19796_.m_188503_(list.size()));
            }
            if (this.owner == null && !this.f_19853_.f_46443_) {
                this.setCrazy(true);
            }
        }
        if (this.getOwner() != null) {
            if (this.getOwner().m_6084_()) {
                this.m_6710_(this.getOwner().m_5448_());
            }
            if (this.getOwner().m_21224_() && this.phaseTicks < 1) {
                if (!this.f_19853_.f_46443_) {
                    this.stopAttacking();
                }
                this.isPlayingIntro = true;
                this.setAnimationState(2);
                this.phaseTicks = 1;
            }
        }
        if (this.getAttackType() > 0 || this.isPlayingIntro || this.isStunned()) {
            AttributeInstance $$4 = this.m_21051_(Attributes.f_22279_);
            assert ($$4 != null);
            $$4.m_22130_(SPEED_PENALTY);
            $$4.m_22118_(SPEED_PENALTY);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(SPEED_PENALTY);
        }
        if (this.f_19796_.m_188503_(200) == 0) {
            boolean bl = this.circleDirection = !this.circleDirection;
        }
        this.circleTick = this.circleDirection ? ++this.circleTick : --this.circleTick;
        if (this.stunTick > 0) {
            this.m_21573_().m_26573_();
            this.f_21344_.m_26573_();
        }
        this.stopAttackersFromAttacking();
        if (this.blockTicks > 0) {
            --this.blockTicks;
        }
        if (this.introTicks > 0) {
            ++this.introTicks;
        }
        if (this.introTicks == 21) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_ROAR.get(), 3.0f, 1.0f);
        }
        if (this.introTicks == 24) {
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 50.0f, 0.05f, 48, 20);
        }
        if (this.introTicks == 70) {
            this.isPlayingIntro = false;
            this.setAnimationState(0);
        }
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        if (this.phaseTicks > 0) {
            ++this.phaseTicks;
        }
        if (this.phaseTicks == 19) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, 1.0f);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_EAT.get(), 2.0f, 1.0f);
        }
        if (this.phaseTicks == 20 && this.item != null) {
            this.makeSpitParticles((Entity)this.item);
            this.item.m_146870_();
        }
        if (this.phaseTicks == 27) {
            if (!this.f_19853_.f_46443_) {
                this.setCrazy(true);
            }
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 50.0f, 0.1f, 0, 20);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.0f);
        }
        if (this.phaseTicks == 43) {
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 50.0f, 0.05f, 0, 30);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.5f);
        }
        if (this.phaseTicks == 60) {
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 50.0f, 0.05f, 0, 30);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.4f);
        }
        if (this.phaseTicks == 50) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 0.7f);
        }
        if (this.phaseTicks == 80) {
            this.isPlayingIntro = false;
            this.attackTicks = 0;
            this.setAttackType(0);
            this.setAnimationState(0);
        }
        if (this.getAttackType() > 0) {
            ++this.attackTicks;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.getAttackType() < 1) {
            if (this.webCooldown > 0) {
                --this.webCooldown;
            }
            if (this.leapCooldown > 0) {
                --this.leapCooldown;
            }
            if (this.burrowCooldown > 0) {
                --this.burrowCooldown;
            }
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
            }
            if (this.coughCooldown > 0) {
                --this.coughCooldown;
            }
        }
        if (this.m_6084_()) {
            double z;
            double x;
            double motionZ;
            double motionY;
            double motionX;
            double y;
            double x2;
            int i;
            LivingEntity entity;
            if (this.getAttackType() == this.WEB_ATTACK) {
                entity = this.m_5448_();
                if (this.attackTicks == 4) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.5, 0.0));
                }
                if (this.attackTicks == 6 && entity != null) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB.get(), 2.0f, 1.0f);
                    for (i = 0; i < 8; ++i) {
                        if (this.f_19853_.f_46443_) continue;
                        WebEntity projectile = (WebEntity)((EntityType)ModEntityTypes.Web.get()).m_20615_(this.f_19853_);
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        x2 = projectile.m_20185_() - entity.m_20185_();
                        y = projectile.m_20186_() - (entity.m_20186_() + 1.5);
                        double z2 = projectile.m_20189_() - entity.m_20189_();
                        double d = Math.sqrt(x2 * x2 + y * y + z2 * z2);
                        float power = 2.5f;
                        motionX = -(x2 / d * (double)power * 0.2);
                        motionY = -(y / d * (double)power * 0.2);
                        motionZ = -(z2 / d * (double)power * 0.2);
                        double randomX = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomY = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomZ = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        projectile.setAcceleration(motionX + randomX, motionY + randomY, motionZ + randomZ);
                        projectile.setShooter((Mob)this);
                        this.f_19853_.m_7967_((Entity)projectile);
                    }
                }
                if (this.attackTicks == 10) {
                    this.m_20334_(0.0, -1.0, 0.0);
                }
            }
            if (this.getAttackType() == this.LEAP_ATTACK) {
                LivingEntity target = this.m_5448_();
                double motionX2 = 0.0;
                double motionY2 = 0.0;
                double motionZ2 = 0.0;
                if (target != null) {
                    double x3 = this.m_20185_() - this.m_5448_().m_20185_();
                    double y2 = this.m_20186_() - (this.m_5448_().m_20186_() + 1.5);
                    double z3 = this.m_20189_() - this.m_5448_().m_20189_();
                    double d = Math.sqrt(x3 * x3 + y2 * y2 + z3 * z3);
                    float power = 6.5f;
                    motionX2 = -(x3 / d * (double)power * 0.2);
                    motionY2 = -(y2 / d * (double)power * 0.02);
                    motionZ2 = -(z3 / d * (double)power * 0.2);
                }
                if (this.attackTicks == 6) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.attackTicks == 17) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.attackTicks == 30) {
                    this.shouldHurtOnTouch = true;
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, this.m_6100_());
                    this.m_20334_(motionX2, motionY2 > 0.0 ? motionY2 + 0.2 : 0.2, motionZ2);
                }
                if (this.shouldHurtOnTouch) {
                    for (Entity entity2 : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(entity2, (Mob)this) || !(entity2 instanceof LivingEntity) || !entity2.m_6084_()) continue;
                        x = this.m_20185_() - entity2.m_20185_();
                        double y3 = this.m_20186_() - entity2.m_20186_();
                        z = this.m_20189_() - entity2.m_20189_();
                        double d = Math.sqrt(x * x + y3 * y3 + z * z);
                        if (!(this.m_20280_(entity2) < 9.0)) continue;
                        if (entity2.f_19802_ <= 0) {
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                            entity2.m_6469_(DamageSource.m_19370_((LivingEntity)this), 8.0f);
                            entity2.f_19864_ = true;
                            entity2.m_20334_(-x / d * 2.0, -y3 / d * 2.0 + 0.5, -z / d * 2.0);
                        }
                        if (!((LivingEntity)entity2).m_21254_()) continue;
                        EntityUtil.disableShield((LivingEntity)entity2, 100);
                    }
                }
            }
            if (this.getAttackType() == this.BURROW_ATTACK) {
                if (this.attackTicks > 6 && this.attackTicks <= 30) {
                    this.m_5496_(SoundEvents.f_11993_, 2.0f, 0.7f);
                    this.makeBlockParticles(this.m_20075_());
                    this.isBurrowing = true;
                }
                if (this.attackTicks >= 30 && this.m_5448_() != null) {
                    this.m_20095_();
                    if (this.attackTicks < 100) {
                        this.m_5496_(SoundEvents.f_12442_, 2.0f, 0.5f);
                    }
                    entity = this.m_5448_();
                    double targetX = this.m_20185_();
                    double targetY = this.m_20186_();
                    double targetZ = this.m_20189_();
                    if (this.attackTicks < 100) {
                        this.m_6842_(true);
                        targetX = entity.m_20185_();
                        targetY = entity.m_20186_();
                        targetZ = entity.m_20189_();
                    }
                    this.m_6034_(targetX, targetY, targetZ);
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (this.attackTicks == 120) {
                        this.makeBlockParticles(this.m_20075_());
                        this.setAnimationState(7);
                        this.m_6842_(false);
                        CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 50.0f, 0.05f, 0, 30);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.6f);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.2f);
                        for (Entity hit : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                            if (!EntityUtil.canHurtThisMob(hit, (Mob)this) || !(hit instanceof LivingEntity) || !hit.m_6084_() || hit == this) continue;
                            x = this.m_20185_() - hit.m_20185_();
                            double y4 = this.m_20186_() - hit.m_20186_();
                            z = this.m_20189_() - hit.m_20189_();
                            double d = Math.sqrt(x * x + y4 * y4 + z * z);
                            if (!(this.m_20280_(hit) < 9.0) || hit.f_19802_ > 0) continue;
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                            hit.m_6469_(DamageSource.m_19370_((LivingEntity)this), 8.0f);
                            hit.f_19864_ = true;
                            hit.m_20334_(-x / d * 2.0, -y4 / d * 2.0 + 0.8, -z / d * 2.0);
                            hit.m_6001_(-x / d * 2.0, -y4 / d * 2.0 + 0.8, -z / d * 2.0);
                        }
                        this.m_20334_(0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.getAttackType() == this.CHARGE_ATTACK) {
                entity = this.m_5448_();
                if (this.attackTicks == 30 && entity != null) {
                    double x4 = this.m_20185_() - entity.m_20185_();
                    double y5 = this.m_20186_() - entity.m_20186_();
                    double z4 = this.m_20189_() - entity.m_20189_();
                    double d = Math.sqrt(x4 * x4 + y5 * y5 + z4 * z4);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_CHARGE.get(), 2.0f, this.m_6100_());
                    float power = 4.5f;
                    double motionX3 = -(x4 / d * (double)power * 0.2);
                    double motionZ3 = -(z4 / d * (double)power * 0.2);
                    this.chargeX = motionX3;
                    this.chargeZ = motionZ3;
                }
                if (this.attackTicks > 30) {
                    this.m_20334_(this.chargeX, this.m_20184_().f_82480_, this.chargeZ);
                    for (Entity hit : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(hit, (Mob)this) || !(hit instanceof LivingEntity) || !hit.m_6084_() || hit == this) continue;
                        double hitX = this.m_20185_() - hit.m_20185_();
                        double hitY = this.m_20186_() - hit.m_20186_();
                        double hitZ = this.m_20189_() - hit.m_20189_();
                        double hitD = Math.sqrt(hitX * hitX + hitY * hitY + hitZ * hitZ);
                        if (!(this.m_20280_(hit) < 9.0) || hit.f_19802_ > 0) continue;
                        this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                        hit.m_6469_(DamageSource.m_19370_((LivingEntity)this), 8.0f);
                        hit.f_19864_ = true;
                        hit.m_20334_(-hitX / hitD * 2.0, -hitY / hitD * 2.0 + 1.2, -hitZ / hitD * 2.0);
                        hit.m_6001_(-hitX / hitD * 2.0, -hitY / hitD * 2.0 + 1.2, -hitZ / hitD * 2.0);
                    }
                }
            }
            if (this.getAttackType() == this.COUGH_ATTACK && this.attackTicks == 10 && this.m_5448_() != null) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_COUGH.get(), 2.0f, 1.0f);
                CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 50.0f, 0.06f, 0, 10);
                entity = this.m_5448_();
                if (this.f_19796_.m_188499_()) {
                    for (i = 0; i < 4; ++i) {
                        if (this.f_19853_.f_46443_) continue;
                        treat = (TrickOrTreatEntity)((EntityType)ModEntityTypes.TrickOrTreat.get()).m_20615_(this.f_19853_);
                        assert (treat != null);
                        treat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        x2 = this.m_20185_() - entity.m_20185_();
                        y = this.m_20186_() - entity.m_20186_();
                        double z5 = this.m_20189_() - entity.m_20189_();
                        double d = Math.sqrt(x2 * x2 + y * y + z5 * z5);
                        float power = 4.5f;
                        motionX = -(x2 / d * (double)power * 0.2);
                        motionY = -(y / d * (double)power * 0.2);
                        motionZ = -(z5 / d * (double)power * 0.2);
                        treat.m_20334_(motionX, motionY, motionZ);
                        treat.circleTime = i * 10;
                        treat.bounceTime = i;
                        treat.setTreat(this.f_19796_.m_188503_(5) + 1);
                        if (this.m_5647_() != null) {
                            this.f_19853_.m_6188_().m_6546_(treat.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        treat.setOwner((LivingEntity)this);
                        treat.setGoopy();
                        this.f_19853_.m_7967_((Entity)treat);
                    }
                } else {
                    for (i = 0; i < 3; ++i) {
                        if (this.f_19853_.f_46443_) continue;
                        treat = (PumpkinBombEntity)((EntityType)ModEntityTypes.PumpkinBomb.get()).m_20615_(this.f_19853_);
                        assert (treat != null);
                        treat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        x2 = this.m_20185_() - entity.m_20185_();
                        y = this.m_20186_() - entity.m_20186_();
                        double z6 = this.m_20189_() - entity.m_20189_();
                        double d = Math.sqrt(x2 * x2 + y * y + z6 * z6);
                        float power = 4.5f;
                        motionX = -(x2 / d * (double)power * 0.2);
                        motionY = -(y / d * (double)power * 0.2);
                        motionZ = -(z6 / d * (double)power * 0.2);
                        if (this.m_5647_() != null) {
                            this.f_19853_.m_6188_().m_6546_(treat.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        treat.m_20334_(motionX, motionY, motionZ);
                        treat.setOwner((LivingEntity)this);
                        treat.m_6710_(this.m_5448_());
                        treat.setGoopy();
                        this.f_19853_.m_7967_((Entity)treat);
                    }
                }
            }
        }
        if (this.attackType == 0 && !this.isPlayingIntro && this.m_5448_() != null && !this.isStunned()) {
            this.circleTarget((Entity)this.m_5448_(), 10.0f, 0.8f, true, this.circleTick, 0.0f, 1.0f);
            this.m_21391_((Entity)this.m_5448_(), 100.0f, 100.0f);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
        }
        if (this.attacksUsed >= (Integer)IllageAndSpillageConfig.ragno_attackTimes.get() && !this.isStunned()) {
            this.setStunned(true);
        }
        if (this.isStunned()) {
            this.m_21573_().m_26573_();
            ++this.stunTick;
            if (this.stunTick == 6) {
                this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_STUN.get(), 3.0f, 1.0f);
            }
            if (this.stunTick % 5 == 0) {
                this.makeSweatParticles();
            }
            this.f_21344_.m_26573_();
        }
        if (this.m_5448_() != null && this.m_6084_() && (double)this.m_20270_((Entity)this.m_5448_()) < 8.0 * ((double)this.m_5448_().m_20205_() + 0.4) && this.getAttackType() == 0 && this.m_20096_() && !this.isStunned() && !this.isPlayingIntro) {
            double x = this.m_20185_() - this.m_5448_().m_20185_();
            double y = this.m_20186_() - this.m_5448_().m_20186_();
            double z = this.m_20189_() - this.m_5448_().m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            this.m_20256_(this.m_20184_().m_82492_(-x / d * 0.08, 0.0, -z / d * 0.08));
        }
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int attackType) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attackType);
    }

    public void stopAttacking() {
        this.setAttackType(0);
    }

    public void m_7334_(Entity p_21294_) {
        if ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 6) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_6138_() {
        if ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 6) {
            super.m_6138_();
        }
    }

    public void m_6667_(DamageSource p_37847_) {
        List treats = this.f_19853_.m_45976_(TrickOrTreatEntity.class, this.m_20191_().m_82400_(40.0));
        if (!treats.isEmpty()) {
            for (TrickOrTreatEntity treat : treats) {
                if (treat.getOwner() != this) continue;
                treat.m_6074_();
            }
        }
        if (this.m_37886_() && this.m_37885_() != null) {
            this.m_37885_().f_37673_ = 0L;
        }
        this.m_20095_();
        if (!this.f_19853_.f_46443_) {
            this.attackTicks = 0;
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        }
        if (this.f_20889_ > 0) {
            this.f_20889_ = 10000;
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 100) {
            VillagerSoulEntity soul = (VillagerSoulEntity)((EntityType)ModEntityTypes.VillagerSoul.get()).m_20615_(this.f_19853_);
            assert (soul != null);
            soul.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            soul.m_20334_(0.0, 0.3, 0.0);
            soul.m_6710_(this.m_21188_());
            this.f_19853_.m_7967_((Entity)soul);
        }
        if (this.f_20919_ == 200 && !this.f_19853_.m_5776_()) {
            super.m_6667_(DamageSource.f_19318_);
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_5825_() {
        return super.m_5825_() && !this.m_21224_();
    }

    public void makeSpitParticles(Entity caught) {
        if (!this.f_19853_.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_6907_()) {
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 12; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123769_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    private void circleTarget(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        if (!this.isStunned()) {
            int directionInt = direction ? 1 : 1;
            double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
            Vec3 movePos = target.m_20182_().m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
            this.m_21573_().m_26519_(movePos.m_7096_(), movePos.m_7098_(), movePos.m_7094_(), (double)(speed * moveSpeedMultiplier));
        }
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_CRAWL.get(), 0.5f, 1.0f);
    }

    public void makeBlockParticles(BlockState blockstate) {
        if (!this.f_19853_.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_6907_()) {
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 12; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    BlockParticleOption block = new BlockParticleOption(ParticleTypes.f_123794_, blockstate);
                    packet.queueParticle((ParticleOptions)block, false, new Vec3(this.m_20208_(0.5), this.m_20186_(), this.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public void makeSweatParticles() {
        if (!this.f_19853_.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_6907_()) {
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 2; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123769_, false, new Vec3(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }

    public void stopAttackersFromAttacking() {
        List list = this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        if (this.getOwner() != null && this.getOwner().m_6084_()) {
            for (Mob attacker : list) {
                if (attacker.m_21188_() == this && this.getOwner() != null) {
                    attacker.m_6703_((LivingEntity)this.getOwner());
                }
                if (attacker.m_5448_() == this && this.getOwner() != null) {
                    attacker.m_6710_((LivingEntity)this.getOwner());
                }
                Mob owner = this.getOwner();
                if (!(attacker instanceof Warden)) {
                    try {
                        if (attacker.m_6274_() == null || !attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_) || !attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() || attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() != this) continue;
                        attacker.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)owner.m_20148_(), 600L);
                        attacker.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)owner, 600L);
                    }
                    catch (NullPointerException nullPointerException) {}
                    continue;
                }
                Warden warden = (Warden)attacker;
                if (warden.m_5448_() != this) continue;
                warden.m_219387_((Entity)owner, AngerLevel.ANGRY.m_219226_() + 100, false);
                warden.m_219459_((LivingEntity)owner);
            }
        }
    }

    public boolean m_20329_(Entity p_20330_) {
        return false;
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (this.getOwner() != null && p_37849_.m_7639_() == this.getOwner()) {
            return false;
        }
        if (this.isBurrowing) {
            return false;
        }
        if (this.m_6084_() && p_37849_ != DamageSource.f_19317_) {
            if (!this.isCrazy()) {
                boolean source;
                boolean bl = source = !p_37849_.m_19376_();
                if (source && this.blockTicks < 1 && ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 0 || (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 3)) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_BLOCK.get(), 2.0f, 1.0f);
                    this.setAnimationState(0);
                    this.setAnimationState(3);
                    this.blockTicks = 10;
                }
                if (p_37849_.m_7639_() instanceof LivingEntity && this.m_21188_() == null) {
                    this.m_6703_((LivingEntity)p_37849_.m_7639_());
                }
                return false;
            }
            if (!this.isStunned()) {
                boolean source;
                boolean bl = source = !p_37849_.m_19376_();
                if (source && this.getAttackType() == 0) {
                    if (this.blockTicks < 1 && ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 0 || (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 3)) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_BLOCK.get(), 2.0f, 1.0f);
                        this.setAnimationState(0);
                        this.setAnimationState(3);
                        this.blockTicks = 10;
                    }
                    if (p_37849_.m_7639_() instanceof LivingEntity && this.m_21188_() == null) {
                        this.m_6703_((LivingEntity)p_37849_.m_7639_());
                    }
                    return false;
                }
                p_37850_ /= 3.5f;
            }
        }
        if (p_37849_ == DamageSource.f_19310_) {
            return false;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_AMBIENT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_DEATH.get();
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_21532_() {
        return true;
    }

    public double m_6048_() {
        return 2.5;
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (input == "intro") {
            return this.introAnimationState;
        }
        if (input == "phase") {
            return this.phaseAnimationState;
        }
        if (input == "block") {
            return this.blockAnimationState;
        }
        if (input == "web") {
            return this.webAnimationState;
        }
        if (input == "leap") {
            return this.leapAnimationState;
        }
        if (input == "burrow") {
            return this.burrowAnimationState;
        }
        if (input == "popup") {
            return this.popupAnimationState;
        }
        if (input == "charge") {
            return this.chargeAnimationState;
        }
        if (input == "cough") {
            return this.coughAnimationState;
        }
        if (input == "stun") {
            return this.stunAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.introAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.phaseAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.blockAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.webAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.leapAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.burrowAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.popupAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.chargeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.coughAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.stunAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.introAnimationState.m_216973_();
        this.phaseAnimationState.m_216973_();
        this.blockAnimationState.m_216973_();
        this.webAnimationState.m_216973_();
        this.leapAnimationState.m_216973_();
        this.burrowAnimationState.m_216973_();
        this.popupAnimationState.m_216973_();
        this.chargeAnimationState.m_216973_();
        this.coughAnimationState.m_216973_();
        this.stunAnimationState.m_216973_();
    }

    public void playIntro() {
        this.setAnimationState(1);
        this.introTicks = 1;
        this.isPlayingIntro = true;
    }

    public void setAnimationState(int input) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)input);
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.getAttackType() == 0 && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.attackCooldown < 1 && !this.isStunned() && !this.isPlayingIntro;
    }

    static {
        ANIMATION_STATE = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CRAZY = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        STUNNED = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        ATTACK_TYPE = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_FLAGS_ID = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        SPEED_PENALTY = new AttributeModifier(SPEED_PENALTY_UUID, "STOP MOVING AROUND STUPID", -0.35, AttributeModifier.Operation.ADDITION);
    }

    class StunGoal
    extends Goal {
        public StunGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.isStunned();
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(10);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.stunTick <= 100;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.attackTicks = 0;
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.attackCooldown = 40;
            RagnoEntity.this.attacksUsed = 0;
            RagnoEntity.this.stunTick = 0;
            RagnoEntity.this.setStunned(false);
        }
    }

    class WebGoal
    extends Goal {
        public WebGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && RagnoEntity.this.f_19796_.m_188503_(16) == 0 && RagnoEntity.this.webCooldown < 1;
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(4);
            RagnoEntity.this.setAttackType(RagnoEntity.this.WEB_ATTACK);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.attackTicks <= 17 && RagnoEntity.this.getAttackType() == RagnoEntity.this.WEB_ATTACK;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            if (!RagnoEntity.this.isPlayingIntro) {
                RagnoEntity.this.setAnimationState(0);
            }
            RagnoEntity.this.attackTicks = 0;
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.webCooldown = 200;
            RagnoEntity.this.attackCooldown = 20;
            if (RagnoEntity.this.isCrazy()) {
                ++RagnoEntity.this.attacksUsed;
            }
        }
    }

    class LeapGoal
    extends Goal {
        public LeapGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && RagnoEntity.this.f_19796_.m_188503_(16) == 0 && RagnoEntity.this.leapCooldown < 1 && RagnoEntity.this.m_5448_() != null && (double)RagnoEntity.this.m_20270_((Entity)RagnoEntity.this.m_5448_()) < 12.0;
        }

        public void m_8056_() {
            RagnoEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 1.0f);
            RagnoEntity.this.setAnimationState(5);
            RagnoEntity.this.setAttackType(RagnoEntity.this.LEAP_ATTACK);
        }

        public boolean m_8045_() {
            return (RagnoEntity.this.attackTicks <= 40 || !RagnoEntity.this.m_20096_()) && RagnoEntity.this.getAttackType() == RagnoEntity.this.LEAP_ATTACK;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            if (!RagnoEntity.this.isPlayingIntro) {
                RagnoEntity.this.setAnimationState(0);
            }
            RagnoEntity.this.attackTicks = 0;
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.shouldHurtOnTouch = false;
            RagnoEntity.this.leapCooldown = 100;
            RagnoEntity.this.attackCooldown = 20;
            if (RagnoEntity.this.isCrazy()) {
                ++RagnoEntity.this.attacksUsed;
            }
        }
    }

    class BurrowGoal
    extends Goal {
        public BurrowGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && RagnoEntity.this.f_19796_.m_188503_(16) == 0 && RagnoEntity.this.burrowCooldown < 1 && RagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(6);
            RagnoEntity.this.setAttackType(RagnoEntity.this.BURROW_ATTACK);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.attackTicks <= 138;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.attackTicks = 0;
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.burrowCooldown = 160;
            RagnoEntity.this.attackCooldown = 20;
            ++RagnoEntity.this.attacksUsed;
            RagnoEntity.this.m_6842_(false);
            RagnoEntity.this.isBurrowing = false;
        }
    }

    class ChargeGoal
    extends Goal {
        public ChargeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && RagnoEntity.this.f_19796_.m_188503_(16) == 0 && RagnoEntity.this.chargeCooldown < 1 && RagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            RagnoEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 0.9f);
            RagnoEntity.this.setAnimationState(8);
            RagnoEntity.this.setAttackType(RagnoEntity.this.CHARGE_ATTACK);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.attackTicks <= 70;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.attackTicks = 0;
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.chargeCooldown = 160;
            RagnoEntity.this.attackCooldown = 20;
            ++RagnoEntity.this.attacksUsed;
        }
    }

    class CoughGoal
    extends Goal {
        public CoughGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && RagnoEntity.this.f_19796_.m_188503_(16) == 0 && RagnoEntity.this.coughCooldown < 1 && RagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(9);
            RagnoEntity.this.setAttackType(RagnoEntity.this.COUGH_ATTACK);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.attackTicks <= 70;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.attackTicks = 0;
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.coughCooldown = 200;
            RagnoEntity.this.attackCooldown = 20;
            ++RagnoEntity.this.attacksUsed;
        }
    }

    class AlwaysWatchTargetGoal
    extends Goal {
        public AlwaysWatchTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.isPlayingIntro;
        }

        public boolean m_8045_() {
            return RagnoEntity.this.isPlayingIntro;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.isPlayingIntro = false;
            RagnoEntity.this.setAnimationState(0);
        }
    }
}

