/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.CrocofangEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerBoss;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import com.yellowbrossproductions.illageandspillage.entities.TrickOrTreatEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.AxeEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.DarkPotionEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.PumpkinBombEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.ScytheEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.SkullBombEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import com.yellowbrossproductions.illageandspillage.util.PotionRegisterer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class FreakagerEntity
extends AbstractIllager
implements IllagerBoss,
ICanBeAnimated {
    private static final EntityDataAccessor<Boolean> SHOULD_DELETE_ITSELF = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NEARBY_ILLAGERS = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOW_ARMS = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOW_VILLAGER = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VILLAGER_FACE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SCYTHE = SynchedEntityData.m_135353_(FreakagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int introTicks;
    public AnimationState introAnimationState = new AnimationState();
    public AnimationState laughAnimationState = new AnimationState();
    public AnimationState bombsAnimationState = new AnimationState();
    public AnimationState axesAnimationState = new AnimationState();
    public AnimationState fastaxesAnimationState = new AnimationState();
    public AnimationState potionsAnimationState = new AnimationState();
    public AnimationState scytheAnimationState = new AnimationState();
    public AnimationState trickortreatAnimationState = new AnimationState();
    private int attackType;
    private int attackTicks;
    private int attackCooldown;
    private int BOMBS_ATTACK = 1;
    private int AXES_ATTACK = 2;
    private int FAST_AXES_ATTACK = 3;
    private int POTIONS_ATTACK = 4;
    private int SCYTHE_ATTACK = 5;
    private int TRICKORTREAT_ATTACK = 6;
    private int bombsCooldown;
    private int axesCooldown;
    private int potionsCooldown;
    private int scytheCooldown;
    private int trickOrTreatCooldown;
    private double potionThrowDistance;
    public boolean waitingForScythe;
    private final List<TrickOrTreatEntity> treats = new ArrayList<TrickOrTreatEntity>();
    private RagnoEntity ragno = null;

    public FreakagerEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 20;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TrickOrTreatGoal());
        this.f_21345_.m_25352_(0, (Goal)new ScytheGoal());
        this.f_21345_.m_25352_(0, (Goal)new PotionsGoal());
        this.f_21345_.m_25352_(0, (Goal)new FastAxesGoal());
        this.f_21345_.m_25352_(0, (Goal)new AxesGoal());
        this.f_21345_.m_25352_(0, (Goal)new ThrowBombsGoal());
        this.f_21345_.m_25352_(0, (Goal)new IntroGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AlwaysWatchTargetGoal());
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 160.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOULD_DELETE_ITSELF, (Object)false);
        this.f_19804_.m_135372_(NEARBY_ILLAGERS, (Object)false);
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(SHOW_ARMS, (Object)false);
        this.f_19804_.m_135372_(SHOW_VILLAGER, (Object)false);
        this.f_19804_.m_135372_(VILLAGER_FACE, (Object)0);
        this.f_19804_.m_135372_(SCYTHE, (Object)false);
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
        if (this.isActive()) {
            p_37870_.m_128379_("active", true);
        }
    }

    public void m_7378_(CompoundTag p_37862_) {
        super.m_7378_(p_37862_);
        this.setActive(p_37862_.m_128471_("active"));
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        List ragnolist;
        RagnoEntity ragno;
        List list = this.f_19853_.m_6443_(Raider.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_37886_() && !(predicate instanceof IllagerBoss));
        if (((Boolean)IllageAndSpillageConfig.freakager_forcefield.get()).booleanValue() && this.m_37886_()) {
            if (!this.f_19853_.f_46443_) {
                this.setIllagersNearby(!list.isEmpty());
            }
            if (!list.isEmpty()) {
                this.m_6710_(null);
            }
        }
        if (this.m_37886_()) {
            if (this.m_37885_() != null && this.m_37885_().m_37771_() == 7 && this.shouldRemoveItself() && ((Boolean)IllageAndSpillageConfig.freakager_onlyOneAllowed.get()).booleanValue()) {
                this.m_37885_().m_37740_((Raider)this, true);
                if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            if (this.m_37885_() != null) {
                this.m_37885_().m_37776_();
            }
        }
        if (this.introTicks > 0) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.areIllagersNearby()) {
            this.stopAttackersFromAttacking();
        }
        super.m_8119_();
        if (!this.isActive()) {
            if (this.introTicks > 0) {
                ++this.introTicks;
                this.m_146922_(this.m_6080_());
                this.f_20883_ = this.m_146908_();
            }
            if (this.introTicks == 21) {
                this.setAnimationState(1);
            }
            if (this.introTicks - 20 == 5) {
                if (!this.f_19853_.f_46443_) {
                    this.setShowVillager(true);
                }
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_CYMBAL.get(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERPANIC.get(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_SHIVER.get(), 1.0f, 1.0f);
            }
            if (this.introTicks > 32 && (this.introTicks - 32) % 5 == 0 && this.introTicks - 32 < 32) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERPANIC.get(), 1.0f, 1.0f);
            }
            if (this.introTicks - 20 == 34) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 1.0f, 1.0f);
            }
            if (this.introTicks - 20 == 36) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERPANIC.get(), 1.0f, 1.2f);
                this.m_8061_(EquipmentSlot.OFFHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)PotionRegisterer.MUTATION.get())));
            }
            if (this.introTicks - 20 == 44) {
                if (!this.f_19853_.f_46443_) {
                    this.setVillagerFace(1);
                }
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_FORCEPOTION.get(), 1.0f, 1.0f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERPANIC.get(), 1.0f, 1.3f);
                this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
            if (this.introTicks - 20 == 52 || this.introTicks - 20 == 58 || this.introTicks - 20 == 65) {
                this.m_5496_(SoundEvents.f_12551_, 1.0f, 1.0f);
            }
            if (this.introTicks - 20 == 74 && !this.f_19853_.f_46443_) {
                this.setVillagerFace(2);
            }
            if (this.introTicks - 20 == 93) {
                if (!this.f_19853_.f_46443_) {
                    this.setVillagerFace(3);
                }
                this.m_5496_(SoundEvents.f_12508_, 1.0f, 1.0f);
            }
            if (this.introTicks - 20 == 104) {
                this.m_5496_(SoundEvents.f_12512_, 1.0f, 1.0f);
            }
            if (this.introTicks - 20 == 108) {
                if (!this.f_19853_.f_46443_) {
                    this.setVillagerFace(0);
                }
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_VILLAGERHISS.get(), 1.0f, 1.0f);
            }
            if (this.introTicks - 20 == 116 && !this.f_19853_.f_46443_) {
                this.setVillagerFace(4);
            }
            if (this.introTicks - 20 == 132) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SPAWN.get(), 1.0f, 1.0f);
            }
            if (this.introTicks - 20 == 158) {
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
                assert (lightning != null);
                lightning.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                lightning.m_20874_(true);
                this.m_5496_(SoundEvents.f_12089_, 3.0f, 1.0f);
                this.m_5496_(SoundEvents.f_12090_, 10000.0f, 1.0f);
                this.f_19853_.m_7967_((Entity)lightning);
                CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 50.0f, 0.2f, 0, 10);
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Explosion.BlockInteraction.NONE);
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Explosion.BlockInteraction.NONE);
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Explosion.BlockInteraction.NONE);
                }
                ragno = (RagnoEntity)((EntityType)ModEntityTypes.Ragno.get()).m_20615_(this.f_19853_);
                assert (ragno != null);
                ragno.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                ragno.m_20334_(0.0, 0.6, 0.0);
                ragno.m_6710_(this.m_5448_());
                ragno.setOwner((Mob)this);
                if (this.m_5448_() != null) {
                    ragno.m_21391_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                this.ragno = ragno;
                this.f_19853_.m_7967_((Entity)ragno);
                if (!this.f_19853_.f_46443_) {
                    this.m_20329_((Entity)ragno);
                }
                ragno.playIntro();
                this.makeRagnoParticles((Entity)ragno);
                ragno.m_37897_(true);
                if (this.m_5647_() != null) {
                    this.f_19853_.m_6188_().m_6546_(ragno.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                }
                this.setAnimationState(0);
                if (!this.f_19853_.f_46443_) {
                    this.setShowVillager(false);
                }
            }
            if (this.introTicks - 158 == 50) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_LAUGH.get(), 2.0f, 1.0f);
                this.setAnimationState(2);
            }
            if (this.introTicks - 208 == 50) {
                this.setActive(true);
                this.setAnimationState(0);
                if (!this.f_19853_.f_46443_) {
                    this.setShowArms(false);
                }
            }
            if (this.introTicks - 20 == 5 && !this.f_19853_.f_46443_) {
                this.setShowVillager(true);
            }
        }
        if (this.attackType > 0) {
            ++this.attackTicks;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.attackType < 1) {
            if (this.bombsCooldown > 0) {
                --this.bombsCooldown;
            }
            if (this.axesCooldown > 0) {
                --this.axesCooldown;
            }
            if (this.potionsCooldown > 0) {
                --this.potionsCooldown;
            }
            if (this.scytheCooldown > 0) {
                --this.scytheCooldown;
            }
            if (this.trickOrTreatCooldown > 0) {
                --this.trickOrTreatCooldown;
            }
        }
        if (!this.m_20159_() && !(ragnolist = this.f_19853_.m_6443_(RagnoEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this && predicate.m_6084_())).isEmpty()) {
            ragno = (RagnoEntity)ragnolist.get(0);
            this.m_21573_().m_5624_((Entity)ragno, 2.0);
            if (this.m_20280_((Entity)ragno) < 9.0 && !this.f_19853_.f_46443_) {
                this.m_20329_((Entity)ragno);
            }
        }
        this.updateTreatList();
        this.distractAttackers();
        if (this.m_6084_()) {
            LivingEntity entity;
            double motionZ;
            double motionY;
            double motionX;
            float power;
            double d;
            double z;
            double y;
            AxeEntity projectile;
            if (this.attackType == this.BOMBS_ATTACK && this.attackTicks == 20) {
                double throwSpeed = 0.7;
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_CYMBAL.get(), 1.0f, 1.0f);
                for (int i = 0; i < 4; ++i) {
                    PathfinderMob s1;
                    if (this.m_21223_() < this.m_21233_() / 2.0f) {
                        s1 = (SkullBombEntity)((EntityType)ModEntityTypes.SkullBomb.get()).m_20615_(this.f_19853_);
                        assert (s1 != null);
                        s1.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                        s1.setOwner((LivingEntity)this);
                        if (i == 0) {
                            s1.m_20334_(-throwSpeed, 0.5, -throwSpeed);
                        } else if (i == 1) {
                            s1.m_20334_(-throwSpeed, 0.5, throwSpeed);
                        } else if (i == 2) {
                            s1.m_20334_(throwSpeed, 0.5, -throwSpeed);
                        } else {
                            s1.m_20334_(throwSpeed, 0.53, throwSpeed);
                        }
                        this.f_19853_.m_7967_((Entity)s1);
                        continue;
                    }
                    s1 = (PumpkinBombEntity)((EntityType)ModEntityTypes.PumpkinBomb.get()).m_20615_(this.f_19853_);
                    assert (s1 != null);
                    s1.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                    s1.setOwner((LivingEntity)this);
                    s1.m_6710_(this.m_5448_());
                    if (i == 0) {
                        s1.m_20334_(-throwSpeed, 0.3, -throwSpeed);
                    } else if (i == 1) {
                        s1.m_20334_(-throwSpeed, 0.3, throwSpeed);
                    } else if (i == 2) {
                        s1.m_20334_(throwSpeed, 0.3, -throwSpeed);
                    } else {
                        s1.m_20334_(throwSpeed, 0.3, throwSpeed);
                    }
                    if (this.m_5647_() != null) {
                        this.f_19853_.m_6188_().m_6546_(s1.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                    }
                    this.f_19853_.m_7967_((Entity)s1);
                }
            }
            if (this.attackType == this.AXES_ATTACK) {
                LivingEntity entity2 = this.m_5448_();
                if (this.attackTicks % 28 == 0) {
                    this.setAnimationState(0);
                    this.setAnimationState(4);
                }
                if (this.attackTicks % 28 == 2) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 2.0f, 1.0f);
                }
                if (entity2 != null && this.attackTicks % 28 == 6) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (!this.f_19853_.f_46443_) {
                        projectile = (AxeEntity)((EntityType)ModEntityTypes.Axe.get()).m_20615_(this.f_19853_);
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        double x = projectile.m_20185_() - entity2.m_20185_();
                        y = projectile.m_20186_() - (entity2.m_20186_() + 1.5);
                        z = projectile.m_20189_() - entity2.m_20189_();
                        d = Math.sqrt(x * x + y * y + z * z);
                        power = 3.5f;
                        motionX = -(x / d * (double)power * 0.2);
                        motionY = -(y / d * (double)power * 0.2);
                        motionZ = -(z / d * (double)power * 0.2);
                        projectile.setAcceleration(motionX, motionY, motionZ);
                        projectile.setShooter((Mob)this);
                        this.f_19853_.m_7967_((Entity)projectile);
                    }
                }
                if (this.attackTicks % 28 == 14) {
                    this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
                    this.m_21559_(true);
                }
                if (this.attackTicks % 28 == 16) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 2.0f, 1.0f);
                }
                if (entity2 != null && this.attackTicks % 28 == 22) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (!this.f_19853_.f_46443_) {
                        projectile = (AxeEntity)((EntityType)ModEntityTypes.Axe.get()).m_20615_(this.f_19853_);
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        double x = projectile.m_20185_() - entity2.m_20185_();
                        y = projectile.m_20186_() - entity2.m_20186_();
                        z = projectile.m_20189_() - entity2.m_20189_();
                        d = Math.sqrt(x * x + y * y + z * z);
                        power = 3.5f;
                        motionX = -(x / d * (double)power * 0.2);
                        motionY = -(y / d * (double)power * 0.2);
                        motionZ = -(z / d * (double)power * 0.2);
                        projectile.setAcceleration(motionX, motionY, motionZ);
                        projectile.setShooter((Mob)this);
                        this.f_19853_.m_7967_((Entity)projectile);
                    }
                }
                if (this.attackTicks % 28 == 27) {
                    this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
                    this.m_21559_(false);
                }
            }
            if (this.attackType == this.FAST_AXES_ATTACK) {
                LivingEntity entity3 = this.m_5448_();
                if (this.attackTicks % 12 == 0) {
                    this.setAnimationState(0);
                    this.setAnimationState(5);
                }
                if (this.attackTicks % 12 == 1) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 2.0f, 1.0f);
                }
                if (entity3 != null && this.attackTicks % 12 == 3) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (!this.f_19853_.f_46443_) {
                        projectile = (AxeEntity)((EntityType)ModEntityTypes.Axe.get()).m_20615_(this.f_19853_);
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        double x = projectile.m_20185_() - entity3.m_20185_();
                        y = projectile.m_20186_() - entity3.m_20186_();
                        z = projectile.m_20189_() - entity3.m_20189_();
                        d = Math.sqrt(x * x + y * y + z * z);
                        power = 3.5f;
                        motionX = -(x / d * (double)power * 0.2);
                        motionY = -(y / d * (double)power * 0.2);
                        motionZ = -(z / d * (double)power * 0.2);
                        projectile.setAcceleration(motionX, motionY, motionZ);
                        projectile.setShooter((Mob)this);
                        this.f_19853_.m_7967_((Entity)projectile);
                    }
                }
                if (this.attackTicks % 12 == 6) {
                    this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
                    this.m_21559_(true);
                }
                if (this.attackTicks % 12 == 7) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 2.0f, 1.0f);
                }
                if (entity3 != null && this.attackTicks % 12 == 10) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    if (!this.f_19853_.f_46443_) {
                        projectile = (AxeEntity)((EntityType)ModEntityTypes.Axe.get()).m_20615_(this.f_19853_);
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        double x = projectile.m_20185_() - entity3.m_20185_();
                        y = projectile.m_20186_() - entity3.m_20186_();
                        z = projectile.m_20189_() - entity3.m_20189_();
                        d = Math.sqrt(x * x + y * y + z * z);
                        power = 3.5f;
                        motionX = -(x / d * (double)power * 0.2);
                        motionY = -(y / d * (double)power * 0.2);
                        motionZ = -(z / d * (double)power * 0.2);
                        projectile.setAcceleration(motionX, motionY, motionZ);
                        projectile.setShooter((Mob)this);
                        this.f_19853_.m_7967_((Entity)projectile);
                    }
                }
                if (this.attackTicks % 12 == 11) {
                    this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42386_.m_7968_());
                    this.m_21559_(false);
                }
            }
            if (this.attackType == this.POTIONS_ATTACK) {
                if (this.attackTicks == 10) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_SPIN.get(), 2.0f, 1.0f);
                    this.potionThrowDistance = 0.0;
                }
                if (this.attackTicks >= 10 && this.attackTicks <= 50) {
                    this.makePotionParticles();
                }
                if (this.attackTicks >= 20 && this.attackTicks <= 50) {
                    this.potionThrowDistance += 0.02;
                    for (int i = 0; i < 2; ++i) {
                        if (this.f_19853_.f_46443_) continue;
                        DarkPotionEntity potionentity = (DarkPotionEntity)((EntityType)ModEntityTypes.DarkPotion.get()).m_20615_(this.f_19853_);
                        assert (potionentity != null);
                        potionentity.m_6034_(this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_());
                        potionentity.m_5602_((Entity)this);
                        potionentity.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)((Potion)PotionRegisterer.MUTATION.get())));
                        potionentity.m_146926_(-20.0f);
                        potionentity.m_20334_((-2.0 + (this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_())) * (this.potionThrowDistance / 4.0), 1.0, (-2.0 + (this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_())) * (this.potionThrowDistance / 4.0));
                        this.f_19853_.m_7967_((Entity)potionentity);
                    }
                }
            }
            if (this.attackType == this.SCYTHE_ATTACK && (entity = this.m_5448_()) != null) {
                if (this.attackTicks == 14) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_THROW.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 16) {
                    this.waitingForScythe = true;
                    if (!this.f_19853_.f_46443_) {
                        this.setShowScythe(false);
                    }
                    ScytheEntity scythe = (ScytheEntity)((EntityType)ModEntityTypes.Scythe.get()).m_20615_(this.f_19853_);
                    assert (scythe != null);
                    scythe.m_6034_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
                    double x = scythe.m_20185_() - entity.m_20185_();
                    y = scythe.m_20186_() - entity.m_20186_();
                    z = scythe.m_20189_() - entity.m_20189_();
                    d = Math.sqrt(x * x + y * y + z * z);
                    power = 3.0f;
                    motionX = -(x / d * (double)power * 0.2);
                    motionY = -(y / d * (double)power * 0.2);
                    motionZ = -(z / d * (double)power * 0.2);
                    scythe.setAcceleration(motionX, motionY, motionZ);
                    scythe.halfHP = this.m_21223_() < this.m_21233_() / 2.0f;
                    scythe.setGoFor(entity);
                    scythe.setShooter((LivingEntity)this);
                    this.f_19853_.m_7967_((Entity)scythe);
                }
            }
            if (this.attackType == this.TRICKORTREAT_ATTACK && this.attackTicks == 21) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_CYMBAL.get(), 2.0f, 1.0f);
                int amount = 7;
                for (int i = 0; i < amount; ++i) {
                    TrickOrTreatEntity treat = (TrickOrTreatEntity)((EntityType)ModEntityTypes.TrickOrTreat.get()).m_20615_(this.f_19853_);
                    assert (treat != null);
                    treat.circleTime = i * 20;
                    treat.bounceTime = i;
                    treat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    treat.setOwner((LivingEntity)this);
                    treat.setTreat(this.f_19796_.m_188503_(5) + 1);
                    if (this.m_5647_() != null) {
                        this.f_19853_.m_6188_().m_6546_(treat.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                    }
                    this.circleTreat((Entity)treat, i, amount);
                    this.f_19853_.m_7967_((Entity)treat);
                    this.treats.add(treat);
                }
            }
        }
    }

    public void stopAttackersFromAttacking() {
        List list = this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        for (Mob attacker : list) {
            if (attacker.m_21188_() == this) {
                attacker.m_6703_(null);
            }
            if (attacker.m_5448_() != this) continue;
            attacker.m_6710_(null);
        }
    }

    public boolean m_20329_(Entity p_20330_) {
        if (p_20330_ instanceof RagnoEntity || p_20330_ instanceof CrocofangEntity || p_20330_ instanceof Ravager) {
            return super.m_20329_(p_20330_);
        }
        return false;
    }

    public void m_6667_(DamageSource p_37847_) {
        Entity entity;
        if (!this.treats.isEmpty()) {
            for (TrickOrTreatEntity trickOrTreatEntity : this.treats) {
                trickOrTreatEntity.m_6074_();
            }
        }
        if ((entity = this.m_20202_()) instanceof RagnoEntity) {
            RagnoEntity ragno = (RagnoEntity)entity;
            ItemEntity itemEntity = (ItemEntity)EntityType.f_20461_.m_20615_(this.f_19853_);
            assert (itemEntity != null);
            itemEntity.m_32045_(((Item)ItemRegisterer.BAG_OF_HORRORS.get()).m_7968_());
            itemEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            itemEntity.m_20334_(0.0, 0.6, 0.0);
            itemEntity.m_32062_();
            itemEntity.m_149678_();
            itemEntity.f_19794_ = true;
            this.f_19853_.m_7967_((Entity)itemEntity);
            ragno.item = itemEntity;
        }
        super.m_6667_(p_37847_);
    }

    private void circleTreat(Entity entity, int number, int amount) {
        float TAU = (float)Math.PI * 2;
        float velocity = 0.5f;
        float yaw = (float)number * ((float)Math.PI * 2 / (float)amount);
        float vy = 0.3f;
        float vx = 0.5f * Mth.m_14089_((float)yaw);
        float vz = 0.5f * Mth.m_14031_((float)yaw);
        entity.m_20334_((double)vx, (double)vy, (double)vz);
    }

    public void updateTreatList() {
        if (!this.treats.isEmpty()) {
            for (int i = 0; i < this.treats.size(); ++i) {
                TrickOrTreatEntity clone = this.treats.get(i);
                if (clone.m_6084_()) continue;
                this.treats.remove(i);
                --i;
            }
        }
    }

    public void distractAttackers() {
        if (!this.treats.isEmpty()) {
            List list = this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
            for (Mob attacker : list) {
                TrickOrTreatEntity treat = this.treats.get(this.f_19796_.m_188503_(this.treats.size()));
                if (attacker.m_21188_() == this) {
                    attacker.m_6703_((LivingEntity)treat);
                }
                if (attacker.m_5448_() == this) {
                    attacker.m_6710_((LivingEntity)treat);
                }
                if (!(attacker instanceof Warden)) {
                    try {
                        if (attacker.m_6274_() == null || !attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_) || !attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() || attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() != this) continue;
                        attacker.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)treat.m_20148_(), 600L);
                        attacker.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)treat, 600L);
                    }
                    catch (NullPointerException nullPointerException) {}
                    continue;
                }
                Warden warden = (Warden)attacker;
                if (warden.m_5448_() != this) continue;
                warden.m_219387_((Entity)treat, AngerLevel.ANGRY.m_219226_() + 100, false);
                warden.m_219459_((LivingEntity)treat);
            }
        }
    }

    public void makeRagnoParticles(Entity caught) {
        if (!this.f_19853_.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_6907_()) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 75; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123755_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 50; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 5; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123812_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public void makePotionParticles() {
        if (!this.f_19853_.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_6907_()) {
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 1; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123766_, false, new Vec3(this.m_20208_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 0.8, this.m_20187_() - (-0.5 + this.f_19796_.m_188500_()) * 0.4, this.m_20262_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 0.8), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public int getVillagerFace() {
        return (Integer)this.f_19804_.m_135370_(VILLAGER_FACE);
    }

    public void setVillagerFace(int face) {
        this.f_19804_.m_135381_(VILLAGER_FACE, (Object)face);
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (!this.isActive() && p_37849_ != DamageSource.f_19317_) {
            p_37850_ = 0.0f;
            if (p_37849_.m_7639_() != null && this.introTicks == 0 && !this.areIllagersNearby()) {
                this.introTicks = 1;
                if (this.m_37886_() && this.m_37885_() != null) {
                    this.m_37885_().f_37673_ = 0L;
                }
            }
        }
        if (this.areIllagersNearby() && p_37849_ != DamageSource.f_19317_) {
            return false;
        }
        if (p_37849_ == DamageSource.f_19310_) {
            return false;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_LAUGH.get();
    }

    protected SoundEvent m_7515_() {
        if (this.introTicks > 1) {
            return null;
        }
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_DEATH.get();
    }

    public boolean m_7490_() {
        return false;
    }

    public void setAnimationState(int input) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)input);
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (input == "intro") {
            return this.introAnimationState;
        }
        if (input == "laugh") {
            return this.laughAnimationState;
        }
        if (input == "bombs") {
            return this.bombsAnimationState;
        }
        if (input == "axes") {
            return this.axesAnimationState;
        }
        if (input == "fastaxes") {
            return this.fastaxesAnimationState;
        }
        if (input == "potions") {
            return this.potionsAnimationState;
        }
        if (input == "scythe") {
            return this.scytheAnimationState;
        }
        if (input == "trickortreat") {
            return this.trickortreatAnimationState;
        }
        return new AnimationState();
    }

    protected void m_6668_(DamageSource p_21192_) {
        if (!(this.m_20202_() instanceof RagnoEntity)) {
            super.m_6668_(p_21192_);
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.introAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.laughAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.bombsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.axesAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.fastaxesAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.potionsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.scytheAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.trickortreatAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.introAnimationState.m_216973_();
        this.laughAnimationState.m_216973_();
        this.bombsAnimationState.m_216973_();
        this.axesAnimationState.m_216973_();
        this.fastaxesAnimationState.m_216973_();
        this.potionsAnimationState.m_216973_();
        this.scytheAnimationState.m_216973_();
        this.trickortreatAnimationState.m_216973_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        RandomSource randomsource = p_213386_1_.m_213780_();
        if (p_213386_3_ == MobSpawnType.EVENT) {
            this.setShouldDeleteItself(true);
        }
        this.m_213945_(randomsource, p_213386_2_);
        this.m_213946_(randomsource, p_213386_2_);
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_180481_1_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public boolean shouldRemoveItself() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_DELETE_ITSELF);
    }

    public void setShouldDeleteItself(boolean shouldDelete) {
        this.f_19804_.m_135381_(SHOULD_DELETE_ITSELF, (Object)shouldDelete);
    }

    public boolean areIllagersNearby() {
        return (Boolean)this.f_19804_.m_135370_(NEARBY_ILLAGERS);
    }

    public void setIllagersNearby(boolean illagersNearby) {
        this.f_19804_.m_135381_(NEARBY_ILLAGERS, (Object)illagersNearby);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public boolean shouldShowArms() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_ARMS);
    }

    public void setShowArms(boolean showArms) {
        this.f_19804_.m_135381_(SHOW_ARMS, (Object)showArms);
    }

    public boolean shouldShowVillager() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_VILLAGER);
    }

    public void setShowVillager(boolean showVillager) {
        this.f_19804_.m_135381_(SHOW_VILLAGER, (Object)showVillager);
    }

    public boolean shouldShowScythe() {
        return (Boolean)this.f_19804_.m_135370_(SCYTHE);
    }

    public void setShowScythe(boolean scythe) {
        this.f_19804_.m_135381_(SCYTHE, (Object)scythe);
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.attackType == 0 && !this.areIllagersNearby() && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.isActive() && this.attackCooldown < 1;
    }

    class TrickOrTreatGoal
    extends Goal {
        public TrickOrTreatGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.trickOrTreatCooldown < 1 && FreakagerEntity.this.m_21223_() < FreakagerEntity.this.m_21233_();
        }

        public void m_8056_() {
            FreakagerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_TRICKORTREAT.get(), 2.0f, 1.0f);
            FreakagerEntity.this.setAnimationState(8);
            FreakagerEntity.this.attackType = FreakagerEntity.this.TRICKORTREAT_ATTACK;
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 30;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.trickOrTreatCooldown = 900;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class ScytheGoal
    extends Goal {
        public ScytheGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.scytheCooldown < 1;
        }

        public void m_8056_() {
            FreakagerEntity.this.setAnimationState(7);
            FreakagerEntity.this.attackType = FreakagerEntity.this.SCYTHE_ATTACK;
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowScythe(true);
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 24 || FreakagerEntity.this.waitingForScythe;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.scytheCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class PotionsGoal
    extends Goal {
        public PotionsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.potionsCooldown < 1;
        }

        public void m_8056_() {
            FreakagerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_REVEAL.get(), 2.0f, 1.0f);
            FreakagerEntity.this.setAnimationState(6);
            FreakagerEntity.this.attackType = FreakagerEntity.this.POTIONS_ATTACK;
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 60;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.potionsCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class FastAxesGoal
    extends Goal {
        public FastAxesGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.axesCooldown < 1 && FreakagerEntity.this.m_21223_() < FreakagerEntity.this.m_21233_() / 2.0f;
        }

        public void m_8056_() {
            FreakagerEntity.this.setAnimationState(5);
            FreakagerEntity.this.attackType = FreakagerEntity.this.FAST_AXES_ATTACK;
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 60;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.axesCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class AxesGoal
    extends Goal {
        public AxesGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.axesCooldown < 1 && FreakagerEntity.this.m_21223_() >= FreakagerEntity.this.m_21233_() / 2.0f;
        }

        public void m_8056_() {
            FreakagerEntity.this.setAnimationState(4);
            FreakagerEntity.this.attackType = FreakagerEntity.this.AXES_ATTACK;
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 82;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.axesCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class ThrowBombsGoal
    extends Goal {
        public ThrowBombsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.doesAttackMeetNormalRequirements() && FreakagerEntity.this.f_19796_.m_188503_(16) == 0 && FreakagerEntity.this.bombsCooldown < 1;
        }

        public void m_8056_() {
            FreakagerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_PUMPKINBOMBS.get(), 2.0f, 1.0f);
            FreakagerEntity.this.setAnimationState(3);
            FreakagerEntity.this.attackType = FreakagerEntity.this.BOMBS_ATTACK;
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.attackTicks <= 30;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            FreakagerEntity.this.attackTicks = 0;
            FreakagerEntity.this.attackType = 0;
            FreakagerEntity.this.setAnimationState(0);
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(false);
            }
            FreakagerEntity.this.bombsCooldown = 200;
            FreakagerEntity.this.attackCooldown = 100;
        }
    }

    class IntroGoal
    extends Goal {
        public IntroGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return (Integer)FreakagerEntity.this.f_19804_.m_135370_(ANIMATION_STATE) == 1;
        }

        public void m_8056_() {
            FreakagerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_REVEAL.get(), 1.0f, 1.0f);
            if (!FreakagerEntity.this.f_19853_.f_46443_) {
                FreakagerEntity.this.setShowArms(true);
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null && FreakagerEntity.this.introTicks < 40) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }

        public boolean m_8045_() {
            return (Integer)FreakagerEntity.this.f_19804_.m_135370_(ANIMATION_STATE) == 1;
        }
    }

    class AlwaysWatchTargetGoal
    extends Goal {
        public AlwaysWatchTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return FreakagerEntity.this.m_5448_() != null && (FreakagerEntity.this.introTicks < 40 || FreakagerEntity.this.isActive());
        }

        public boolean m_8045_() {
            return FreakagerEntity.this.m_5448_() != null && (FreakagerEntity.this.introTicks < 40 || FreakagerEntity.this.isActive());
        }

        public void m_8037_() {
            FreakagerEntity.this.m_21573_().m_26573_();
            if (FreakagerEntity.this.m_5448_() != null) {
                FreakagerEntity.this.m_21563_().m_24960_((Entity)FreakagerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            FreakagerEntity.this.f_21344_.m_26573_();
        }
    }
}

