/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerBoss;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class DevastatorEntity
extends Raider
implements IllagerBoss {
    int frame;
    int deflectTime;

    public DevastatorEntity(EntityType<? extends Raider> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 36.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 48.0f));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, Objects::nonNull));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, 10, false, false, Objects::nonNull));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 10, false, false, Objects::nonNull));
    }

    public boolean m_6779_(LivingEntity p_186270_) {
        return p_186270_ instanceof AbstractVillager && p_186270_.m_6162_() ? false : super.m_6779_(p_186270_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22282_, 3.5).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected boolean m_6129_() {
        return false;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        if (p_147187_ >= 4.0f) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_DEVASTATOR_LAND.get(), 6.0f, 1.0f);
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 200.0f, 0.3f, 0, 5);
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 400.0f, 0.05f, 0, 25);
        }
        return false;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return null;
    }

    public float getStepHeight() {
        return 3.0f;
    }

    public boolean m_142582_(Entity p_147185_) {
        if (p_147185_.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(p_147185_.m_20185_(), p_147185_.m_20188_(), p_147185_.m_20189_());
        return !(vec31.m_82554_(vec3) > 128.0);
    }

    public boolean isInAttackSight(Entity p_147185_) {
        if (p_147185_.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(p_147185_.m_20185_(), p_147185_.m_20188_(), p_147185_.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.frame;
        float moveX = (float)(this.m_20185_() - this.f_19854_);
        float moveZ = (float)(this.m_20189_() - this.f_19856_);
        float speed = Mth.m_14116_((float)(moveX * moveX + moveZ * moveZ));
        if (this.frame % 20 == 10 && (double)speed > 0.03) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_DEVASTATOR_STEP.get(), 4.0f, 1.0f);
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 100.0f, 0.2f, 0, 5);
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 200.0f, 0.03f, 0, 15);
            List list = this.f_19853_.m_45976_(LivingEntity.class, new AABB(this.m_20185_() - 30.0, this.m_20186_() - 10.0, this.m_20189_() - 30.0, this.m_20185_() + 30.0, this.m_20186_() + 10.0, this.m_20189_() + 30.0));
            for (LivingEntity entity : list) {
                if (!entity.m_6084_() || !entity.m_20096_() || !((double)entity.m_20205_() < 3.5) || !((double)entity.m_20206_() < 4.5)) continue;
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.4, 0.0));
            }
            List scareList = this.f_19853_.m_45976_(Villager.class, new AABB(this.m_20185_() - 30.0, this.m_20186_() - 10.0, this.m_20189_() - 30.0, this.m_20185_() + 30.0, this.m_20186_() + 10.0, this.m_20189_() + 30.0));
            for (Villager villager : scareList) {
                if (this.f_19796_.m_188503_(2) != 0 || !villager.m_6084_()) continue;
                villager.m_6469_(DamageSource.f_19318_, 0.0f);
            }
        }
        if (this.deflectTime > 0) {
            --this.deflectTime;
        }
    }

    public int getFrame() {
        return this.frame;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 9) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_DEVASTATOR_DEATH.get(), 4.0f, 1.0f);
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 200.0f, 0.03f, 80, 40);
        }
        if (this.f_20919_ == 10) {
            CameraShakeEntity.cameraShake(this.f_19853_, this.m_20182_(), 200.0f, 0.05f, 80, 40);
        }
        if (this.f_20919_ > 140 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_7334_(Entity p_21294_) {
    }

    protected void m_7324_(Entity p_20971_) {
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (p_37849_ != DamageSource.f_19317_) {
            p_37850_ /= 10.0f;
        }
        if (p_37849_.m_19360_()) {
            if (this.deflectTime < 1) {
                this.m_5496_(SoundEvents.f_11666_, 1.0f, 2.0f);
                this.deflectTime = 10;
            }
            return false;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }
}

