/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class AbsorberEntity
extends AbstractIllager
implements ICanBeAnimated {
    private static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.m_135353_(AbsorberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(AbsorberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public AbsorberEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_20916_ >= 3) {
            this.f_20916_ = 2;
        }
        if (this.m_6084_() && this.getAttackAnimationTick() > 0) {
            if (!this.f_19853_.f_46443_) {
                this.setAttackAnimationTick(this.getAttackAnimationTick() - 1);
            }
            this.m_146922_(this.m_6080_());
            this.f_20883_ = this.m_146908_();
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
            }
            if (this.getAttackAnimationTick() == 10) {
                this.m_5496_(SoundEvents.f_11913_, 2.0f, 1.0f);
                float radius2 = 1.5f;
                double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                double y = this.m_20186_() + 1.0 + (double)radius2 * Math.sin((double)(-this.m_146909_()) * Math.PI / 180.0);
                double z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                List list = this.f_19853_.m_45976_(LivingEntity.class, new AABB(x - 2.0, this.m_20186_(), z - 2.0, x + 2.0, this.m_20186_() + 2.0, z + 2.0));
                for (LivingEntity caught : list) {
                    if (caught == this || !caught.m_6084_()) continue;
                    caught.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22115_());
                    caught.m_6001_(caught.m_20184_().f_82479_, caught.m_20184_().f_82480_ + 0.3, caught.m_20184_().f_82481_);
                    caught.m_20256_(caught.m_20184_().m_82520_(0.0, 0.3, 0.0));
                    EntityUtil.disableShield(caught, 200);
                }
            }
        }
    }

    public int getAttackAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackAnimationTick(int attackAnimationTick) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)attackAnimationTick);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public void m_6667_(DamageSource p_37847_) {
        this.setAnimationState(2);
        super.m_6667_(p_37847_);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 30) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ABSORBER_COLLAPSE.get(), 1.0f, 1.0f);
        }
        if (this.f_20919_ == 90 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (!((Boolean)IllageAndSpillageConfig.absorber_damageMode.get()).booleanValue()) {
            if (p_37849_ != DamageSource.f_19317_) {
                p_37850_ = 1.0f;
            }
        } else if (p_37849_ != DamageSource.f_19317_ && p_37850_ > 1.0f) {
            p_37850_ = 1.0f;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 2.5625f;
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ABSORBER_AMBIENT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ABSORBER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ABSORBER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ABSORBER_DEATH.get();
    }

    public float m_6100_() {
        if (this.m_21224_()) {
            return 1.0f;
        }
        return super.m_6100_();
    }

    public boolean m_7327_(Entity p_21372_) {
        if (this.getAttackAnimationTick() < 1) {
            this.attackAnimationState.m_216973_();
            this.setAnimationState(0);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ABSORBER_ATTACK.get(), 1.0f, 1.0f);
            if (!this.f_19853_.f_46443_) {
                this.setAttackAnimationTick(30);
            }
            this.setAnimationState(1);
        }
        return false;
    }

    public void setAnimationState(int input) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)input);
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (input == "attack") {
            return this.attackAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216973_();
                    this.deathAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public boolean m_7490_() {
        return false;
    }

    class AttackGoal
    extends Goal {
        public boolean m_8036_() {
            return AbsorberEntity.this.getAttackAnimationTick() > 0;
        }

        public boolean m_8045_() {
            return AbsorberEntity.this.getAttackAnimationTick() > 0;
        }

        public AttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public void m_8037_() {
            AbsorberEntity.this.m_21573_().m_26573_();
            AbsorberEntity.this.f_21344_.m_26573_();
        }
    }
}

