/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class IllageAndSpillageConfig {
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> igniter_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> twittollager_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> crocofang_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> absorber_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> preserver_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> magispeller_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> spiritcaller_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> freakager_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> bossrandomizer_raidcount;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> bossrandomizer_bosstypes;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> bossrandomizer_finalbosstypes;
    public static ForgeConfigSpec.BooleanValue bossrandomizer_onlyOneAllowed;
    public static ForgeConfigSpec.BooleanValue bossrandomizer_seasonalBosses;
    public static ForgeConfigSpec.BooleanValue bossrandomizer_broadcastBossSpawn;
    public static ForgeConfigSpec.BooleanValue magispeller_onlyOneAllowed;
    public static ForgeConfigSpec.BooleanValue magispeller_forcefield;
    public static ForgeConfigSpec.BooleanValue spiritcaller_onlyOneAllowed;
    public static ForgeConfigSpec.BooleanValue spiritcaller_forcefield;
    public static ForgeConfigSpec.BooleanValue freakager_onlyOneAllowed;
    public static ForgeConfigSpec.BooleanValue freakager_forcefield;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> spiritcaller_stealableMobs;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> spiritcaller_wontAttack;
    public static ForgeConfigSpec.BooleanValue igniter_canBurnBlocks;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> crocofang_rideableMobs;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> devastator_cantBreak;
    public static ForgeConfigSpec.IntValue ghostblock_repairTime;
    public static ForgeConfigSpec.BooleanValue devastator_ghostBlocks;
    public static ForgeConfigSpec.BooleanValue cameraShakesAllowed;
    public static ForgeConfigSpec.BooleanValue arachnophobeMode;
    public static ForgeConfigSpec.BooleanValue absorber_damageMode;
    public static ForgeConfigSpec.BooleanValue magispeller_balloonAllowed;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> preserver_cannotProtect;
    public static ForgeConfigSpec.IntValue spellboundbook_rechargeTime;
    public static ForgeConfigSpec.IntValue spellboundbook_effectTime;
    public static ForgeConfigSpec.BooleanValue magispeller_distractEnemies;
    public static ForgeConfigSpec.IntValue ragno_attackTimes;

    public static void init(ForgeConfigSpec.Builder common, ForgeConfigSpec.Builder client) {
        client.push("Client Settings");
        cameraShakesAllowed = client.comment("Setting this to false will disable camera shakes.").define("cameraShakesAllowed", true);
        arachnophobeMode = client.comment("Setting this to true will turn on Arachnophobe-Safe Mode, Ragno will become a horrifying monstrosity in a different way").define("arachnophobeMode", false);
        client.pop();
        common.push("Raid settings");
        igniter_raidcount = common.comment(new String[]{"How many Igniters each wave", "Requires game restart", "Must have no more and no less than 8 integers"}).worldRestart().defineList("igniter_raidcount", Arrays.asList(0, 0, 1, 2, 0, 2, 1, 4), s -> s instanceof Integer);
        twittollager_raidcount = common.comment(new String[]{"How many Twittollagers each wave", "Requires game restart", "Must have no more and no less than 8 integers"}).worldRestart().defineList("twittollager_raidcount", Arrays.asList(0, 0, 0, 0, 1, 0, 2, 1), s -> s instanceof Integer);
        crocofang_raidcount = common.comment(new String[]{"How many Crocofangs each wave", "Requires game restart", "Must have no more and no less than 8 integers"}).worldRestart().defineList("crocofang_raidcount", Arrays.asList(0, 0, 1, 0, 1, 2, 1, 3), s -> s instanceof Integer);
        absorber_raidcount = common.comment(new String[]{"How many Absorbers each wave", "Requires game restart", "Must have no more and no less than 8 integers"}).worldRestart().defineList("absorber_raidcount", Arrays.asList(0, 0, 0, 0, 1, 0, 0, 2), s -> s instanceof Integer);
        preserver_raidcount = common.comment(new String[]{"How many Preservers each wave", "Requires game restart", "Must have no more and no less than 8 integers"}).worldRestart().defineList("preserver_raidcount", Arrays.asList(0, 0, 0, 1, 2, 0, 3, 4), s -> s instanceof Integer);
        magispeller_raidcount = common.comment(new String[]{"How many Magispellers each wave", "Requires game restart", "Must have no more and no less than 8 integers"}).worldRestart().defineList("magispeller_raidcount", Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0), s -> s instanceof Integer);
        magispeller_onlyOneAllowed = common.comment(new String[]{"Controls if Magispeller should despawn if it spawns in the 7th wave before the bonus wave.", "Overrides magispeller_raidcount", "Default = true"}).define("magispeller_onlyOneAllowed", true);
        magispeller_forcefield = common.comment(new String[]{"Should the Magispeller only be allowed to fight once all other raiders in the wave are killed?", "Default = true"}).define("magispeller_forcefield", true);
        spiritcaller_raidcount = common.comment(new String[]{"How many Spiritcallers each wave", "Requires game restart", "Must have no more and no less than 8 integers"}).worldRestart().defineList("spiritcaller_raidcount", Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0), s -> s instanceof Integer);
        spiritcaller_onlyOneAllowed = common.comment(new String[]{"Controls if Spiritcaller should despawn if it spawns in the 7th wave before the bonus wave.", "Overrides spiritcaller_raidcount", "Default = true"}).define("spiritcaller_onlyOneAllowed", true);
        spiritcaller_forcefield = common.comment(new String[]{"Should the Spiritcaller only be allowed to fight once all other raiders in the wave are killed?", "Default = true"}).define("spiritcaller_forcefield", true);
        freakager_raidcount = common.comment(new String[]{"How many Freakagers each wave", "Requires game restart", "Must have no more and no less than 8 integers"}).worldRestart().defineList("freakager_raidcount", Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0), s -> s instanceof Integer);
        freakager_onlyOneAllowed = common.comment(new String[]{"Controls if Freakager should despawn if it spawns in the 7th wave before the bonus wave.", "Overrides freakager_raidcount", "Default = true"}).define("freakager_onlyOneAllowed", true);
        freakager_forcefield = common.comment(new String[]{"Should the Freakager only be allowed to fight once all other raiders in the wave are killed?", "Default = true"}).define("freakager_forcefield", true);
        common.push("Boss Randomizer settings");
        bossrandomizer_raidcount = common.comment(new String[]{"How many Boss Randomizers each wave", "Requires game restart", "Must have no more and no less than 8 integers", "Note that Boss Randomizers on the final Raid wave will be considered the 'Final Boss'"}).worldRestart().defineList("bossrandomizer_raidcount", Arrays.asList(0, 0, 0, 0, 1, 0, 0, 1), s -> s instanceof Integer);
        bossrandomizer_bosstypes = common.comment(new String[]{"Mobs put in this list will be randomly selected by the Boss Randomizer.", "Format must be like 'examplemod:entity'. Example: \"minecraft:zombie\"", "You can use the /summon command to scroll through and find the IDs for mobs you want!", "Invalid entity registry names will spawn the boss randomizer itself as an illager. Same goes for if this list is empty", "Only entities extending the Abstract Raider class will actually join the Raid upon spawning", "Requires game restart"}).defineList("bossrandomizer_bosstypes", Arrays.asList("illageandspillage:spiritcaller", "illageandspillage:freakager"), String.class::isInstance);
        bossrandomizer_finalbosstypes = common.comment(new String[]{"Mobs put in this list will be randomly selected by the Final Boss Randomizer. Only insanely powerful mobs like the Magispeller should go here", "Format must be like 'examplemod:entity'. Example: \"minecraft:zombie\"", "You can use the /summon command to scroll through and find the IDs for mobs you want!", "Invalid entity registry names will spawn the boss randomizer itself as an illager. Same goes for if this list is empty", "Only entities extending the Abstract Raider class will actually join the Raid upon spawning", "Requires game restart"}).defineList("bossrandomizer_finalbosstypes", Arrays.asList("illageandspillage:magispeller"), String.class::isInstance);
        bossrandomizer_onlyOneAllowed = common.comment(new String[]{"Controls if the Boss Randomizer should despawn if it spawns in the 7th wave before the bonus wave.", "Overrides bossrandomizer_raidcount", "Default = true"}).define("bossrandomizer_onlyOneAllowed", true);
        bossrandomizer_seasonalBosses = common.comment(new String[]{"Should Boss Randomizer be allowed to spawn special bosses depending on the calendar date?", "Default = true"}).define("bossrandomizer_seasonalBosses", true);
        bossrandomizer_broadcastBossSpawn = common.comment(new String[]{"Should Boss Randomizer broadcast the spawning of a boss with a sound?", "Default = true"}).define("bossrandomizer_broadcastBossSpawn", true);
        common.pop();
        common.push("Spiritcaller settings");
        spiritcaller_stealableMobs = common.comment(new String[]{"Mobs put in this list have 'souls' the Spiritcaller can steal.", "Format must be like 'examplemod:entity'. Example: \"minecraft:zombie\"", "You can use the /summon command to scroll through and find the IDs for mobs you want!", "Requires game restart"}).defineList("spiritcaller_stealableMobs", Arrays.asList("minecraft:villager", "minecraft:wandering_trader", "minecraft:pig", "minecraft:cow", "minecraft:sheep", "minecraft:chicken", "minecraft:cat", "minecraft:zombie", "minecraft:husk", "minecraft:skeleton", "minecraft:stray", "minecraft:creeper", "minecraft:spider", "minecraft:enderman"), String.class::isInstance);
        spiritcaller_wontAttack = common.comment(new String[]{"Mobs put in this list won't be attacked by mobs attacking the Spiritcaller, when their souls are taken.", "Format must be like 'examplemod:entity'. Example: \"minecraft:zombie\"", "You can use the /summon command to scroll through and find the IDs for mobs you want!", "Only actually happens if the mob is in spiritcaller_stealableMobs", "Requires game restart"}).defineList("spiritcaller_wontAttack", Arrays.asList("minecraft:villager", "minecraft:wandering_trader"), String.class::isInstance);
        common.pop();
        common.push("Misc settings");
        igniter_canBurnBlocks = common.comment(new String[]{"Controls if Igniter should cause block damage with its fireballs.", "As of now its fireballs will still use the normal fire block; basically don't set this to true if you care about your world.", "Default = false", "Note that Igniter's block damage is still affected by the mobGriefing gamerule"}).define("igniter_canBurnBlocks", false);
        crocofang_rideableMobs = common.comment(new String[]{"Mobs put in this list will be randomly chosen to be the mob riding a Crocofang.", "Format must be like 'examplemod:entity'. Example: \"minecraft:zombie\"", "You can use the /summon command to scroll through and find the IDs for mobs you want!", "Invalid entity registry names will have the Crocofang being ridden by nothing. Same goes for if this list is empty", "Only entities extending the Abstract Raider class will actually join the Raid upon spawning", "Requires game restart"}).defineList("crocofang_rideableMobs", Arrays.asList("minecraft:pillager", "illageandspillage:igniter", "minecraft:vindicator"), String.class::isInstance);
        devastator_cantBreak = common.comment(new String[]{"Blocks the Devastator can't break.", "Format must be like 'examplemod:block'. Example: \"minecraft:bedrock\"", "You can use the /setblock command to scroll through and find the IDs for blocks you want!", "Invalid registry names will do nothing, so if you notice the Devastator is destroying a block it shouldn't, check this list for errors", "Requires game restart"}).defineList("devastator_cantBreak", Arrays.asList("minecraft:obsidian", "minecraft:bedrock", "minecraft:command_block", "minecraft:chain_command_block", "minecraft:repeating_command_block", "minecraft:barrier"), String.class::isInstance);
        devastator_ghostBlocks = common.comment(new String[]{"Controls if Devastator should leave behind ghost blocks in its destruction", "Don't set this to true if you care about your world.", "Default = false", "Note that Devastator's block damage is still affected by the mobGriefing gamerule"}).define("devastator_ghostBlocks", false);
        ghostblock_repairTime = common.comment(new String[]{"Time that Ghost Blocks take to repair", "Default = 6000 (5 minutes)"}).defineInRange("ghostblock_repairTime", 6000, 1, Integer.MAX_VALUE);
        absorber_damageMode = common.comment(new String[]{"The damage mode for Absorber.", "On false, Absorber will always take 1 damage from anything. On true, Absorber will take a maximum of 1 damage per hit.", "Default = false"}).define("absorber_damageMode", false);
        preserver_cannotProtect = common.comment(new String[]{"Illagers the Preserver will ignore.", "Format must be like 'examplemod:entity'. Example: \"minecraft:zombie\"", "You can use the /summon command to scroll through and find the IDs for mobs you want!", "Requires game restart"}).defineList("preserver_cannotProtect", Arrays.asList("illageandspillage:magispeller", "illageandspillage:spiritcaller", "illageandspillage:freakager"), String.class::isInstance);
        magispeller_balloonAllowed = common.comment(new String[]{"Determines if Magispeller is allowed to use balloons to break his fall.", "Default = true"}).define("magispeller_balloonAllowed", true);
        spellboundbook_rechargeTime = common.comment(new String[]{"Time in minutes that the Spellbound Book will go into cooldown for.", "Default = 60 (1 hour)", "Set to 0 to disable cooldown"}).defineInRange("spellboundbook_rechargeTime", 60, 0, Integer.MAX_VALUE);
        spellboundbook_effectTime = common.comment(new String[]{"Time in minutes that the Spellbound Book gives Misconduction for.", "Default = 40"}).defineInRange("spellboundbook_effectTime", 40, 1, Integer.MAX_VALUE);
        magispeller_distractEnemies = common.comment(new String[]{"Determines if Magispeller's death animation should distract other-team mobs. Mainly for Mob Battles.", "Default = true"}).define("magispeller_distractEnemies", true);
        ragno_attackTimes = common.comment(new String[]{"The amount of attacks Ragno needs to use in a row before stunning.", "Default = 4"}).defineInRange("ragno_attackTimes", 4, 1, Integer.MAX_VALUE);
        common.pop();
        common.pop();
    }
}

