/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render;

import com.yellowbrossproductions.illageandspillage.client.model.RagnoModel;
import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import java.util.Random;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RagnoRenderer
extends MobRenderer<RagnoEntity, RagnoModel<RagnoEntity>> {
    private final Random random = new Random();
    private static final ResourceLocation TEXTURE = new ResourceLocation("illageandspillage", "textures/entity/freakager/freakager.png");
    private static final ResourceLocation ARACHNOPHOBE = new ResourceLocation("illageandspillage", "textures/entity/freakager/freakager_arachnophobe.png");
    private static final ResourceLocation CRAZY = new ResourceLocation("illageandspillage", "textures/entity/freakager/freakager_phase2.png");

    public RagnoRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new RagnoModel(renderManagerIn.m_174023_(RagnoModel.LAYER_LOCATION)), 1.6f);
    }

    public Vec3 getRenderOffset(RagnoEntity p_114336_, float p_114337_) {
        float craziness = p_114336_.isCrazy() ? 2.0f : 1.0f;
        return new Vec3(this.random.nextGaussian() * 0.02 * (double)craziness, 0.0 + Math.min((double)p_114336_.f_20919_ / 10.0, 1.0) * 2.2, this.random.nextGaussian() * 0.02 * (double)craziness);
    }

    protected float getFlipDegrees(RagnoEntity p_115337_) {
        return 180.0f;
    }

    public ResourceLocation getTextureLocation(RagnoEntity p_110775_1_) {
        return (Boolean)IllageAndSpillageConfig.arachnophobeMode.get() != false ? ARACHNOPHOBE : (p_110775_1_.isCrazy() ? CRAZY : TEXTURE);
    }
}

