/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.yellowbrossproductions.illageandspillage.client.model.MagispellerModel;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerArmorLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerCough1Layer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerCough2Layer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerCough3Layer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerDispenserGlowLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerDispenserLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerFakerGlowLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerFakerLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerFangrunGlowLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerFangrunLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerFireGlowLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerFireLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerHealGlowLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerHealLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.magispeller.MagispellerLifestealLayer;
import com.yellowbrossproductions.illageandspillage.entities.MagispellerEntity;
import java.util.Calendar;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagispellerRenderer
extends MobRenderer<MagispellerEntity, MagispellerModel<MagispellerEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("illageandspillage", "textures/entity/magispeller/magispeller.png");
    private static final ResourceLocation NOTHING = new ResourceLocation("illageandspillage", "textures/entity/magispeller/magispeller_nothing.png");
    private static final ResourceLocation CHRISTMAS = new ResourceLocation("illageandspillage", "textures/entity/magispeller/christmas/magispeller_christmas.png");
    private static final ResourceLocation BALLOON = new ResourceLocation("illageandspillage", "textures/entity/magispeller/balloon.png");
    private static final float TEXTURE_WIDTH = 16.0f;
    private static final float TEXTURE_HEIGHT = 16.0f;
    private static final float START_RADIUS = 0.75f;

    public MagispellerRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new MagispellerModel(renderManagerIn.m_174023_(MagispellerModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_((RenderLayer)new MagispellerArmorLayer(this));
        this.m_115326_((RenderLayer)new MagispellerFakerLayer(this));
        this.m_115326_(new MagispellerFireLayer(this, renderManagerIn.m_174027_()));
        this.m_115326_((RenderLayer)new MagispellerFireGlowLayer(this));
        this.m_115326_((RenderLayer)new MagispellerLifestealLayer(this));
        this.m_115326_((RenderLayer)new MagispellerFakerGlowLayer(this));
        this.m_115326_(new MagispellerFangrunLayer(this, renderManagerIn.m_174027_()));
        this.m_115326_((RenderLayer)new MagispellerFangrunGlowLayer(this));
        this.m_115326_(new MagispellerDispenserLayer(this, renderManagerIn.m_174027_()));
        this.m_115326_((RenderLayer)new MagispellerDispenserGlowLayer(this));
        this.m_115326_(new MagispellerHealLayer(this, renderManagerIn.m_174027_()));
        this.m_115326_((RenderLayer)new MagispellerHealGlowLayer(this));
        this.m_115326_(new MagispellerCough1Layer(this, renderManagerIn.m_174027_()));
        this.m_115326_(new MagispellerCough2Layer(this, renderManagerIn.m_174027_()));
        this.m_115326_(new MagispellerCough3Layer(this, renderManagerIn.m_174027_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, renderManagerIn.m_174027_(), renderManagerIn.m_234598_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer<MagispellerEntity, MagispellerModel<MagispellerEntity>>((RenderLayerParent)this, renderManagerIn.m_234598_()){

            public void render(PoseStack p_116352_, MultiBufferSource p_116353_, int p_116354_, MagispellerEntity p_116355_, float p_116356_, float p_116357_, float p_116358_, float p_116359_, float p_116360_, float p_116361_) {
                if (p_116355_.shouldShowArms() || p_116355_.isFaking()) {
                    super.m_6494_(p_116352_, p_116353_, p_116354_, (LivingEntity)p_116355_, p_116356_, p_116357_, p_116358_, p_116359_, p_116360_, p_116361_);
                }
            }
        });
    }

    public void render(MagispellerEntity p_115455_, float p_115456_, float p_115457_, PoseStack poseStack, MultiBufferSource p_115459_, int light) {
        super.m_7392_((Mob)p_115455_, p_115456_, p_115457_, poseStack, p_115459_, light);
        float f1 = p_115455_.isBalloon() ? 1.0f : 0.0f;
        VertexConsumer ivertexbuilder = p_115459_.m_6299_(RenderType.m_110473_((ResourceLocation)this.getBalloonTextureLocation()));
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 3.2, 0.0);
        this.renderBall(f1, poseStack, ivertexbuilder, light);
        poseStack.m_85849_();
    }

    private void renderBall(float f1, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternion quat = this.f_114476_.m_114470_();
        matrixStackIn.m_85845_(quat);
        this.renderFlatQuad(f1, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderFlatQuad(float f1, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 10.0f;
        float minV = 0.0f;
        float maxU = minU + 1.0f;
        float maxV = minV + 1.0f;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        this.drawVertex(matrix4f, matrix3f, builder, -0.75f * -f1, -0.75f * -f1, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -0.75f * -f1, 0.75f * -f1, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.75f * -f1, 0.75f * -f1, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.75f * -f1, -0.75f * -f1, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_85982_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getBalloonTextureLocation() {
        return BALLOON;
    }

    public ResourceLocation getTextureLocation(MagispellerEntity p_110775_1_) {
        if (p_110775_1_.isFaking()) {
            return NOTHING;
        }
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12) {
            return CHRISTMAS;
        }
        return TEXTURE;
    }

    protected float getFlipDegrees(MagispellerEntity p_115337_) {
        return super.m_6441_((LivingEntity)p_115337_);
    }
}

