/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.entities.IgniterEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class IgniterModel<T extends Entity>
extends EntityModel<T>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "igniter"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart dispenser;

    public IgniterModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.right_leg = root.m_171324_("right_leg");
        this.left_leg = root.m_171324_("left_leg");
        this.right_arm = root.m_171324_("right_arm");
        this.left_arm = root.m_171324_("left_arm");
        this.dispenser = root.m_171324_("dispenser");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mask_on = head.m_171599_("mask_on", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mask_off = head.m_171599_("mask_off", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)-5.5f, (float)-2.25f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(112, 0).m_171488_(0.5f, 0.0f, 3.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(120, 14).m_171488_(1.5f, -1.0f, 4.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(120, 14).m_171488_(-3.5f, -1.0f, 4.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(120, 14).m_171488_(-1.0f, 5.5f, 4.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(120, 14).m_171488_(-1.0f, 4.5f, 4.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(112, 0).m_171488_(-4.5f, 0.0f, 3.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg_sub_0 = right_leg.m_171599_("right_leg_sub_0", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(0.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-6.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)6.0f, (float)2.0f, (float)0.0f, (float)-2.1817f, (float)-0.5236f, (float)0.0f));
        PartDefinition right_arm_sub_0 = right_arm.m_171599_("right_arm_sub_0", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(4.0f, -24.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)22.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)2.0f, (float)0.0f, (float)-0.9599f, (float)-0.2618f, (float)0.0f));
        PartDefinition dispenser = partdefinition.m_171599_("dispenser", CubeListBuilder.m_171558_().m_171514_(64, 32).m_171488_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(-4.0f)).m_171514_(0, 50).m_171488_(4.0f, -4.0f, -3.0f, 3.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)5.0f, (float)-7.0f));
        PartDefinition lever_handle = dispenser.m_171599_("lever_handle", CubeListBuilder.m_171558_().m_171514_(120, 36).m_171488_(-1.0f, -9.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition torch_lit = dispenser.m_171599_("torch_lit", CubeListBuilder.m_171558_().m_171514_(120, 20).m_171488_(-1.0f, -9.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)0.0f, (float)1.8326f, (float)0.0f, (float)0.0f));
        PartDefinition torch_burnt = dispenser.m_171599_("torch_burnt", CubeListBuilder.m_171558_().m_171514_(112, 20).m_171488_(-1.0f, -9.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)0.0f, (float)1.8326f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.right_leg.f_104203_ = -1.4137167f;
            this.right_leg.f_104204_ = -0.31415927f;
            this.right_leg.f_104205_ = -0.07853982f;
            this.left_leg.f_104203_ = -1.4137167f;
            this.left_leg.f_104204_ = 0.31415927f;
            this.left_leg.f_104205_ = 0.07853982f;
        } else {
            this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.right_leg.f_104205_ = 0.0f;
            this.left_leg.f_104205_ = 0.0f;
            this.right_leg.f_104204_ = 0.0f;
            this.left_leg.f_104204_ = 0.0f;
        }
        if (entity instanceof IgniterEntity) {
            IgniterEntity igniter = (IgniterEntity)((Object)entity);
            this.head.m_171324_((String)"mask_on").f_104207_ = igniter.isAttacking();
            this.head.m_171324_((String)"mask_off").f_104207_ = !igniter.isAttacking();
            this.dispenser.m_171324_((String)"torch_lit").f_104207_ = !igniter.isTorchBurntOut();
            this.dispenser.m_171324_((String)"torch_burnt").f_104207_ = igniter.isTorchBurntOut();
            if (igniter.isAttacking()) {
                this.right_arm.f_104203_ = -0.6981f;
                this.dispenser.m_171324_((String)"lever_handle").f_104205_ = 2.3562f;
            } else {
                this.right_arm.f_104203_ = -2.1817f;
                this.dispenser.m_171324_((String)"lever_handle").f_104205_ = 0.7854f;
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.right_leg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.left_leg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.right_arm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.left_arm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.dispenser.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

