/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server;

import com.bonker.stardewfishing.common.FishBehavior;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FishBehaviorReloadListener
extends SimplePreparableReloadListener<Map<String, JsonObject>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON_INSTANCE = new Gson();
    private static final ResourceLocation LOCATION = new ResourceLocation("stardew_fishing", "data.json");
    private static FishBehaviorReloadListener INSTANCE;
    private final Map<Item, FishBehavior> fishBehaviors = new HashMap<Item, FishBehavior>();
    private FishBehavior defaultBehavior;

    private FishBehaviorReloadListener() {
    }

    protected Map<String, JsonObject> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap<String, JsonObject> objects = new HashMap<String, JsonObject>();
        for (Resource resource : pResourceManager.m_213829_(LOCATION)) {
            try {
                InputStream inputstream = resource.m_215507_();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    objects.put(resource.m_215506_(), (JsonObject)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class));
                }
                finally {
                    if (inputstream == null) continue;
                    inputstream.close();
                }
            }
            catch (IOException | RuntimeException exception) {
                LOGGER.error("Invalid json in fish behavior list {} in data pack {}", (Object)LOCATION, (Object)resource.m_215506_(), (Object)exception);
            }
        }
        return objects;
    }

    protected void apply(Map<String, JsonObject> jsonObjects, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        for (Map.Entry<String, JsonObject> entry : jsonObjects.entrySet()) {
            FishBehaviorList.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).resultOrPartial(errorMsg -> LOGGER.warn("Failed to decode fish behavior list {} in data pack {} - {}", (Object)LOCATION, entry.getKey(), errorMsg)).ifPresent(behaviorList -> behaviorList.behaviors.forEach((loc, fishBehavior) -> {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
                if (item != null) {
                    if (behaviorList.replace || !this.fishBehaviors.containsKey(item)) {
                        this.fishBehaviors.put(item, (FishBehavior)fishBehavior);
                    }
                    behaviorList.defaultBehavior.ifPresent(behavior -> {
                        this.defaultBehavior = behavior;
                    });
                }
            }));
        }
    }

    public static FishBehaviorReloadListener create() {
        INSTANCE = new FishBehaviorReloadListener();
        return INSTANCE;
    }

    public static FishBehavior getBehavior(@Nullable ItemStack stack) {
        if (stack == null) {
            return FishBehaviorReloadListener.INSTANCE.defaultBehavior;
        }
        return FishBehaviorReloadListener.INSTANCE.fishBehaviors.getOrDefault(stack.m_41720_(), FishBehaviorReloadListener.INSTANCE.defaultBehavior);
    }

    private record FishBehaviorList(boolean replace, Map<ResourceLocation, FishBehavior> behaviors, Optional<FishBehavior> defaultBehavior) {
        private static final Codec<FishBehaviorList> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(FishBehaviorList::replace), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, FishBehavior.CODEC).fieldOf("behaviors").forGetter(FishBehaviorList::behaviors), (App)FishBehavior.CODEC.optionalFieldOf("defaultBehavior").forGetter(FishBehaviorList::defaultBehavior)).apply((Applicative)inst, FishBehaviorList::new));
    }
}

