/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public record FishBehavior(int idleTime, float topSpeed, float upAcceleration, float downAcceleration, int avgDistance, int moveVariation) {
    public static final Codec<FishBehavior> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("idle_time").forGetter(FishBehavior::idleTime), (App)Codec.FLOAT.fieldOf("top_speed").forGetter(FishBehavior::topSpeed), (App)Codec.FLOAT.fieldOf("up_acceleration").forGetter(FishBehavior::upAcceleration), (App)Codec.FLOAT.fieldOf("down_acceleration").forGetter(FishBehavior::downAcceleration), (App)Codec.INT.fieldOf("avg_distance").forGetter(FishBehavior::avgDistance), (App)Codec.INT.fieldOf("move_variation").forGetter(FishBehavior::moveVariation)).apply((Applicative)inst, FishBehavior::new));
    public static final int MAX_HEIGHT = 127;

    public FishBehavior(FriendlyByteBuf buf) {
        this(buf.m_130242_(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.m_130242_(), buf.m_130242_());
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130130_(this.idleTime);
        buf.writeFloat(this.topSpeed);
        buf.writeFloat(this.upAcceleration);
        buf.writeFloat(this.downAcceleration);
        buf.m_130130_(this.avgDistance);
        buf.m_130130_(this.moveVariation);
    }

    public boolean shouldMoveNow(int idleTicks, Random random) {
        if (this.idleTime == 0) {
            return true;
        }
        if (this.idleTime == 1) {
            return idleTicks == 1;
        }
        int variation = idleTicks / 2;
        float chancePerTick = 1.0f / (float)variation;
        if (idleTicks >= this.idleTime - variation) {
            return random.nextFloat() <= chancePerTick;
        }
        return false;
    }

    public int pickNextTargetPos(int oldPos, Random random) {
        int shortestDistance = this.avgDistance - this.moveVariation;
        int longestDistance = this.avgDistance + this.moveVariation;
        int downLowerLimit = oldPos - shortestDistance;
        int upLowerLimit = oldPos + shortestDistance;
        boolean canGoDown = downLowerLimit >= 0;
        boolean canGoUp = upLowerLimit <= 127;
        boolean goingUp = canGoUp && canGoDown ? random.nextBoolean() : canGoUp;
        int distance = random.nextInt(shortestDistance, longestDistance + 1);
        return Mth.m_14045_((int)(oldPos + distance * (goingUp ? 1 : -1)), (int)0, (int)127);
    }
}

