/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.client.FishingScreen;
import com.bonker.stardewfishing.common.FishBehavior;
import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class FishingMinigame {
    public static final int POINTS_TO_FINISH = 120;
    private static final float UP_ACCELERATION = 0.7f;
    private static final float GRAVITY = -0.7f;
    private static final int MAX_BOBBER_HEIGHT = 106;
    private static final int MAX_FISH_HEIGHT = 127;
    private final Random random = new Random();
    private final FishingScreen screen;
    private final FishBehavior behavior;
    private double bobberPos = 0.0;
    private double bobberVelocity = 0.0;
    private double fishPos = 0.0;
    private double fishVelocity = 0.0;
    private int fishTarget = -1;
    private boolean fishIsIdle = false;
    private int fishIdleTicks = 0;
    private boolean bobberOnFish = true;
    private int points = 24;
    private int successTicks = 0;
    private int totalTicks = 0;

    public FishingMinigame(FishingScreen screen, FishBehavior behavior) {
        this.screen = screen;
        this.behavior = behavior;
    }

    public void tick(boolean mouseDown) {
        if (mouseDown) {
            if (this.bobberVelocity < 0.0) {
                this.bobberVelocity *= 0.9;
            }
            this.bobberVelocity += (double)0.7f;
        } else if (this.bobberPos > 0.0) {
            this.bobberVelocity += (double)-0.7f;
        }
        this.bobberPos += this.bobberVelocity;
        if (this.bobberPos > 106.0) {
            this.bobberVelocity = 0.0;
            this.bobberPos = 106.0;
        } else if (this.bobberPos <= 0.0) {
            this.bobberPos = 0.0;
            this.bobberVelocity = this.bobberVelocity < (double)-1.4f ? (this.bobberVelocity *= -0.4) : 0.0;
        }
        if (this.fishTarget == -1 || this.behavior.shouldMoveNow(this.fishIdleTicks, this.random)) {
            this.fishTarget = this.behavior.pickNextTargetPos((int)this.fishPos, this.random);
            this.fishIsIdle = false;
            this.fishIdleTicks = 0;
        }
        if (this.fishIsIdle) {
            ++this.fishIdleTicks;
            if (Math.abs(this.fishVelocity) > 0.0) {
                boolean up = this.fishVelocity > 0.0;
                this.fishVelocity -= (double)(up ? this.behavior.upAcceleration() : this.behavior.downAcceleration()) * Math.signum(this.fishVelocity);
                if (this.fishVelocity == 0.0 || up && this.fishVelocity < 0.0 || !up && this.fishVelocity > 0.0) {
                    this.fishVelocity = 0.0;
                }
            }
        } else {
            double distanceLeft = (double)this.fishTarget - this.fishPos;
            double acceleration = (double)(distanceLeft > 0.0 ? this.behavior.upAcceleration() : this.behavior.downAcceleration()) * Math.signum(distanceLeft);
            this.fishVelocity = Mth.m_14008_((double)(this.fishVelocity + acceleration), (double)(-this.behavior.topSpeed()), (double)this.behavior.topSpeed());
        }
        this.fishPos += this.fishVelocity;
        if (Math.abs((double)this.fishTarget - this.fishPos) < this.fishVelocity) {
            this.fishIsIdle = true;
        } else if (this.fishPos > 127.0) {
            this.fishVelocity = 0.0;
            this.fishPos = 127.0;
            this.fishIsIdle = true;
        } else if (this.fishPos < 0.0) {
            this.fishVelocity = 0.0;
            this.fishPos = 0.0;
            this.fishIsIdle = true;
        }
        int min = Mth.m_14107_((double)this.bobberPos) - 2;
        int max = Mth.m_14165_((double)this.bobberPos) + 24;
        boolean wasOnFish = this.bobberOnFish;
        this.bobberOnFish = this.fishPos >= (double)min && this.fishPos <= (double)max;
        ++this.totalTicks;
        if (this.bobberOnFish) {
            ++this.successTicks;
        }
        if (wasOnFish != this.bobberOnFish) {
            this.screen.stopReelingSounds();
            this.screen.playSound((SoundEvent)StardewFishing.DWOP.get());
            this.screen.reelSoundTimer = 1;
        }
        if (this.bobberOnFish) {
            ++this.points;
            if (this.points >= 120) {
                this.screen.setResult(true, (double)this.successTicks / (double)this.totalTicks);
            }
        } else {
            --this.points;
            if (this.points <= 0) {
                this.screen.setResult(false, 0.0);
            }
        }
    }

    public float getBobberPos() {
        return (float)this.bobberPos;
    }

    public float getFishPos() {
        return (float)this.fishPos;
    }

    public boolean isBobberOnFish() {
        return this.bobberOnFish;
    }

    public float getProgress() {
        return (float)this.points / 120.0f;
    }
}

