/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="stardew_fishing", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SFConfig {
    static final ForgeConfigSpec SERVER_SPEC;
    private static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.DoubleValue QUALITY_1_THRESHOLD;
    private static final ForgeConfigSpec.DoubleValue QUALITY_2_THRESHOLD;
    private static final ForgeConfigSpec.DoubleValue QUALITY_3_THRESHOLD;
    private static final ForgeConfigSpec.DoubleValue QUALITY_1_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue QUALITY_2_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue QUALITY_3_MULTIPLIER;

    public static int getQuality(double accuracy) {
        if (accuracy >= (Double)QUALITY_3_THRESHOLD.get()) {
            return 3;
        }
        if (accuracy >= (Double)QUALITY_2_THRESHOLD.get()) {
            return 2;
        }
        if (accuracy >= (Double)QUALITY_1_THRESHOLD.get()) {
            return 1;
        }
        return 0;
    }

    public static double getMultiplier(double accuracy) {
        return switch (SFConfig.getQuality(accuracy)) {
            case 3 -> (Double)QUALITY_3_MULTIPLIER.get();
            case 2 -> (Double)QUALITY_2_MULTIPLIER.get();
            case 1 -> (Double)QUALITY_1_MULTIPLIER.get();
            default -> 1.0;
        };
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        QUALITY_1_THRESHOLD = BUILDER.comment("The minimum accuracy that grants an item of quality 1.").defineInRange("quality1Threshold", 0.75, 0.0, 1.0);
        QUALITY_2_THRESHOLD = BUILDER.comment("The minimum accuracy that grants an item of quality 2.").defineInRange("quality2Threshold", 0.9, 0.0, 1.0);
        QUALITY_3_THRESHOLD = BUILDER.comment("The minimum accuracy that grants an item of quality 3.").defineInRange("quality3Threshold", 1.0, 0.0, 1.0);
        QUALITY_1_MULTIPLIER = BUILDER.comment("The multiplier that is applied to experience gained from fishing a quality 1 reward.").defineInRange("quality1Multiplier", 1.5, 1.0, 10.0);
        QUALITY_2_MULTIPLIER = BUILDER.comment("The multiplier that is applied to experience gained from fishing a quality 2 reward.").defineInRange("quality2Multiplier", 2.5, 1.0, 10.0);
        QUALITY_3_MULTIPLIER = BUILDER.comment("The multiplier that is applied to experience gained from fishing a quality 3 reward.").defineInRange("quality3Multiplier", 4.0, 1.0, 10.0);
        SERVER_SPEC = BUILDER.build();
    }
}

