/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.potionshrines.blocks;

import com.dreu.potionshrines.blocks.ShrineBlock;
import com.dreu.potionshrines.config.PSGeneralConfig;
import com.dreu.potionshrines.config.PSShrineConfig;
import com.dreu.potionshrines.registry.PSBlockEntities;
import com.electronwill.nightconfig.core.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ShrineBlockEntity
extends BlockEntity {
    public int maxCooldown;
    public String effect;
    public int duration;
    public int amplifier;
    private int remainingCooldown = 0;
    private String icon;

    public ShrineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PSBlockEntities.SHRINE.get(), blockPos, blockState);
        Config SHRINE = PSShrineConfig.getRandomShrine();
        this.amplifier = (Integer)SHRINE.get("Amplifier") - 1;
        this.duration = (Integer)SHRINE.get("Duration");
        this.maxCooldown = (Integer)SHRINE.get("Cooldown") * 20;
        this.effect = (String)SHRINE.get("Effect");
        this.icon = (String)SHRINE.get("Icon");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, ShrineBlockEntity shrine) {
        if (shrine.maxCooldown == 999999) {
            return;
        }
        if (shrine.remainingCooldown == 40) {
            level.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11736_, SoundSource.BLOCKS, 10.0f, 1.0f, true);
        }
        if (PSGeneralConfig.SHRINES_REPLENISH.booleanValue() && shrine.remainingCooldown > 30) {
            if (shrine.remainingCooldown > shrine.maxCooldown - 30) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ShrineBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(15 - (shrine.maxCooldown - shrine.remainingCooldown) / 2)), 11);
            }
            --shrine.remainingCooldown;
            ShrineBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        } else if (shrine.remainingCooldown > 0) {
            --shrine.remainingCooldown;
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ShrineBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(15 - shrine.remainingCooldown / 2)), 11);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128359_("effect", this.effect);
        nbt.m_128405_("duration", this.duration);
        nbt.m_128405_("max_cooldown", this.maxCooldown);
        nbt.m_128405_("remaining_cooldown", this.remainingCooldown);
        nbt.m_128405_("amplifier", this.amplifier);
        nbt.m_128359_("icon", this.icon);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.amplifier = nbt.m_128451_("amplifier");
        this.remainingCooldown = nbt.m_128451_("remaining_cooldown");
        this.maxCooldown = nbt.m_128451_("max_cooldown");
        this.duration = nbt.m_128451_("duration");
        this.effect = nbt.m_128461_("effect");
        this.icon = nbt.m_128461_("icon");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public String getEffect() {
        return this.effect;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getMaxCooldown() {
        return this.maxCooldown;
    }

    public int getRemainingCooldown() {
        return this.remainingCooldown;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean canUse() {
        return this.remainingCooldown == 0;
    }

    public void resetCooldown() {
        this.remainingCooldown = this.maxCooldown;
    }
}

