/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.potionshrines.blocks;

import com.dreu.potionshrines.PotionShrines;
import com.dreu.potionshrines.blocks.ShrineBaseBlock;
import com.dreu.potionshrines.blocks.ShrineBlockEntity;
import com.dreu.potionshrines.registry.PSBlockEntities;
import com.dreu.potionshrines.registry.PSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShrineBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.m_61631_((String)"light_level", (int)0, (int)15);

    public ShrineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(15)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.INVISIBLE;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return 3600000.0f;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        ShrineBlockEntity blockEntity = new ShrineBlockEntity(blockPos, blockState);
        blockEntity.m_6596_();
        return blockEntity;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos blockPos, Player player) {
        if (player.m_6047_()) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            level.m_7702_(blockPos).m_187476_(itemStack);
            return itemStack;
        }
        return super.getCloneItemStack(state, target, level, blockPos, player);
    }

    public boolean m_8133_(BlockState blockState, Level level, BlockPos blockPos, int i, int i1) {
        super.m_8133_(blockState, level, blockPos, i, i1);
        return level.m_7702_(blockPos) != null && level.m_7702_(blockPos).m_7531_(i, i1);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return ShrineBlock.createTickerHelper(blockEntityType, (BlockEntityType)PSBlockEntities.SHRINE.get(), ShrineBlockEntity::tick);
    }

    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> aBlockEntityType, BlockEntityType<E> eBlockEntityType, BlockEntityTicker<? super E> blockEntityTicker) {
        return eBlockEntityType == aBlockEntityType ? blockEntityTicker : null;
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ShrineBlockEntity shrine = (ShrineBlockEntity)level.m_7702_(blockPos);
        if (shrine.canUse()) {
            level.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_11738_, SoundSource.BLOCKS, 10.0f, 1.0f, true);
            shrine.resetCooldown();
            if (!level.f_46443_) {
                player.m_7292_(new MobEffectInstance(PotionShrines.getEffectFromString(shrine.getEffect()), shrine.getDuration() * 20, shrine.getAmplifier()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean b) {
        level.m_7731_(blockPos.m_6625_(1), (BlockState)((Block)PSBlocks.SHRINE_BASE.get()).m_49966_().m_61124_(ShrineBaseBlock.HALF, (Comparable)Half.TOP), 11);
        level.m_7731_(blockPos.m_6625_(2), (BlockState)((Block)PSBlocks.SHRINE_BASE.get()).m_49966_().m_61124_(ShrineBaseBlock.HALF, (Comparable)Half.BOTTOM), 11);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIGHT_LEVEL});
    }
}

