/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.potionshrines;

import com.dreu.potionshrines.blocks.ShrineRenderer;
import com.dreu.potionshrines.config.PSShrineConfig;
import com.dreu.potionshrines.registry.PSBlockEntities;
import com.dreu.potionshrines.registry.PSBlocks;
import com.dreu.potionshrines.registry.PSFeatures;
import com.dreu.potionshrines.registry.PSItems;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="potion_shrines")
public class PotionShrines {
    public static final String MODID = "potion_shrines";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Random rand = new Random();
    public static final Map<String, BakedModel> BAKED_ICONS = new HashMap<String, BakedModel>();

    public PotionShrines() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        PSItems.ITEMS.register(eventBus);
        PSBlocks.BLOCKS.register(eventBus);
        PSBlockEntities.BLOCK_ENTITIES.register(eventBus);
        PSFeatures.FEATURES.register(eventBus);
        PSFeatures.Configured.CONFIGURED_FEATURES.register(eventBus);
        PSFeatures.Placed.PLACED_FEATURES.register(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static MobEffect getEffectFromString(String effect) {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getDelegateOrThrow(new ResourceLocation(effect)).get();
    }

    @Mod.EventBusSubscriber(modid="potion_shrines", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)PSBlockEntities.SHRINE.get()), ShrineRenderer::new);
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            for (String icon : PSShrineConfig.SHRINE_ICONS) {
                event.register(new ResourceLocation(PotionShrines.MODID, icon));
            }
            event.register(new ResourceLocation(PotionShrines.MODID, "default"));
        }

        @SubscribeEvent
        public static void bakeModels(ModelEvent.BakingCompleted event) {
            for (String icon : PSShrineConfig.SHRINE_ICONS) {
                ResourceLocation iconLocation = new ResourceLocation(PotionShrines.MODID, icon);
                BAKED_ICONS.put(icon, Minecraft.m_91087_().m_91304_().getModelBakery().m_119341_(iconLocation).m_7611_(Minecraft.m_91087_().m_91304_().getModelBakery(), material -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(material.m_119193_()).apply(material.m_119203_()), (ModelState)new SimpleModelState(Transformation.m_121093_()), iconLocation));
            }
            ResourceLocation iconLocation = new ResourceLocation(PotionShrines.MODID, "default");
            BAKED_ICONS.put("default", Minecraft.m_91087_().m_91304_().getModelBakery().m_119341_(iconLocation).m_7611_(Minecraft.m_91087_().m_91304_().getModelBakery(), material -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(material.m_119193_()).apply(material.m_119203_()), (ModelState)new SimpleModelState(Transformation.m_121093_()), iconLocation));
        }

        @SubscribeEvent
        public static void onTextureStitch(TextureStitchEvent.Pre event) {
            if (event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
                for (String icon : PSShrineConfig.SHRINE_ICONS) {
                    event.addSprite(new ResourceLocation(PotionShrines.MODID, icon));
                }
                event.addSprite(new ResourceLocation(PotionShrines.MODID, "default"));
            }
        }
    }
}

