/*
 * Decompiled with CFR 0.152.
 */
package com.ferri.arnus.unidentifiedenchantments.command;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.bridge.game.PackType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.loot.LootModifierManager;

public class GlobalLootTableCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"globalloot").executes(e -> GlobalLootTableCommand.sendLoot((CommandContext<CommandSourceStack>)e, ""))).requires(r -> r.m_6761_(3))).then(Commands.m_82129_((String)"replace", (ArgumentType)GlobalLootArgument.string()).executes(e -> GlobalLootTableCommand.sendLoot((CommandContext<CommandSourceStack>)e, GlobalLootArgument.getString(e, "replace")))));
    }

    static int sendLoot(CommandContext<CommandSourceStack> commandContext, String s) {
        JsonObject j = new JsonObject();
        JsonArray array = new JsonArray();
        for (ResourceLocation r : GlobalLootTableCommand.collectLoot()) {
            if (r.toString().equals("unidentifiedenchantments:hiddenloot")) continue;
            array.add(r.toString());
        }
        array.add("unidentifiedenchantments:hiddenloot");
        j.addProperty("replace", Boolean.valueOf(true));
        j.add("entries", (JsonElement)array);
        JsonElement jsonTree = GSON.toJsonTree((Object)j);
        try {
            if (s.equals("replace")) {
                GlobalLootTableCommand.ensurePackDefinitionExists(((CommandSourceStack)commandContext.getSource()).m_81377_().m_129843_(LevelResource.f_78180_).resolve("unidentifiedenchantmentsautopack"));
                path = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129843_(LevelResource.f_78180_).resolve("unidentifiedenchantmentsautopack/data/forge/loot_modifiers/global_loot_modifiers.json");
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);
                bufferedwriter.write(GSON.toJson(jsonTree));
                bufferedwriter.close();
                WorldData worlddata = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129910_();
                Collection collection = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129891_().m_10523_();
                Collection<String> collection1 = GlobalLootTableCommand.discoverNewPacks(((CommandSourceStack)commandContext.getSource()).m_81377_().m_129891_(), worlddata, collection);
                ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129861_(collection1);
            } else if (s.equals("")) {
                path = Paths.get("config/global_loot_modifiers.json", new String[0]);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);
                bufferedwriter.write(GSON.toJson(jsonTree));
                bufferedwriter.close();
            } else if (s.equals("delete")) {
                path = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129843_(LevelResource.f_78180_).resolve("unidentifiedenchantmentsautopack/data/forge/loot_modifiers/global_loot_modifiers.json");
                Files.deleteIfExists(path);
                WorldData worlddata = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129910_();
                Collection collection = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129891_().m_10523_();
                Collection<String> collection1 = GlobalLootTableCommand.discoverNewPacks(((CommandSourceStack)commandContext.getSource()).m_81377_().m_129891_(), worlddata, collection);
                ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129861_(collection1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public static ArrayList<ResourceLocation> collectLoot() {
        try {
            Field field = ForgeInternalHandler.class.getDeclaredField("INSTANCE");
            field.setAccessible(true);
            LootModifierManager manager = (LootModifierManager)field.get(null);
            Field declaredField = LootModifierManager.class.getDeclaredField("registeredLootModifiers");
            declaredField.setAccessible(true);
            Map registeredLootModifiers = (Map)declaredField.get(manager);
            return new ArrayList<ResourceLocation>(registeredLootModifiers.keySet());
        }
        catch (Exception e) {
            System.err.println(e);
            return new ArrayList<ResourceLocation>();
        }
    }

    private static void ensurePackDefinitionExists(Path packRoot) {
        Path metaFile = packRoot.resolve("pack.mcmeta");
        if (!Files.exists(metaFile, new LinkOption[0])) {
            JsonObject pack = new JsonObject();
            pack.addProperty("pack_format", (Number)SharedConstants.m_183709_().getPackVersion(PackType.DATA));
            pack.addProperty("description", "Datapack generated by the Unidentified enchantments mod");
            JsonObject root = new JsonObject();
            root.add("pack", (JsonElement)pack);
            try {
                Files.createDirectories(packRoot, new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(metaFile, new OpenOption[0]);){
                    writer.write(GSON.toJson((JsonElement)root));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Collection<String> discoverNewPacks(PackRepository p_138223_, WorldData p_138224_, Collection<String> p_138225_) {
        p_138223_.m_10506_();
        ArrayList collection = Lists.newArrayList(p_138225_);
        List collection1 = p_138224_.m_7513_().m_45855_();
        for (String s : p_138223_.m_10514_()) {
            if (collection1.contains(s) || collection.contains(s)) continue;
            collection.add(s);
        }
        return collection;
    }

    public static class GlobalLootArgument
    implements ArgumentType<String> {
        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            builder.suggest("replace");
            builder.suggest("delete");
            return builder.buildFuture();
        }

        public static GlobalLootArgument string() {
            return new GlobalLootArgument();
        }

        public String parse(StringReader reader) throws CommandSyntaxException {
            return reader.readUnquotedString();
        }

        public static String getString(CommandContext<?> context, String name) {
            return (String)context.getArgument(name, String.class);
        }
    }
}

