/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.blockwardens;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.FileUtils;

@Mod(value="blockwardens")
public class BlockWardens {
    public static final String MODID = "blockwardens";
    public static List<BlockPos> killedWardens = new ArrayList<BlockPos>();
    private File wardenFile;
    private Gson gson = new Gson();

    public BlockWardens() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.wardenFile = event.getServer().m_129971_("wardens.json");
        this.loadWardens();
    }

    private void loadWardens() {
        try {
            if (!this.wardenFile.exists()) {
                this.wardenFile.createNewFile();
                killedWardens = new ArrayList<BlockPos>();
                FileUtils.writeStringToFile((File)this.wardenFile, (String)this.gson.toJson(killedWardens), (Charset)StandardCharsets.UTF_8);
            } else {
                Type blockPosType = new TypeToken<ArrayList<BlockPos>>(){}.getType();
                killedWardens = (List)this.gson.fromJson(FileUtils.readFileToString((File)this.wardenFile, (Charset)StandardCharsets.UTF_8), blockPosType);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void saveWardens() {
        try {
            if (!this.wardenFile.exists()) {
                this.wardenFile.createNewFile();
            }
            FileUtils.writeStringToFile((File)this.wardenFile, (String)this.gson.toJson(killedWardens), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @SubscribeEvent
    public void killWardenEvent(LivingDeathEvent event) {
        if (event.getEntity() instanceof Warden && event.getSource().m_7639_() instanceof Player) {
            Warden warden = (Warden)event.getEntity();
            killedWardens.add(new BlockPos(warden.m_146903_(), warden.m_146904_(), warden.m_146907_()));
            this.saveWardens();
        }
    }
}

