/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.protectyourstructures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import me.khajiitos.protectyourstructures.ProtectYourStructures;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;

public class Config {
    private static final File file = new File("config/protectyourstructures.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final List<ResourceKey<Structure>> structures = new ArrayList<ResourceKey<Structure>>();

    public static void load(RegistryAccess registryAccess) {
        if (file.exists()) {
            try (FileReader fileReader = new FileReader(file);){
                JsonObject object = (JsonObject)GSON.fromJson((Reader)fileReader, JsonObject.class);
                JsonArray structuresArray = object.get("structures").getAsJsonArray();
                structuresArray.forEach(jsonElement -> {
                    try {
                        String resourceKeyStr = jsonElement.getAsString();
                        ResourceLocation resourceLocation = new ResourceLocation(resourceKeyStr);
                        Structure structure = (Structure)registryAccess.m_175515_(Registry.f_235725_).m_7745_(resourceLocation);
                        if (structure != null) {
                            structures.add((ResourceKey<Structure>)ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)resourceLocation));
                        } else {
                            ProtectYourStructures.LOGGER.warn("Skipping unknown structure: " + resourceKeyStr);
                        }
                    }
                    catch (ClassCastException | IllegalArgumentException runtimeException) {
                        // empty catch block
                    }
                });
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProtectYourStructures.LOGGER.error("JSON error", e);
            }
            catch (IOException e) {
                ProtectYourStructures.LOGGER.error("Error while loading config", (Throwable)e);
            }
        } else {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                ProtectYourStructures.LOGGER.error("Failed to create directories for protectyourstructures.json");
                return;
            }
            Config.save();
        }
    }

    public static void save() {
        try (FileWriter fileReader = new FileWriter(file);){
            JsonObject object = new JsonObject();
            JsonArray structuresArray = new JsonArray();
            structures.forEach(structureKey -> structuresArray.add(structureKey.m_135782_().toString()));
            object.add("structures", (JsonElement)structuresArray);
            fileReader.write(GSON.toJson((JsonElement)object));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

