/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.client.cloth;

import com.google.common.collect.Lists;
import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.config.enums.AdjacentStopMode;
import fr.raksrinana.fallingtree.common.config.enums.BreakMode;
import fr.raksrinana.fallingtree.common.config.enums.BreakOrder;
import fr.raksrinana.fallingtree.common.config.enums.DamageRounding;
import fr.raksrinana.fallingtree.common.config.enums.DetectionMode;
import fr.raksrinana.fallingtree.common.config.enums.MaxSizeAction;
import fr.raksrinana.fallingtree.common.config.enums.NotificationMode;
import fr.raksrinana.fallingtree.common.config.enums.SneakMode;
import fr.raksrinana.fallingtree.common.config.real.Configuration;
import fr.raksrinana.fallingtree.common.config.real.EnchantmentConfiguration;
import fr.raksrinana.fallingtree.common.config.real.PlayerConfiguration;
import fr.raksrinana.fallingtree.common.config.real.ToolConfiguration;
import fr.raksrinana.fallingtree.common.config.real.TreeConfiguration;
import fr.raksrinana.fallingtree.common.config.real.cloth.ClothHookBase;
import fr.raksrinana.fallingtree.common.wrapper.IComponent;
import fr.raksrinana.fallingtree.common.wrapper.IWrapper;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClothConfigHook
extends ClothHookBase {
    public ClothConfigHook(@NotNull FallingTreeCommon<?> mod) {
        super(mod);
    }

    @NotNull
    public Function<class_437, class_437> load() {
        return screen -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle((class_2561)class_5250.method_43477((class_7417)new class_2585("FallingTree")));
            Configuration configuration = this.getMod().getOwnConfiguration();
            builder.setSavingRunnable(configuration::onUpdate);
            this.fillConfigScreen(builder, configuration);
            return builder.build();
        };
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigScreen(@NotNull ConfigBuilder builder, @NotNull Configuration config) {
        EnumListEntry reverseSneakingEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName(null, "sneakMode")), SneakMode.class, (Enum)config.getSneakMode()).setDefaultValue((Enum)SneakMode.SNEAK_DISABLE).setTooltip(this.getTooltips(null, "sneakMode", 5)).setSaveConsumer(config::setSneakMode).build();
        BooleanListEntry breakInCreativeEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName(null, "breakInCreative")), config.isBreakInCreative()).setDefaultValue(false).setTooltip(this.getTooltips(null, "breakInCreative", 2)).setSaveConsumer(config::setBreakInCreative).build();
        BooleanListEntry lootInCreativeEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName(null, "lootInCreative")), config.isLootInCreative()).setDefaultValue(true).setTooltip(this.getTooltips(null, "lootInCreative", 2)).setSaveConsumer(config::setLootInCreative).build();
        EnumListEntry notificationModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName(null, "notificationMode")), NotificationMode.class, (Enum)config.getNotificationMode()).setDefaultValue((Enum)NotificationMode.ACTION_BAR).setTooltip(this.getTooltips(null, "notificationMode", 5)).setSaveConsumer(config::setNotificationMode).build();
        ConfigCategory general = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.default"));
        general.addEntry((AbstractConfigListEntry)reverseSneakingEntry);
        general.addEntry((AbstractConfigListEntry)breakInCreativeEntry);
        general.addEntry((AbstractConfigListEntry)lootInCreativeEntry);
        general.addEntry((AbstractConfigListEntry)notificationModeEntry);
        this.fillTreesConfigScreen(builder, config.getTrees());
        this.fillToolsConfigScreen(builder, config.getTools());
        this.fillPlayerConfigScreen(builder, config.getPlayer());
        this.fillEnchantmentConfigScreen(builder, config.getEnchantment());
    }

    @Environment(value=EnvType.CLIENT)
    private void fillTreesConfigScreen(@NotNull ConfigBuilder builder, @NotNull TreeConfiguration config) {
        EnumListEntry breakModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "breakMode")), BreakMode.class, (Enum)config.getBreakMode()).setDefaultValue((Enum)BreakMode.INSTANTANEOUS).setTooltip(this.getTooltips("trees", "breakMode", 7)).setSaveConsumer(config::setBreakMode).build();
        EnumListEntry detectionModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "detectionMode")), DetectionMode.class, (Enum)config.getDetectionMode()).setDefaultValue((Enum)DetectionMode.WHOLE_TREE).setTooltip(this.getTooltips("trees", "detectionMode", 9)).setSaveConsumer(config::setDetectionMode).build();
        StringListListEntry allowedLogsEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "allowedLogs")), config.getAllowedLogs()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedLogs", 5)).setSaveConsumer(config::setAllowedLogs).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry deniedLogsEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "deniedLogs")), config.getDeniedLogs()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "deniedLogs", 3)).setSaveConsumer(config::setDeniedLogs).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry allowedLeavesEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "allowedLeaves")), config.getAllowedLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedLeaves", 5)).setSaveConsumer(config::setAllowedLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry allowedNonDecayLeavesEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "allowedNonDecayLeaves")), config.getAllowedNonDecayLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedNonDecayLeaves", 2)).setSaveConsumer(config::setAllowedNonDecayLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry deniedLeavesEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "deniedLeaves")), config.getDeniedLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "deniedLeaves", 3)).setSaveConsumer(config::setDeniedLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        IntegerListEntry maxScanSizeEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "maxScanSize")), config.getMaxScanSize()).setDefaultValue(500).setMin(1).setTooltip(this.getTooltips("trees", "maxScanSize", 3)).setSaveConsumer(config::setMaxScanSize).build();
        IntegerListEntry maxSizeEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "maxSize")), config.getMaxSize()).setDefaultValue(100).setMin(1).setTooltip(this.getTooltips("trees", "maxSize", 2)).setSaveConsumer(config::setMaxSize).build();
        EnumListEntry maxSizeActionEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "maxSizeAction")), MaxSizeAction.class, (Enum)config.getMaxSizeAction()).setDefaultValue((Enum)MaxSizeAction.ABORT).setTooltip(this.getTooltips("trees", "maxSizeAction", 4)).setSaveConsumer(config::setMaxSizeAction).build();
        EnumListEntry breakOrderEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "breakOrder")), BreakOrder.class, (Enum)config.getBreakOrder()).setDefaultValue((Enum)BreakOrder.FURTHEST_FIRST).setTooltip(this.getTooltips("trees", "breakOrder", 4)).setSaveConsumer(config::setBreakOrder).build();
        BooleanListEntry treeBreakingEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "treeBreaking")), config.isTreeBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "treeBreaking", 1)).setSaveConsumer(config::setTreeBreaking).build();
        BooleanListEntry leavesBreakingEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "leavesBreaking")), config.isLeavesBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "leavesBreaking", 2)).setSaveConsumer(config::setLeavesBreaking).build();
        IntegerListEntry leavesBreakingForceRadiusEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "leavesBreakingForceRadius")), config.getLeavesBreakingForceRadius()).setDefaultValue(0).setMin(0).setMax(10).setTooltip(this.getTooltips("trees", "leavesBreakingForceRadius", 8)).setSaveConsumer(config::setLeavesBreakingForceRadius).build();
        IntegerListEntry minimumLeavesAroundRequiredEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "minimumLeavesAroundRequired")), config.getMinimumLeavesAroundRequired()).setDefaultValue(1).setMin(0).setMax(5).setTooltip(this.getTooltips("trees", "minimumLeavesAroundRequired", 4)).setSaveConsumer(config::setMinimumLeavesAroundRequired).build();
        BooleanListEntry includePersistentLeavesInRequiredCountEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "includePersistentLeavesInRequiredCount")), config.isIncludePersistentLeavesInRequiredCount()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "includePersistentLeavesInRequiredCount", 5)).setSaveConsumer(config::setIncludePersistentLeavesInRequiredCount).build();
        BooleanListEntry allowMixedLogsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "allowMixedLogs")), config.isAllowMixedLogs()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "allowMixedLogs", 4)).setSaveConsumer(config::setAllowMixedLogs).build();
        BooleanListEntry instantlyBreakWartsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "instantlyBreakWarts")), config.isInstantlyBreakWarts()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "instantlyBreakWarts", 2)).setSaveConsumer(config::setInstantlyBreakWarts).build();
        BooleanListEntry breakNetherTreeWartsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "breakNetherTreeWarts")), config.isBreakNetherTreeWarts()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "breakNetherTreeWarts", 2)).setSaveConsumer(config::setBreakNetherTreeWarts).build();
        BooleanListEntry breakMangroveRootsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "breakMangroveRoots")), config.isBreakMangroveRoots()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "breakMangroveRoots", 2)).setSaveConsumer(config::setBreakMangroveRoots).build();
        IntegerListEntry searchAreaRadiusEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "searchAreaRadius")), config.getSearchAreaRadius()).setDefaultValue(-1).setTooltip(this.getTooltips("trees", "searchAreaRadius", 5)).setSaveConsumer(config::setSearchAreaRadius).build();
        StringListListEntry allowedAdjacentBlocks = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "allowedAdjacentBlocks")), config.getAllowedAdjacentBlocks()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedAdjacentBlocks", 9)).setSaveConsumer(config::setAllowedAdjacentBlocks).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        EnumListEntry adjacentStopModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "adjacentStopMode")), AdjacentStopMode.class, (Enum)config.getAdjacentStopMode()).setDefaultValue((Enum)AdjacentStopMode.STOP_ALL).setTooltip(this.getTooltips("trees", "adjacentStopMode", 9)).setSaveConsumer(config::setAdjacentStopMode).build();
        ConfigCategory trees = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.trees"));
        trees.addEntry((AbstractConfigListEntry)breakModeEntry);
        trees.addEntry((AbstractConfigListEntry)detectionModeEntry);
        trees.addEntry((AbstractConfigListEntry)allowedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)deniedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)allowedLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)allowedNonDecayLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)deniedLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)maxScanSizeEntry);
        trees.addEntry((AbstractConfigListEntry)maxSizeEntry);
        trees.addEntry((AbstractConfigListEntry)maxSizeActionEntry);
        trees.addEntry((AbstractConfigListEntry)breakOrderEntry);
        trees.addEntry((AbstractConfigListEntry)treeBreakingEntry);
        trees.addEntry((AbstractConfigListEntry)leavesBreakingEntry);
        trees.addEntry((AbstractConfigListEntry)leavesBreakingForceRadiusEntry);
        trees.addEntry((AbstractConfigListEntry)minimumLeavesAroundRequiredEntry);
        trees.addEntry((AbstractConfigListEntry)includePersistentLeavesInRequiredCountEntry);
        trees.addEntry((AbstractConfigListEntry)allowMixedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)breakNetherTreeWartsEntry);
        trees.addEntry((AbstractConfigListEntry)instantlyBreakWartsEntry);
        trees.addEntry((AbstractConfigListEntry)breakMangroveRootsEntry);
        trees.addEntry((AbstractConfigListEntry)searchAreaRadiusEntry);
        trees.addEntry((AbstractConfigListEntry)allowedAdjacentBlocks);
        trees.addEntry((AbstractConfigListEntry)adjacentStopModeEntry);
    }

    @Environment(value=EnvType.CLIENT)
    private void fillToolsConfigScreen(@NotNull ConfigBuilder builder, @NotNull ToolConfiguration config) {
        BooleanListEntry ignoreToolsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("tools", "ignoreTools")), config.isIgnoreTools()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "ignoreTools", 4)).setSaveConsumer(config::setIgnoreTools).build();
        StringListListEntry allowedEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("tools", "allowed")), config.getAllowed()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "allowed", 3)).setSaveConsumer(config::setAllowed).setCellErrorSupplier(this.map(this.getMinecraftItemIdCellError())).build();
        StringListListEntry deniedEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("tools", "denied")), config.getDenied()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "denied", 3)).setSaveConsumer(config::setDenied).setCellErrorSupplier(this.map(this.getMinecraftItemIdCellError())).build();
        DoubleListEntry damageMultiplicandEntry = builder.entryBuilder().startDoubleField(this.translatable(this.getFieldName("tools", "damageMultiplicand")), config.getDamageMultiplicand()).setDefaultValue(1.0).setMin(0.0).setMax(100.0).setTooltip(this.getTooltips("tools", "damageMultiplicand", 7)).setSaveConsumer(config::setDamageMultiplicand).build();
        EnumListEntry damageRoundingEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("tools", "damageRounding")), DamageRounding.class, (Enum)config.getDamageRounding()).setDefaultValue((Enum)DamageRounding.ROUND_DOWN).setTooltip(this.getTooltips("tools", "damageRounding", 8)).setSaveConsumer(config::setDamageRounding).build();
        DoubleListEntry speedMultiplicandEntry = builder.entryBuilder().startDoubleField(this.translatable(this.getFieldName("tools", "speedMultiplicand")), config.getSpeedMultiplicand()).setDefaultValue(0.0).setMin(0.0).setMax(50.0).setTooltip(this.getTooltips("tools", "speedMultiplicand", 15)).setSaveConsumer(config::setSpeedMultiplicand).build();
        BooleanListEntry preserveEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("tools", "preserve")), config.isPreserve()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "preserve", 3)).setSaveConsumer(config::setPreserve).build();
        BooleanListEntry forceToolUsageEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("tools", "forceToolUsage")), config.isForceToolUsage()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "forceToolUsage", 2)).setSaveConsumer(config::setForceToolUsage).build();
        ConfigCategory tools = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.tools"));
        tools.addEntry((AbstractConfigListEntry)ignoreToolsEntry);
        tools.addEntry((AbstractConfigListEntry)allowedEntry);
        tools.addEntry((AbstractConfigListEntry)deniedEntry);
        tools.addEntry((AbstractConfigListEntry)damageMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)damageRoundingEntry);
        tools.addEntry((AbstractConfigListEntry)speedMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)preserveEntry);
        tools.addEntry((AbstractConfigListEntry)forceToolUsageEntry);
    }

    @Environment(value=EnvType.CLIENT)
    private void fillPlayerConfigScreen(@NotNull ConfigBuilder builder, @NotNull PlayerConfiguration config) {
        StringListListEntry allowedTagsEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("player", "allowedTags")), config.getAllowedTags()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("player", "allowedTags", 4)).setSaveConsumer(config::setAllowedTags).build();
        ConfigCategory tools = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.player"));
        tools.addEntry((AbstractConfigListEntry)allowedTagsEntry);
    }

    @Environment(value=EnvType.CLIENT)
    private void fillEnchantmentConfigScreen(@NotNull ConfigBuilder builder, @NotNull EnchantmentConfiguration config) {
        BooleanListEntry registerEnchantEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("enchantment", "registerEnchant")), config.isRegisterEnchant()).setDefaultValue(false).setTooltip(this.getTooltips("enchantment", "registerEnchant", 8)).setSaveConsumer(config::setRegisterEnchant).build();
        BooleanListEntry registerSpecificEnchantEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("enchantment", "registerSpecificEnchant")), config.isRegisterSpecificEnchant()).setDefaultValue(false).setTooltip(this.getTooltips("enchantment", "registerSpecificEnchant", 9)).setSaveConsumer(config::setRegisterSpecificEnchant).build();
        BooleanListEntry hideEnchantEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("enchantment", "hideEnchant")), config.isHideEnchant()).setDefaultValue(false).setTooltip(this.getTooltips("enchantment", "hideEnchant", 2)).setSaveConsumer(config::setHideEnchant).build();
        ConfigCategory enchantment = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.enchantment"));
        enchantment.addEntry((AbstractConfigListEntry)registerEnchantEntry);
        enchantment.addEntry((AbstractConfigListEntry)registerSpecificEnchantEntry);
        enchantment.addEntry((AbstractConfigListEntry)hideEnchantEntry);
    }

    @NotNull
    private class_2561 translatable(@NotNull String key) {
        return (class_2561)this.getMod().translate(key, new Object[0]).getRaw();
    }

    @NotNull
    private Function<String, Optional<class_2561>> map(@NotNull Function<String, Optional<IComponent>> fct) {
        return str -> ((Optional)fct.apply((String)str)).map(IWrapper::getRaw).map(class_2561.class::cast);
    }

    @NotNull
    protected class_2561[] getTooltips(@Nullable String category, @NotNull String fieldName, int count) {
        return (class_2561[])this.getTooltipsInternal(category, fieldName, count).map(IWrapper::getRaw).map(class_2561.class::cast).toArray(class_2561[]::new);
    }
}

