/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.objects.blocks;

import andrews.swampier_swamps.config.SSConfigs;
import andrews.swampier_swamps.registry.SSBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class FertileFarmlandBlock
extends FarmBlock {
    public FertileFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!level.f_46443_ && ForgeHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)((Block)SSBlocks.DECAYING_KELP.get()).m_49966_(), (float)fallDistance, (Entity)entity)) {
            FertileFarmlandBlock.turnToDecayingKelp(state, level, pos);
        }
        entity.m_142535_(fallDistance, 1.0f, DamageSource.f_19315_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)SSBlocks.DECAYING_KELP.get()).m_49966_() : this.m_49966_();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            FertileFarmlandBlock.turnToDecayingKelp(state, (Level)level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int moisture = (Integer)state.m_61143_((Property)f_53243_);
        if (!FertileFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.m_46758_(pos.m_7494_())) {
            if (moisture > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!FertileFarmlandBlock.isUnderCrops((BlockGetter)level, pos)) {
                FertileFarmlandBlock.turnToDecayingKelp(state, (Level)level, pos);
            }
        } else if (moisture < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public static void turnToDecayingKelp(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, FertileFarmlandBlock.m_49897_((BlockState)state, (BlockState)((Block)SSBlocks.DECAYING_KELP.get()).m_49966_(), (LevelAccessor)level, (BlockPos)pos));
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        int waterRange = SSConfigs.commonConfig.waterRange.get();
        BlockState state = level.m_8055_(pos);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-waterRange, 0, -waterRange), (BlockPos)pos.m_7918_(waterRange, 1, waterRange))) {
            if (!state.canBeHydrated((BlockGetter)level, pos, level.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    private static boolean isUnderCrops(BlockGetter level, BlockPos pos) {
        BlockState plant = level.m_8055_(pos.m_7494_());
        BlockState state = level.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(level, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }
}

