/*
 * Decompiled with CFR 0.152.
 */
package com.kljiana.bettertime;

import com.kljiana.bettertime.config.Config;
import mcjty.incontrol.data.DataStorage;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="bettertime")
public class BetterTime {
    public static final String MODID = "bettertime";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"bettertime");

    public BetterTime() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.configSpec);
    }

    public static int getTodayTime(Level pLevel) {
        return (int)(pLevel.m_46468_() % 24000L);
    }

    public static long getDays(Level pLevel) {
        return pLevel.m_46468_() / 24000L;
    }

    public static long getHours(Level pLevel) {
        return pLevel.m_46468_() % 24000L / 1000L;
    }

    public static long getMinutes(Level pLevel) {
        return pLevel.m_46468_() % 1000L * 60L / 1000L;
    }

    public static int queryTime(CommandSourceStack pSource) {
        ServerLevel level = pSource.m_81372_();
        pSource.m_81354_((Component)Component.m_237113_((String)("[\u00a7a" + Component.m_237115_((String)"mod.bettertime").getString() + "\u00a7r]" + Component.m_237110_((String)"commands.bettertime.query", (Object[])new Object[]{BetterTime.getDays((Level)level), BetterTime.getHours((Level)level), BetterTime.getMinutes((Level)level), BetterTime.getTodayTime((Level)level), level.m_46467_()}).getString())), true);
        return 0;
    }

    public static int setTime(CommandSourceStack pSource, long pTime) {
        return BetterTime.setTime(pSource, pTime, BetterTime.getDays((Level)pSource.m_81372_()));
    }

    public static int setTime(CommandSourceStack pSource, long pTime, long days) {
        ServerLevel level = pSource.m_81372_();
        for (ServerLevel serverlevel : pSource.m_81377_().m_129785_()) {
            serverlevel.m_8615_(days * 24000L + pTime);
        }
        BetterTime.inControlSetDay((Level)level, days);
        pSource.m_81354_((Component)Component.m_237113_((String)("[\u00a7a" + Component.m_237115_((String)"mod.bettertime").getString() + "\u00a7r]" + Component.m_237110_((String)"commands.bettertime.set", (Object[])new Object[]{days, BetterTime.getHours((Level)level), BetterTime.getMinutes((Level)level), pTime}).getString())), true);
        return BetterTime.getTodayTime((Level)pSource.m_81372_());
    }

    public static int setDay(CommandSourceStack pSource, long days) {
        ServerLevel level = pSource.m_81372_();
        long pTime = BetterTime.getTodayTime((Level)pSource.m_81372_());
        for (ServerLevel serverlevel : pSource.m_81377_().m_129785_()) {
            serverlevel.m_8615_(days * 24000L + pTime);
        }
        BetterTime.inControlSetDay((Level)level, days);
        pSource.m_81354_((Component)Component.m_237113_((String)("[\u00a7a" + Component.m_237115_((String)"mod.bettertime").getString() + "\u00a7r]" + Component.m_237110_((String)"commands.bettertime.set", (Object[])new Object[]{days, BetterTime.getHours((Level)level), BetterTime.getMinutes((Level)level), pTime}).getString())), true);
        return BetterTime.getTodayTime((Level)pSource.m_81372_());
    }

    public static void inControlSetDay(Level level, long days) {
        if (ModList.get().isLoaded("incontrol")) {
            DataStorage data = DataStorage.getData((Level)level);
            data.setDaycounter((int)days);
        }
    }

    public static int addTime(CommandSourceStack pSource, int pAmount) {
        return BetterTime.addTime(pSource, pAmount, BetterTime.getDays((Level)pSource.m_81372_()));
    }

    public static int addTime(CommandSourceStack pSource, int pAmount, long days) {
        ServerLevel level = pSource.m_81372_();
        for (ServerLevel serverlevel : pSource.m_81377_().m_129785_()) {
            serverlevel.m_8615_(serverlevel.m_46468_() + (long)pAmount);
        }
        int i = BetterTime.getTodayTime((Level)pSource.m_81372_());
        pSource.m_81354_((Component)Component.m_237113_((String)("[\u00a7a" + Component.m_237115_((String)"mod.bettertime").getString() + "\u00a7r]" + Component.m_237110_((String)"commands.bettertime.set", (Object[])new Object[]{days, BetterTime.getHours((Level)level), BetterTime.getMinutes((Level)level), i}).getString())), true);
        return i;
    }
}

