/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import untamedwilds.block.CritterBurrowBlock;
import untamedwilds.block.blockentity.CritterBurrowBlockEntity;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.ISpecies;
import untamedwilds.init.ModBlock;
import untamedwilds.world.FaunaHandler;
import untamedwilds.world.FaunaSpawn;

public class FeatureCritterBurrow
extends Feature<NoneFeatureConfiguration> {
    public FeatureCritterBurrow(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext context) {
        RandomSource rand = context.m_159774_().m_213780_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        if (((List)ConfigMobControl.dimensionBlacklist.get()).contains(world.m_6018_().m_46472_().m_135782_().toString())) {
            return false;
        }
        int i = rand.m_188503_(8) - rand.m_188503_(8);
        int j = rand.m_188503_(8) - rand.m_188503_(8);
        Optional entry = WeightedRandom.m_216822_((RandomSource)rand, FaunaHandler.getSpawnableList(FaunaHandler.animalType.CRITTER));
        if (entry.isPresent()) {
            if (((Boolean)ConfigFeatureControl.addBurrows.get()).booleanValue()) {
                int k = world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_() + i, pos.m_123343_() + j);
                pos = new BlockPos(pos.m_123341_() + i, k, pos.m_123343_() + j);
                Entity entity = ((FaunaHandler.SpawnListEntry)((Object)entry.get())).entityType.m_20615_((Level)world.m_6018_());
                int variant = -1;
                if (entity != null && FeatureCritterBurrow.isReplaceablePlant((LevelSimulatedReader)world, pos)) {
                    if (!world.m_6425_(pos).m_76178_() && !(entity instanceof ComplexMobAmphibious)) {
                        return false;
                    }
                    if (entity instanceof ISpecies && (variant = ((ISpecies)entity).setSpeciesByBiome((Holder<Biome>)world.m_204166_(pos), MobSpawnType.CHUNK_GENERATION)) == 99) {
                        entity.m_146870_();
                        return false;
                    }
                    if (world.m_7702_(pos) == null) {
                        world.m_7731_(pos, (BlockState)((Block)ModBlock.BURROW.get()).m_49966_().m_61124_((Property)CritterBurrowBlock.WATERLOGGED, (Comparable)Boolean.valueOf(!world.m_6425_(pos).m_76178_())), 2);
                        world.m_46865_(pos).m_8113_(pos.m_7495_());
                        if (world.m_8055_(pos).m_60734_() == ModBlock.BURROW.get()) {
                            CritterBurrowBlockEntity te = (CritterBurrowBlockEntity)world.m_7702_(pos);
                            if (te != null) {
                                te.setCount(Math.max(4, ((FaunaHandler.SpawnListEntry)((Object)entry.get())).getGroupCount() * (rand.m_188503_(3) + 1)));
                                te.setEntityType(((FaunaHandler.SpawnListEntry)((Object)entry.get())).entityType);
                                if (variant >= 0) {
                                    te.setVariant(variant);
                                }
                            }
                            entity.m_146870_();
                            return true;
                        }
                    }
                }
            } else {
                EntityType<?> type = ((FaunaHandler.SpawnListEntry)((Object)entry.get())).entityType;
                if (FaunaSpawn.performWorldGenSpawning(type, SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.WORLD_SURFACE_WG, (ServerLevelAccessor)world, pos, rand, ((FaunaHandler.SpawnListEntry)((Object)entry.get())).getGroupCount())) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader p_67289_, BlockPos p_67290_) {
        return p_67289_.m_7433_(p_67290_, p_160551_ -> {
            Material material = p_160551_.m_60767_();
            return material == Material.f_76302_ || material == Material.f_76296_;
        });
    }
}

