/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.world.UntamedWildsBiomeModifier;
import untamedwilds.world.gen.feature.FeatureApexPredators;
import untamedwilds.world.gen.feature.FeatureCritterBurrow;
import untamedwilds.world.gen.feature.FeatureDenseWater;
import untamedwilds.world.gen.feature.FeatureFloatingPlants;
import untamedwilds.world.gen.feature.FeatureHerbivores;
import untamedwilds.world.gen.feature.FeatureOceanSessileSpawns;
import untamedwilds.world.gen.feature.FeatureOceanSwimming;
import untamedwilds.world.gen.feature.FeatureReedClusters;
import untamedwilds.world.gen.feature.FeatureSeaAnemone;
import untamedwilds.world.gen.feature.FeatureUndergroundFaunaLarge;
import untamedwilds.world.gen.feature.FeatureUnderwaterAlgae;
import untamedwilds.world.gen.feature.FeatureVegetation;

@Mod.EventBusSubscriber(modid="untamedwilds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class UntamedWildsGenerator {
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"untamedwilds");
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"untamedwilds");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"untamedwilds");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATION = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"untamedwilds");
    public static final Map<String, Float> biodiversity_levels = new HashMap<String, Float>();
    private static final RegistryObject<Feature<CountConfiguration>> SEA_ANEMONE = UntamedWildsGenerator.regFeature("sea_anemone", () -> new FeatureSeaAnemone((Codec<CountConfiguration>)CountConfiguration.f_67568_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> REEDS = UntamedWildsGenerator.regFeature("reeds", () -> new FeatureReedClusters((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> ALGAE = UntamedWildsGenerator.regFeature("algae", () -> new FeatureUnderwaterAlgae((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> VEGETATION = UntamedWildsGenerator.regFeature("vegetation", () -> new FeatureVegetation((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> FLOATING_VEGETATION = UntamedWildsGenerator.regFeature("floating_vegetation", () -> new FeatureFloatingPlants((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<TreeDecoratorType<?>> TREE_ORCHID = TREE_DECORATION.register("orchid", () -> new TreeDecoratorType(TreeDecorator.f_70021_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> UNDERGROUND = UntamedWildsGenerator.regFeature("underground", () -> new FeatureUndergroundFaunaLarge((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<ConfiguredFeature<?, ?>> UNDERGROUND_CONFIGURED = CONFIGURED_FEATURES.register("underground", () -> new ConfiguredFeature((Feature)UNDERGROUND.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> APEX = UntamedWildsGenerator.regFeature("apex_predator", () -> new FeatureApexPredators((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> HERBIVORES = UntamedWildsGenerator.regFeature("herbivores", () -> new FeatureHerbivores((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> SESSILE = UntamedWildsGenerator.regFeature("sessile", () -> new FeatureOceanSessileSpawns((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> OCEAN = UntamedWildsGenerator.regFeature("ocean_rare", () -> new FeatureOceanSwimming((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> DENSE_WATER = UntamedWildsGenerator.regFeature("dense_water", () -> new FeatureDenseWater((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> CRITTER_BURROW = UntamedWildsGenerator.regFeature("burrow", () -> new FeatureCritterBurrow((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    private static <B extends Feature<?>> RegistryObject<B> regFeature(String name, Supplier<? extends B> supplier) {
        return FEATURES.register(name, supplier);
    }

    public static Map<ResourceLocation, BiomeModifier> generateModifierByLocation(RegistryOps<JsonElement> registryOps) {
        HashMap<ResourceLocation, BiomeModifier> map = new HashMap<ResourceLocation, BiomeModifier>();
        UntamedWildsGenerator.addFeature(map, "sessile", new Builder(registryOps, new ConfiguredFeature((Feature)SESSILE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqSessile.get()))).tag(Arrays.asList(BiomeTags.f_207603_)).decoration(GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        UntamedWildsGenerator.addFeature(map, "ocean_rare", new Builder(registryOps, new ConfiguredFeature((Feature)OCEAN.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqOcean.get()))).tag(Arrays.asList(BiomeTags.f_207603_)).decoration(GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        UntamedWildsGenerator.addFeature(map, "sea_anemone", new Builder(registryOps, new ConfiguredFeature((Feature)SEA_ANEMONE.get(), (FeatureConfiguration)new CountConfiguration(4)), "gencontrol.anemone").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)6)).blacklist(Arrays.asList(Biomes.f_48211_, Biomes.f_48172_)).decoration(GenerationStep.Decoration.VEGETAL_DECORATION));
        UntamedWildsGenerator.addFeature(map, "floating_vegetation", new Builder(registryOps, new ConfiguredFeature((Feature)FLOATING_VEGETATION.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "gencontrol.algae").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqAlgae.get()))).tag(Arrays.asList(BiomeTags.f_207610_)).decoration(GenerationStep.Decoration.VEGETAL_DECORATION));
        UntamedWildsGenerator.addFeature(map, "reeds", new Builder(registryOps, new ConfiguredFeature((Feature)REEDS.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "gencontrol.reeds").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqReeds.get()))).blacklist(((List)ConfigFeatureControl.reedBlacklist.get()).stream().map(s -> ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s))).collect(Collectors.toList())).decoration(GenerationStep.Decoration.VEGETAL_DECORATION));
        UntamedWildsGenerator.addFeature(map, "algae", new Builder(registryOps, new ConfiguredFeature((Feature)ALGAE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "gencontrol.algae").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqAlgae.get()))).blacklist(((List)ConfigFeatureControl.algaeBlacklist.get()).stream().map(s -> ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s))).collect(Collectors.toList())).decoration(GenerationStep.Decoration.VEGETAL_DECORATION));
        UntamedWildsGenerator.addFeature(map, "vegetation", new Builder(registryOps, new ConfiguredFeature((Feature)VEGETATION.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(0.25f)), "gencontrol.bush").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqFlora.get()))).blacklist(((List)ConfigFeatureControl.floraBlacklist.get()).stream().map(s -> ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s))).collect(Collectors.toList())).decoration(GenerationStep.Decoration.VEGETAL_DECORATION));
        UntamedWildsGenerator.addFeature(map, "dense_water", new Builder(registryOps, new ConfiguredFeature((Feature)DENSE_WATER.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqWater.get()))).decoration(GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        UntamedWildsGenerator.addFeature(map, "burrow", new Builder(registryOps, new ConfiguredFeature((Feature)CRITTER_BURROW.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqCritter.get()))).decoration(GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        UntamedWildsGenerator.addFeature(map, "apex_predator", new Builder(registryOps, new ConfiguredFeature((Feature)APEX.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqApex.get()))).decoration(GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        UntamedWildsGenerator.addFeature(map, "herbivores", new Builder(registryOps, new ConfiguredFeature((Feature)HERBIVORES.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), "").placementModifier((PlacementModifier)RarityFilter.m_191900_((int)((Integer)ConfigFeatureControl.freqHerbivores.get()))).decoration(GenerationStep.Decoration.TOP_LAYER_MODIFICATION));
        UntamedWildsGenerator.addFeature(map, "underground", new Builder(registryOps, (ConfiguredFeature)UNDERGROUND_CONFIGURED.get(), "mobcontrol.masterspawner").tag(Arrays.asList(Tags.Biomes.IS_UNDERGROUND)).decoration(GenerationStep.Decoration.UNDERGROUND_DECORATION).placementModifiers(FeatureUndergroundFaunaLarge.placed()));
        return map;
    }

    private static void addFeature(Map<ResourceLocation, BiomeModifier> map, String placedFeatureName, Builder builder) {
        UntamedWildsBiomeModifier modifier = builder.build();
        ResourceLocation location = new ResourceLocation("untamedwilds", placedFeatureName);
        map.put(location, modifier);
    }

    @SubscribeEvent
    public static void data(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        RegistryOps registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        Map<ResourceLocation, BiomeModifier> featureGenMap = UntamedWildsGenerator.generateModifierByLocation((RegistryOps<JsonElement>)registryOps);
        JsonCodecProvider jsonCodecProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)gen, (ExistingFileHelper)helper, (String)"untamedwilds", (RegistryOps)registryOps, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, featureGenMap);
        gen.m_236039_(event.includeServer(), (DataProvider)jsonCodecProvider);
    }

    public static float getBioDiversityLevel(ResourceLocation biome) {
        String key = biome.m_135815_();
        if (biodiversity_levels.containsKey(key)) {
            return biodiversity_levels.get(key).floatValue();
        }
        return 0.6f;
    }

    private static class Builder {
        private final ConfiguredFeature<?, ?> placedFeatureName;
        private TagKey<Biome> dimension = BiomeTags.f_215817_;
        private final List<PlacementModifier> placementModifiers = new ArrayList<PlacementModifier>();
        private final List<TagKey<Biome>> biomeTags = new ArrayList<TagKey<Biome>>();
        private final List<Holder<Biome>> blacklist = new ArrayList<Holder<Biome>>();
        private final List<Holder<Biome>> extraBiomes = new ArrayList<Holder<Biome>>();
        private final RegistryOps<JsonElement> registryOps;
        private GenerationStep.Decoration decoration = GenerationStep.Decoration.VEGETAL_DECORATION;
        private final String configOption;

        public Builder(RegistryOps<JsonElement> registryOps, ConfiguredFeature<?, ?> placedFeature, String configOption) {
            this.registryOps = registryOps;
            this.placedFeatureName = placedFeature;
            this.configOption = configOption;
        }

        public Builder dimension(TagKey<Biome> tag) {
            this.dimension = tag;
            return this;
        }

        public Builder placementModifier(PlacementModifier placementModifier) {
            this.placementModifiers.add(placementModifier);
            return this;
        }

        public Builder placementModifiers(List<PlacementModifier> placementModifiers) {
            this.placementModifiers.addAll(placementModifiers);
            return this;
        }

        public Builder tag(List<TagKey<Biome>> tags) {
            this.biomeTags.addAll(tags);
            return this;
        }

        public Builder blacklist(List<ResourceKey<Biome>> biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                this.blacklist.add((Holder<Biome>)((Holder)((Registry)this.registryOps.m_206826_(Registry.f_122885_).get()).m_203636_(biome).get()));
            }
            return this;
        }

        public Builder extraBiomes(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                this.extraBiomes.add((Holder<Biome>)((Holder)((Registry)this.registryOps.m_206826_(Registry.f_122885_).get()).m_203636_(biome).get()));
            }
            return this;
        }

        public Builder decoration(GenerationStep.Decoration decoration) {
            this.decoration = decoration;
            return this;
        }

        private static HolderSet<Biome> getBiomesByTag(RegistryOps<JsonElement> registryOps, TagKey<Biome> tag) {
            return new HolderSet.Named((Registry)registryOps.m_206826_(Registry.f_122885_).get(), tag);
        }

        public UntamedWildsBiomeModifier build() {
            ArrayList<HolderSet<Biome>> biomesSet = new ArrayList<HolderSet<Biome>>(this.biomeTags.stream().map(tag -> Builder.getBiomesByTag(this.registryOps, (TagKey<Biome>)tag)).collect(Collectors.toList()));
            ArrayList<HolderSet<Biome>> blacklistSet = new ArrayList<HolderSet<Biome>>();
            blacklistSet.add((HolderSet<Biome>)HolderSet.m_205800_(this.blacklist));
            Holder placedFeature = Holder.m_205709_((Object)new PlacedFeature(Holder.m_205709_(this.placedFeatureName), this.placementModifiers));
            return new UntamedWildsBiomeModifier(this.dimension, biomesSet, blacklistSet, this.decoration, (Holder<PlacedFeature>)placedFeature, this.configOption);
        }
    }
}

