/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import untamedwilds.util.JSONLoader;
import untamedwilds.util.SpawnDataHolder;
import untamedwilds.world.FaunaHandler;

@Mod.EventBusSubscriber(modid="untamedwilds")
public class SpawnDataListenerEvent {
    public static final JSONLoader<SpawnDataHolder> SPAWN_DATA_HOLDER = new JSONLoader<SpawnDataHolder>("spawn_tables", SpawnDataHolder.CODEC);
    public static SpawnDataHolder CRITTER;
    public static SpawnDataHolder HERBIVORES;
    public static SpawnDataHolder PREDATORS;
    public static SpawnDataHolder BENTHOS;
    public static SpawnDataHolder WATER_OCEAN;
    public static SpawnDataHolder WATER_RIVER;
    public static SpawnDataHolder UNDERGROUND;
    public static SpawnDataHolder FEEDER;

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(SPAWN_DATA_HOLDER);
        SpawnDataListenerEvent.registerData();
    }

    private static void registerData() {
        CRITTER = SpawnDataListenerEvent.registerSpawnData("critter");
        HERBIVORES = SpawnDataListenerEvent.registerSpawnData("herbivores");
        PREDATORS = SpawnDataListenerEvent.registerSpawnData("predators");
        BENTHOS = SpawnDataListenerEvent.registerSpawnData("benthos");
        WATER_OCEAN = SpawnDataListenerEvent.registerSpawnData("water_ocean");
        WATER_RIVER = SpawnDataListenerEvent.registerSpawnData("water_river");
        UNDERGROUND = SpawnDataListenerEvent.registerSpawnData("underground");
        FEEDER = SpawnDataListenerEvent.registerSpawnData("feeder");
    }

    public static SpawnDataHolder registerSpawnData(String nameIn) {
        if (SPAWN_DATA_HOLDER.getData(new ResourceLocation("untamedwilds", nameIn)) != null) {
            SpawnDataHolder data = SPAWN_DATA_HOLDER.getData(new ResourceLocation("untamedwilds", nameIn));
            if (FaunaHandler.getSpawnableList(nameIn) != null) {
                List<FaunaHandler.SpawnListEntry> spawn_list = FaunaHandler.getSpawnableList(nameIn);
                if (!spawn_list.isEmpty()) {
                    spawn_list.addAll(data.getEntries());
                }
                return data;
            }
        }
        return null;
    }
}

