/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMob;
import untamedwilds.init.ModEntity;
import untamedwilds.network.SyncTextureData;
import untamedwilds.network.UntamedInstance;
import untamedwilds.util.EntityDataHolder;
import untamedwilds.util.EntityDataHolderClient;
import untamedwilds.util.EntityUtils;
import untamedwilds.util.JSONLoader;
import untamedwilds.util.SpeciesDataHolder;

@Mod.EventBusSubscriber(modid="untamedwilds")
public class EntityDataListenerEvent {
    public static final JSONLoader<EntityDataHolder> ENTITY_DATA_HOLDERS = new JSONLoader<EntityDataHolder>("entities", EntityDataHolder.CODEC);
    private static boolean isLoaded = false;

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ENTITY_DATA_HOLDERS);
        EntityDataListenerEvent.registerData();
    }

    public static void registerData() {
        for (RegistryObject entity : ModEntity.ENTITIES.getEntries()) {
            EntityDataListenerEvent.registerEntityData((EntityType)entity.get());
        }
        isLoaded = true;
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        UntamedWilds.LOGGER.info("Firing player login event");
        EntityDataListenerEvent.registerData();
        for (EntityType<?> types : ComplexMob.ENTITY_DATA_HASH.keySet()) {
            ResourceLocation entityName = types.m_204041_().m_205785_().m_135782_();
            int size = 0;
            for (SpeciesDataHolder speciesData : ComplexMob.ENTITY_DATA_HASH.get(types).getSpeciesData()) {
                UntamedInstance.sendToClient(new SyncTextureData(entityName, speciesData.getName(), speciesData.getSkins(), size++), (ServerPlayer)event.getEntity());
            }
        }
    }

    public static boolean isEntityDataLoaded() {
        return isLoaded;
    }

    public static EntityDataHolder registerEntityData(EntityType<?> typeIn) {
        String nameIn = Objects.requireNonNull(typeIn.m_204041_().m_205785_().m_135782_()).m_135815_();
        if (ENTITY_DATA_HOLDERS.getData(new ResourceLocation("untamedwilds", nameIn)) != null) {
            EntityDataHolder data = ENTITY_DATA_HOLDERS.getData(new ResourceLocation("untamedwilds", nameIn));
            EntityDataListenerEvent.processData(data, typeIn);
            return data;
        }
        return null;
    }

    private static void processData(EntityDataHolder dataIn, EntityType<?> typeIn) {
        ComplexMob.ENTITY_DATA_HASH.put(typeIn, dataIn);
        EntityDataListenerEvent.processSkins(dataIn, typeIn.m_204041_().m_205785_().m_135782_().m_135815_());
        for (SpeciesDataHolder speciesData : ComplexMob.ENTITY_DATA_HASH.get(typeIn).getSpeciesData()) {
            if (!ComplexMob.CLIENT_DATA_HASH.containsKey(typeIn)) {
                ComplexMob.CLIENT_DATA_HASH.put(typeIn, new EntityDataHolderClient(new HashMap<Integer, Map<String, SoundEvent>>(), new HashMap<Integer, String>()));
            }
            ComplexMob.CLIENT_DATA_HASH.get(typeIn).species_data.put(speciesData.getVariant(), speciesData.getName());
        }
    }

    private static void processSkins(EntityDataHolder dataIn, String nameIn) {
        for (SpeciesDataHolder speciesDatum : dataIn.getSpeciesData()) {
            EntityUtils.buildSkinArrays(nameIn, speciesDatum.getName().toLowerCase(), dataIn, speciesDatum.getVariant(), ComplexMob.TEXTURES_COMMON, ComplexMob.TEXTURES_RARE);
        }
    }
}

