/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMob;
import untamedwilds.util.EntityUtils;
import untamedwilds.util.ModCreativeModeTab;

public class MobBucketedItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> entity;

    public MobBucketedItem(Supplier<? extends EntityType<?>> typeIn, Fluid fluid, Item.Properties builder) {
        super(() -> fluid, builder);
        this.entity = typeIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(this.entity.get())) {
            EntityUtils.buildTooltipData(stack, tooltip, this.entity.get(), EntityUtils.getVariantName(this.entity.get(), this.getSpecies(stack)));
        }
    }

    public Component m_7626_(ItemStack stack) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents("item.untamedwilds.bucket_" + EntityUtils.getRegistryName(this.entity.get()) + "_" + EntityUtils.getVariantName(this.entity.get(), this.getSpecies(stack))));
    }

    public void m_142131_(@Nullable Player playerIn, Level worldIn, ItemStack itemStackIn, BlockPos posIn) {
        if (worldIn instanceof ServerLevel) {
            this.spawn(worldIn, itemStackIn, posIn);
            worldIn.m_142346_((Entity)playerIn, GameEvent.f_157810_, posIn);
        }
    }

    public void spawn(Level worldIn, ItemStack itemStack, BlockPos pos) {
        if (worldIn instanceof ServerLevel) {
            EntityType<?> entity = EntityUtils.getEntityTypeFromTag(itemStack.m_41783_(), this.entity.get());
            EntityUtils.createMobFromItem((ServerLevel)worldIn, itemStack, entity, this.getSpecies(itemStack), pos, null, false);
        }
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor worldIn, BlockPos pos) {
        worldIn.m_5594_(player, pos, SoundEvents.f_11779_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private int getSpecies(ItemStack itemIn) {
        if (itemIn.m_41783_() != null && itemIn.m_41783_().m_128441_("CustomModelData")) {
            return itemIn.m_41783_().m_128451_("CustomModelData");
        }
        UntamedWilds.LOGGER.error("No variant found in this itemstack NBT data");
        return 0;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (group == ModCreativeModeTab.untamedwilds_items) {
            for (int i = 0; i < EntityUtils.getNumberOfSpecies(this.entity.get()); ++i) {
                CompoundTag baseTag = new CompoundTag();
                ItemStack item = new ItemStack((ItemLike)this);
                baseTag.m_128405_("variant", i);
                baseTag.m_128405_("CustomModelData", i);
                item.m_41751_(baseTag);
                items.add((Object)item);
            }
        }
    }
}

