/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.arthropod;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.common.ForgeMod;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.util.EntityUtils;

public class EntityKingCrab
extends ComplexMobAmphibious
implements ISpecies,
INewSkins,
IAnimatedEntity {
    private int animationTick;
    private Animation currentAnimation;
    public static Animation EAT_LEFT;
    public static Animation EAT_RIGHT;
    public static Animation EAT_BOTH;

    public EntityKingCrab(EntityType<? extends EntityKingCrab> type, Level worldIn) {
        super(type, worldIn);
        EAT_LEFT = Animation.create((int)56);
        EAT_RIGHT = Animation.create((int)56);
        EAT_BOTH = Animation.create((int)80);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityKingCrab.getEcoLevel(input) > EntityKingCrab.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 240));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public float m_5610_(BlockPos p_149140_, LevelReader p_149141_) {
        return 0.0f;
    }

    @Override
    public boolean wantsToBeOnLand() {
        return this.f_19853_.m_46758_(this.m_20183_());
    }

    @Override
    public boolean wantsToBeInWater() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.breed();
            }
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
            if (this.m_20069_() && this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_204336_(BlockTags.f_144283_) && this.getCommandInt() == 0) {
                int i = this.f_19796_.m_188503_(3000);
                if (i > 2940 && i < 2960) {
                    this.setAnimation(EAT_RIGHT);
                }
                if (i > 2960 && i < 2980) {
                    this.setAnimation(EAT_LEFT);
                }
                if (i > 2980) {
                    this.setAnimation(EAT_BOTH);
                }
            }
            if (this.getAnimation() != NO_ANIMATION && ((this.getAnimation() == EAT_LEFT || this.getAnimation() == EAT_RIGHT) && this.getAnimationTick() == 20 || this.getAnimation() == EAT_BOTH && (this.getAnimationTick() == 20 || this.getAnimationTick() == 44))) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, this.f_19853_.m_8055_(this.m_20183_().m_7495_())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.0, 0.0, 0.0, (double)0.15f);
                this.m_5496_(SoundEvents.f_12406_, 0.2f, 0.7f);
            }
        }
        if (this.f_19853_.m_5776_()) {
            // empty if block
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.m_20069_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityKingCrab.class, this.m_20191_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntityKingCrab)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_king_crab", this.getOffspring());
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && itemstack.m_41720_().equals(Items.f_42447_) && this.m_6084_()) {
            EntityUtils.mutateEntityIntoItem((LivingEntity)this, player, hand, "bucket_king_crab", itemstack);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.currentAnimation;
    }

    @Override
    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, EAT_RIGHT, EAT_LEFT, EAT_BOTH};
    }
}

